# セキュリティ設計書

## 概要

本ドキュメントは、LLVMプロジェクトにおけるセキュリティ設計について記載する。LLVMはコンパイラ基盤プロジェクトであり、一般的なWebアプリケーションとは異なるセキュリティモデルを持つ。本プロジェクトは、セキュリティ脆弱性の検出・防止機能をコンパイラレベルで提供することに重点を置いている。

**注意**: LLVMのツール（clang、llvm-opt等）は、悪意のある入力に対して堅牢化されていない。コンパイラツール自体のバッファオーバーリードやクラッシュは、セキュリティ脆弱性としては扱われない。

## 認証設計

### 認証方式

LLVMプロジェクトはコンパイラツールチェーンであり、従来の認証システムは該当しない。ただし、以下のセキュリティ報告メカニズムが存在する。

| 機能 | 説明 |
| --- | --- |
| セキュリティ報告チャネル | GitHubのvulnerability reporting機能を使用 |
| LLVM Security Response Group | セキュリティ問題の調査・修正を担当する信頼されたメンバーで構成 |
| CVEプロセス | 重大な脆弱性に対してCVE発行を実施 |

### セッション管理

本プロジェクトはコンパイラツールであり、セッション管理は該当しない。

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション有効期限 | N/A | コンパイラツールであり該当なし |
| セッション固定化対策 | N/A | コンパイラツールであり該当なし |

## 認可設計

### 権限体系

LLVMプロジェクトでは、セキュリティ報告に関する権限体系が定義されている。

| ロール | 権限 | 説明 |
| --- | --- | --- |
| Security Response Group Member | セキュリティ問題へのアクセス・議論・修正 | 信頼されたLLVMコントリビューターで構成 |
| Individual Contributor | セキュリティ脆弱性の発見・報告 | セキュリティ問題の報告者 |
| Vendor Contact | エンバーゴ期間中の修正情報へのアクセス | LLVMベースの製品を出荷する組織の代表 |

### アクセス制御

セキュリティ問題の開示制御:
- デフォルトで90日間のエンバーゴ期間を設定
- すべてのベンダーが修正をデプロイした場合、エンバーゴを早期解除可能
- 修正がLLVMリポジトリにマージされてから約14週間後に議論を公開

## 通信セキュリティ

| 項目 | 対策 |
| --- | --- |
| HTTPS | GitHubインフラストラクチャにより保護 |
| HSTS | GitHubインフラストラクチャにより保護 |

## データセキュリティ

### 暗号化

LLVMが提供するセキュリティ機能として、以下の暗号化関連機能がある。

| 対象 | 暗号化方式 |
| --- | --- |
| Pointer Authentication | AArch64 PAuth命令による暗号学的ハッシュでポインタを署名 |
| Scudo Header Checksum | CRC32によるヒープヘッダーの整合性検証 |

### 機密情報管理

LLVMプロジェクトでは、脆弱性情報を機密として管理する:
- セキュリティ問題はエンバーゴ期間中は非公開で議論
- 脆弱性報告に含まれる機密データ（例: ユーザー名/パスワードペア）は公開時に除外
- プライベートメーリングリストでの機密議論

## 入出力対策

LLVMプロジェクトは、コンパイラが生成するバイナリのセキュリティを強化する複数の仕組みを提供する。

### スタック保護機能

| 脅威 | 対策 | 説明 |
| --- | --- | --- |
| Stack Buffer Overflow | SafeStack | スタックをsafe stackとunsafe stackに分離し、バッファオーバーフローからリターンアドレスを保護 |
| Stack Smashing | Stack Canaries | スタックカナリアによるオーバーフロー検出 |

### メモリ安全性機能

| 脅威 | 対策 | 説明 |
| --- | --- | --- |
| Use-After-Free | GWP-ASan | サンプリングベースのメモリエラー検出（本番環境向け） |
| Heap Buffer Overflow | GWP-ASan | ガードページによるバッファオーバーフロー検出 |
| Heap Corruption | Scudo Hardened Allocator | ヒープメタデータの整合性検証・クアランティン機能 |

### 制御フロー保護機能

| 脅威 | 対策 | 説明 |
| --- | --- | --- |
| Control-Flow Hijacking | CFI (Control Flow Integrity) | 間接呼び出しの正当性検証 |
| Return-Oriented Programming | SafeStack | リターンアドレスの保護 |
| Spectre Variant #1 | Speculative Load Hardening | 投機的実行攻撃からの保護 |
| Pointer Tampering | Pointer Authentication | AArch64でのポインタ署名・検証 |

### セキュリティコンパイラフラグ

| フラグ | 機能 |
| --- | --- |
| `-fsanitize=safe-stack` | SafeStackの有効化 |
| `-fsanitize=cfi` | Control Flow Integrityの有効化 |
| `-fsanitize=scudo` | Scudo Hardened Allocatorの有効化 |
| `-mspeculative-load-hardening` | Speculative Load Hardeningの有効化 |

## Control Flow Integrity (CFI) 詳細

### 利用可能なCFIスキーム

| スキーム | 説明 |
| --- | --- |
| cfi-vcall | 仮想呼び出しのvptrが正しい動的型であることを検証 |
| cfi-nvcall | 非仮想呼び出しのオブジェクトが正しい動的型であることを検証 |
| cfi-derived-cast | Base-to-derivedキャストの正当性検証 |
| cfi-unrelated-cast | void*からのキャストの正当性検証 |
| cfi-icall | 間接関数呼び出しの型検証 |
| cfi-mfcall | メンバ関数ポインタ呼び出しの検証 |
| kcfi | LTOを必要としないカーネル向けCFI |

### CFIパフォーマンス

- 仮想呼び出しCFI: Chromiumで1%未満のオーバーヘッド
- バイナリサイズ: 最大15%増加

## SafeStack 詳細

### 設計原理

SafeStackは、プログラムスタックを2つの領域に分離する:

| スタック種別 | 格納内容 |
| --- | --- |
| Safe Stack | リターンアドレス、レジスタスピル、安全にアクセスされるローカル変数 |
| Unsafe Stack | それ以外すべて（大きな配列、アドレスが取得される変数等） |

### セキュリティ特性

- スタックベースのバッファオーバーフローからの保護
- ASLR依存のランダム化による追加保護
- パフォーマンスオーバーヘッド: 平均0.1%未満

### 既知の制限

- 完全な制御フローハイジャック保護にはCPIまたはCFIとの併用が必要
- `sigaltstack()`を使用するシグナルハンドラは`no_sanitize("safe-stack")`属性が必要

## Speculative Load Hardening 詳細

### 保護対象

| 攻撃 | 緩和方法 |
| --- | --- |
| Spectre Variant #1 | 分岐予測ミスによる投機的実行をデータ依存性で制御 |
| Bounds Check Bypass | ロードアドレスのハードニング |

### パフォーマンス特性

| ベンチマーク | lfence緩和 | Load Hardening | 速度向上 |
| --- | --- | --- | --- |
| Googleマイクロベンチマーク | -74.8% | -36.4% | 2.5x |
| 大規模サーバーQPS | -62% | -29% | 1.8x |

## Scudo Hardened Allocator 詳細

### セキュリティ機能

| 機能 | 説明 |
| --- | --- |
| Header Checksum | CRC32によるヒープチャンクヘッダーの整合性検証 |
| Quarantine | 解放遅延によるuse-after-free緩和 |
| Guard Pages | Secondary Allocatorでのバッファオーバーフロー検出 |
| Randomization | メモリ割り当ての予測困難性向上 |

### デフォルト採用

- Fuchsia OS
- Android 11以降

## GWP-ASan 詳細

### 設計

- サンプリングベースのアロケータフレームワーク
- 本番環境向けの低オーバーヘッド（約40KiB/プロセス）
- Electric Fence Malloc Debuggerをベースに設計

### 検出可能なバグ

| バグ種別 | 検出方法 |
| --- | --- |
| Use-After-Free | 解放後のガードページ化 |
| Heap Buffer Overflow | 左右のガードページによる検出 |

## Pointer Authentication 詳細

### 対応アーキテクチャ

AArch64（Armv8.3-A以降）

### 利用可能なキー

| キー | 用途 |
| --- | --- |
| ASIA / ASIB | 命令キー |
| ASDA / ASDB | データキー |
| ASGA | 汎用署名キー（sign_generic用） |

### LLVM IR Intrinsics

| Intrinsic | 機能 |
| --- | --- |
| `llvm.ptrauth.sign` | ポインタへの署名 |
| `llvm.ptrauth.auth` | 署名されたポインタの認証 |
| `llvm.ptrauth.strip` | 署名の除去 |
| `llvm.ptrauth.resign` | 再署名 |
| `llvm.ptrauth.blend` | ディスクリミネータのブレンド |

## 監査ログ

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| セキュリティ透明性レポート | 年間のセキュリティ開示サマリー、修正時間統計 | 恒久的（公開） |
| セキュリティ問題議論 | 非公開議論の全履歴 | 修正後約14週間で公開 |
| CVE記録 | 発行されたCVE情報 | 恒久的（公開） |

## セキュリティ問題のスコープ

### セキュリティ問題として扱われるもの

| カテゴリ | 詳細 |
| --- | --- |
| コード生成 | 生成されたバイナリがより簡単に悪用可能になる誤コンパイル |
| ランタイムライブラリ（一部） | 本番バイナリに含まれるランタイムのセキュリティ問題 |

### セキュリティ問題として扱われないもの

| カテゴリ | 詳細 |
| --- | --- |
| 言語フロントエンド | clang、clangd、LLVM optimizerの入力による脆弱性 |
| 開発用サニタイザー | ASan等の開発専用ツール |
| libc/libc++の未定義動作 | ドキュメント化されていないエラー処理 |
| アンワインディング・例外処理 | 不正なデータに対する堅牢化なし |

## 備考

### 関連ドキュメント

- [LLVM Security Response Group](https://llvm.org/docs/Security.html)
- [SafeStack Documentation](https://clang.llvm.org/docs/SafeStack.html)
- [Control Flow Integrity](https://clang.llvm.org/docs/ControlFlowIntegrity.html)
- [Scudo Hardened Allocator](https://llvm.org/docs/ScudoHardenedAllocator.html)
- [GWP-ASan](https://llvm.org/docs/GwpAsan.html)
- [Pointer Authentication](https://clang.llvm.org/docs/PointerAuthentication.html)

### プラットフォームサポート

| 機能 | サポートプラットフォーム |
| --- | --- |
| SafeStack | Linux, NetBSD, FreeBSD, macOS |
| CFI | x86, x86_64, arm, aarch64, wasm |
| Pointer Authentication | AArch64 (Armv8.3-A以降) |
| Scudo | Fuchsia, Android 11+, Linux |
| Speculative Load Hardening | x86 (Haswell以降推奨) |
