---
generated_at: 2026-02-01 23:25:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **カバレッジ目標値**：明確な数値目標の根拠なし
  2. **パフォーマンステスト詳細**：具体的な実行方法の根拠不足
  3. **受入テスト担当者**：リリースエンジニアの役割に関する根拠不足
  4. **テストデータ自動生成スクリプト**：具体的なスクリプト使用方法の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/CMakeLists.txt`（テストフレームワーク、ビルド設定）
- E-02: `llvm/test/lit.cfg.py`（litテストフレームワーク設定）
- E-03: `llvm/unittests/CMakeLists.txt`（GoogleTest単体テスト構成）
- E-04: `.github/workflows/premerge.yaml`（CI/CD設定、プリマージチェック）
- E-05: `.github/workflows/libcxx-build-and-test.yaml`（libc++テストCI設定）
- E-06: `.ci/monolithic-linux.sh`（Linux CIビルドスクリプト）
- E-07: `llvm/test/` ディレクトリ構造（テストファイル形式）
- E-08: `llvm/unittests/` ディレクトリ構造（単体テスト構成）
- E-09: `.github/workflows/` ディレクトリ（各種CIワークフロー）
- E-10: `compiler-rt/test/` ディレクトリ（サニタイザテスト構成）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLVMはモノレポ構成である | E-01 | ○ |
| C-02 | litを統合テストフレームワークとして使用 | E-02 | ○ |
| C-03 | GoogleTestを単体テストフレームワークとして使用 | E-01, E-03 | ○ |
| C-04 | CMake 3.20以上が必要 | E-01 | ○ |
| C-05 | テストファイル形式（.ll, .c, .test等） | E-02 | ○ |
| C-06 | Linux x86_64がCI環境として使用される | E-04, E-06 | ○ |
| C-07 | Windows x64がCI環境として使用される | E-04 | ○ |
| C-08 | macOSがCI環境として使用される | E-04 | ○ |
| C-09 | Linux AArch64がCI環境として使用される | E-04 | ○ |
| C-10 | sccacheがCIで使用される | E-04, E-06 | ○ |
| C-11 | テスト結果がJUnit XML形式で出力される | E-06 | ○ |
| C-12 | ASan/MSan/TSan/UBSanサポート | E-01, E-05 | ○ |
| C-13 | libc++テストは3ステージ構成 | E-05 | ○ |
| C-14 | PRトリガーでCIが実行される | E-04 | ○ |
| C-15 | Linuxビルドタイムアウトは120分 | E-04 | ○ |
| C-16 | Windowsビルドタイムアウトは180分 | E-04 | ○ |
| C-17 | GitHub Issuesで不具合管理 | E-01 | ○ |
| C-18 | 成果物は5日間保持される | E-04 | ○ |
| C-19 | FileCheckがテスト出力検証に使用される | E-02 | ○ |
| C-20 | Ninjaビルドシステムが使用される | E-04, E-06 | ○ |
| C-21 | llvm-premerge-linux-runnersで実行 | E-04 | ○ |
| C-22 | depot-ubuntu-24.04-arm-16で実行 | E-04 | ○ |
| C-23 | cross-project-testsディレクトリが存在 | E-07 | ○ |
| C-24 | LLD使用オプションがある | E-06 | ○ |
| C-25 | カバレッジ目標値が設定されている | **根拠なし** | △ |
| C-26 | パフォーマンステストの具体的実行方法 | **根拠なし** | △ |
| C-27 | 受入テストはリリースエンジニアが担当 | **根拠なし** | △ |
| C-28 | update_test_checks.pyによるテスト生成 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標**: プロジェクト全体で明示的なカバレッジ目標値を定義したドキュメントが見つからなかった
  - 候補：LLVM公式ドキュメント / 開発者ガイドライン / コントリビューターガイド
- **パフォーマンステスト**: ベンチマークの具体的な実行手順や閾値が明確でない
  - 候補：test-suite プロジェクト / llvm-exegesis / パフォーマンスボット
- **受入テスト担当**: リリースプロセスにおける責任者の明確な定義が見つからなかった
  - 候補：リリースドキュメント / リリースマネージャーガイド
- **テスト自動生成**: update_test_checks.pyの存在は確認したが、詳細な使用方法は未確認
  - 候補：llvm/utils/update_test_checks.py / LLVM Testing Guide

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストフレームワーク（lit, GoogleTest）の記載
- 0: 低リスク - CI環境・ワークフローの記載
- 0: 低リスク - サニタイザサポートの記載
- 1: 中リスク - カバレッジ目標の記載（明示的な目標値がない可能性）
- 1: 中リスク - パフォーマンステストの記載（詳細が不明確）
- 1: 中リスク - 受入テスト担当者の記載（組織体制に依存）

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標の記載が「明示的な目標値は設定されていない」で問題ないか確認
- [ ] パフォーマンステストに関する追加情報が必要か確認
- [ ] リリースプロセスにおける受入テストの責任者を確認
- [ ] テストディレクトリ構造が最新の状態と一致しているか確認
- [ ] CI/CDワークフロー名・設定が最新か確認
- [ ] サポートするテストファイル形式の網羅性を確認
- [ ] update_test_checks.py等のテスト生成スクリプトの使用方法を補足すべきか確認
