# テスト方針書

## 概要

本ドキュメントは、LLVMプロジェクトのテスト戦略、テスト環境、テストツール、およびCI/CD連携について定義したテスト方針書です。LLVMはコンパイラインフラストラクチャプロジェクトであり、複数のサブプロジェクト（LLVM Core, Clang, LLDB, libc++, compiler-rt等）を含む大規模なモノレポ構成となっています。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のクラス・関数の正確性を検証 | 開発者 |
| 結合テスト | コンポーネント間の連携を検証（lit統合テスト） | 開発者・CIシステム |
| システムテスト | コンパイラ全体の動作を検証（クロスプロジェクトテスト） | CIシステム |
| 受入テスト | リリース品質の確認（ベンチマーク、パフォーマンステスト） | リリースエンジニア |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | コンパイラの機能・変換の正確性を検証 | コミット時（PR）、マージ後 |
| 回帰テスト | 既存機能の破壊がないことを検証 | コミット時（PR）、マージ後 |
| サニタイザテスト | メモリ安全性・未定義動作の検出 | CI定期実行 |
| ファジングテスト | 入力のランダム生成によるロバストネステスト | 専用ビルド・CIジョブ |
| パフォーマンステスト | コンパイル速度・生成コード品質の測定 | 定期実行・リリース前 |
| ABI互換性テスト | バイナリ互換性の検証 | CI定期実行 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Linux x86_64 | 主要開発・テスト環境 | Ubuntu 24.04, GCC/Clang, Ninja |
| Linux AArch64 | ARM64ターゲットのテスト | Ubuntu 24.04 ARM, Clang |
| Windows x64 | Windowsターゲットのテスト | Windows 2022, MSVC/Clang-cl |
| macOS (Apple Silicon) | macOSターゲットのテスト | macOS 14/15, Xcode |
| MinGW | Windowsクロスコンパイルのテスト | llvm-mingw |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| LLVM Integrated Tester (lit) | 統合テストフレームワーク | LLVM内蔵 |
| GoogleTest (gtest) | C++単体テストフレームワーク | third-party/unittest |
| FileCheck | テスト出力の検証ツール | LLVM内蔵 |
| CMake/CTest | ビルド・テスト管理 | 3.20以上 |
| Ninja | 高速ビルドシステム | - |
| sccache | 分散コンパイルキャッシュ | CI環境 |
| AddressSanitizer (ASan) | メモリエラー検出 | Clang内蔵 |
| MemorySanitizer (MSan) | 未初期化メモリ検出 | Clang内蔵 |
| ThreadSanitizer (TSan) | データ競合検出 | Clang内蔵 |
| UndefinedBehaviorSanitizer (UBSan) | 未定義動作検出 | Clang内蔵 |
| libFuzzer | ファジングテストエンジン | Clang内蔵 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値は設定されていない（コード変更時のテスト追加が推奨） |
| 分岐カバレッジ | 明示的な目標値は設定されていない（コード変更時のテスト追加が推奨） |
| パス/変換カバレッジ | 各最適化パス・変換に対する回帰テストの網羅 |

## テストデータ

### テストデータの準備方針

- **入力ファイル**: 各テストディレクトリの`Inputs/`サブディレクトリに配置
- **期待出力**: FileCheckディレクティブを使用してテストファイル内に記述
- **テストケース生成**: `update_test_checks.py`等のスクリプトで自動生成可能
- **ファイル形式**: LLVM IR (.ll), アセンブリ (.s), YAML (.yaml), テストスクリプト (.test)

### サポートするテストファイル形式

- `.ll` - LLVM IR テスト
- `.c/.cpp` - C/C++ ソースコードテスト
- `.s` - アセンブリテスト
- `.mir` - Machine IR テスト
- `.yaml` - YAML形式テスト
- `.test/.txt` - 一般的なテストスクリプト
- `.spv` - SPIR-V テスト

## 不具合管理

### 不具合報告

- **GitHub Issues**: https://github.com/llvm/llvm-project/issues/ で管理
- **バグレポートURL**: 各ツールの`--version`出力に含まれる
- **分類**: プロジェクト別ラベル（clang, llvm, lldb等）で管理

### 不具合対応フロー

1. GitHub Issueで報告
2. ラベル付与・担当者アサイン（Issue Subscriber/PR Subscriber ワークフロー）
3. 修正PR作成・レビュー
4. PRマージ時に自動的にCIテスト実行
5. リリースブランチへのバックポート（必要に応じて）

## CI/CD連携

### GitHub Actionsワークフロー

| ワークフロー | トリガー | 内容 |
| --- | --- | --- |
| `premerge.yaml` | PR作成/更新、リリースブランチpush | Linux/Windows/macOSでのビルド・テスト |
| `libcxx-build-and-test.yaml` | libcxx関連PR、毎日08:00 UTC | libc++/libc++abi/libunwindのテスト |
| `libc-fullbuild-tests.yml` | libc関連変更 | LLVMライブラリCのフルビルドテスト |
| `llvm-abi-tests.yml` | LLVM関連変更 | ABI互換性テスト |
| `pr-code-format.yml` | PR作成/更新 | コードフォーマットチェック |
| `pr-code-lint.yml` | PR作成/更新 | コードリントチェック |

### Pre-merge CI

- **Linux x86_64**: `llvm-premerge-linux-runners`で実行
- **Linux AArch64**: `depot-ubuntu-24.04-arm-16`で実行
- **Windows**: `llvm-premerge-windows-2022-runners`で実行
- **macOS**: `macos-14`ランナーで実行（リリースブランチのみ）
- **タイムアウト**: Linux 120分、Windows 180分

### テスト実行コマンド

```bash
# 単体テストの実行
ninja -C build check-llvm-unit

# 統合テストの実行
ninja -C build check-llvm

# 全テストの実行
ninja -C build check-all

# 特定サブプロジェクトのテスト
ninja -C build check-clang
ninja -C build check-lldb
ninja -C build check-cxx
```

### テスト結果の出力

- **JUnit XML形式**: `${BUILD_DIR}/test-results.xml`
- **成果物アップロード**: GitHub Actionsのartifactsとして保存（5日間保持）
- **クラッシュ診断**: `artifacts/reproducers/`に保存

### 並列実行・パイプライン設計

```
Stage 1 (Smoke Tests)
  |
  v
Stage 2 (Standard Tests)
  |
  v
Stage 3 (Extended Tests - fail-fast無効)
```

libc++テストでは3段階のステージに分かれており、初期ステージで失敗した場合は後続ステージをスキップして迅速にフィードバックを提供します。

## 備考

### テスト関連の主要ディレクトリ構造

```
llvm-project/
├── llvm/
│   ├── test/           # lit統合テスト
│   └── unittests/      # GoogleTest単体テスト
├── clang/
│   ├── test/           # Clang統合テスト
│   └── unittests/      # Clang単体テスト
├── libcxx/
│   └── test/           # libc++テスト
├── compiler-rt/
│   ├── test/           # compiler-rt統合テスト
│   └── unittests/      # compiler-rt単体テスト
├── cross-project-tests/ # クロスプロジェクトテスト
└── .github/workflows/   # CI設定
```

### 推奨事項

1. **新機能追加時**: 対応するテストケースを必ず追加
2. **バグ修正時**: 回帰テストを追加してバグの再発を防止
3. **パフォーマンス変更時**: ベンチマーク結果の確認を推奨
4. **ABI変更時**: ABI互換性テストの更新が必要

### 関連ドキュメント

- [LLVM Testing Infrastructure Guide](https://llvm.org/docs/TestingGuide.html)
- [lit Documentation](https://llvm.org/docs/CommandGuide/lit.html)
- [FileCheck Documentation](https://llvm.org/docs/CommandGuide/FileCheck.html)
