# ER図

## 概要

LLVM Projectは従来のRDBMSを使用していないため、一般的なエンティティリレーションシップ図は該当しません。

本ドキュメントでは、LLVM Project内の「Database」コンポーネントのデータ構造関係をクラス図形式で表現します。

## CompilationDatabase コンポーネント関係図

```mermaid
classDiagram
    class CompilationDatabase {
        <<interface>>
        +loadFromDirectory(BuildDirectory, ErrorMessage) CompilationDatabase
        +autoDetectFromSource(SourceFile, ErrorMessage) CompilationDatabase
        +autoDetectFromDirectory(SourceDir, ErrorMessage) CompilationDatabase
        +getCompileCommands(FilePath)* vector~CompileCommand~
        +getAllFiles() vector~string~
        +getAllCompileCommands() vector~CompileCommand~
    }

    class CompileCommand {
        +Directory: string
        +Filename: string
        +CommandLine: vector~string~
        +Output: string
        +Heuristic: string
    }

    class FixedCompilationDatabase {
        -CompileCommands: vector~CompileCommand~
        +loadFromCommandLine(Argc, Argv, ErrorMsg, Directory) FixedCompilationDatabase
        +loadFromFile(Path, ErrorMsg) FixedCompilationDatabase
        +loadFromBuffer(Directory, Data, ErrorMsg) FixedCompilationDatabase
        +getCompileCommands(FilePath) vector~CompileCommand~
    }

    class JSONCompilationDatabase {
        +loadFromFile(File, ErrorMessage, Syntax) JSONCompilationDatabase
        +loadFromDirectory(BuildDirectory, ErrorMessage) JSONCompilationDatabase
        +getCompileCommands(FilePath) vector~CompileCommand~
        +getAllFiles() vector~string~
        +getAllCompileCommands() vector~CompileCommand~
    }

    class GlobalCompilationDatabase {
        <<interface>>
        +getCompileCommand(File)* optional~CompileCommand~
        +getProjectInfo(File)* optional~ProjectInfo~
        +blockUntilIdle(Timeout) bool
    }

    CompilationDatabase <|-- FixedCompilationDatabase
    CompilationDatabase <|-- JSONCompilationDatabase
    CompilationDatabase ..> CompileCommand : returns
    FixedCompilationDatabase ..> CompileCommand : contains
    JSONCompilationDatabase ..> CompileCommand : returns
    GlobalCompilationDatabase ..> CompileCommand : uses
```

## CAS DatabaseFile 構造図

```mermaid
classDiagram
    class DatabaseFile {
        -H: Header*
        -Alloc: MappedFileRegionArena
        -OwnedAlloc: unique_ptr~MappedFileRegionArena~
        +getMagic() uint32_t
        +getVersion() uint32_t
        +getHeader() Header
        +getAlloc() MappedFileRegionArena
        +getRegion() MappedFileRegion
        +addTable(Table) Error
        +findTable(Name) optional~TableHandle~
        +create(Path, Capacity, Logger, Constructor) DatabaseFile
        +size() size_t
    }

    class DatabaseFile_Header {
        +Magic: uint32_t
        +Version: uint32_t
        +RootTableOffset: atomic~int64_t~
    }

    class TableHandle {
        -Region: MappedFileRegion*
        -H: Header*
        +getHeader() Header
        +getRegion() MappedFileRegion
        +getName() StringRef
        +is~T~() bool
        +dyn_cast~T~() T
        +cast~T~() T
    }

    class TableHandle_Header {
        +Kind: TableKind
        +NameSize: uint16_t
        +NameRelOffset: int32_t
    }

    class TableKind {
        <<enumeration>>
        TrieRawHashMap = 1
        DataAllocator = 2
    }

    class MappedFileRegionArena {
        +getRegion() MappedFileRegion
        +data() char*
        +size() size_t
    }

    DatabaseFile *-- DatabaseFile_Header : contains
    DatabaseFile --> MappedFileRegionArena : uses
    DatabaseFile --> TableHandle : manages
    TableHandle *-- TableHandle_Header : contains
    TableHandle_Header --> TableKind : uses
    TableHandle --> MappedFileRegionArena : references
```

## データフロー図

```mermaid
flowchart TB
    subgraph "CompilationDatabase データフロー"
        JSON[compile_commands.json]
        CLI[コマンドライン引数]
        FLAGS[compile_flags.txt]

        JSON --> JSONCompDB[JSONCompilationDatabase]
        CLI --> FixedCompDB[FixedCompilationDatabase]
        FLAGS --> FixedCompDB

        JSONCompDB --> CompDB[CompilationDatabase Interface]
        FixedCompDB --> CompDB

        CompDB --> ClangTool[Clang Tooling]
        CompDB --> Clangd[clangd LSP Server]
    end

    subgraph "CAS Database データフロー"
        Source[ソースファイル]
        Source --> CASHash[ハッシュ計算]
        CASHash --> DBFile[DatabaseFile]
        DBFile --> TableH[TableHandle]
        TableH --> TrieMap[TrieRawHashMap]
        TableH --> DataAlloc[DataAllocator]
    end
```

## 備考

上記の図は、LLVM Projectにおける「Database」コンポーネントのクラス構造とデータフローを表現しています。

これらは従来のRDBMSにおけるER図（エンティティリレーションシップ図）とは異なり、以下の特徴があります:

1. **CompilationDatabase**: インターフェースと実装クラスの継承関係を表現
2. **CAS DatabaseFile**: バイナリファイル形式のヘッダー構造とテーブル管理を表現

従来のデータベース設計で見られる「1対多」「多対多」などのリレーションシップや、主キー・外部キーの概念は本プロジェクトには存在しません。
