# データベース設計書

## 概要

本ドキュメントは、LLVM Project のデータベース関連コンポーネントを分析した結果を記載しています。

**重要**: LLVM Projectは、コンパイラインフラストラクチャを提供するプロジェクトであり、従来のRDBMS（MySQL、PostgreSQL等）やNoSQLデータベース（MongoDB等）を使用するWebアプリケーションではありません。本プロジェクトには、一般的な意味でのデータベーステーブル設計は存在しません。

ただし、「Database」という名称を持つコンポーネントが存在するため、それらについて説明します。

## データベース関連コンポーネント一覧

| コンポーネント名 | 種類 | 説明 |
| --- | --- | --- |
| CompilationDatabase | インメモリデータ構造 | コンパイルコマンドを管理するための抽象インターフェース |
| FixedCompilationDatabase | インメモリデータ構造 | 単一のコンパイルコマンドを返すCompilationDatabase実装 |
| JSONCompilationDatabase | ファイルベース | compile_commands.jsonからコンパイル情報を読み込む実装 |
| GlobalCompilationDatabase | インメモリデータ構造 | clangdで使用されるグローバルなコンパイルデータベース |
| CAS DatabaseFile | ファイルベース | Content-Addressable Storage用のオンディスクデータベース |

## 各コンポーネント定義

### 1. CompilationDatabase (抽象インターフェース)

ソースファイル: `clang/include/clang/Tooling/CompilationDatabase.h`

コンパイルコマンド情報を管理するための抽象インターフェースです。C++リファクタリングツールや解析ツールが、プロジェクトのビルド情報を取得するために使用します。

#### CompileCommand 構造体

| フィールド名 | データ型 | NULL許容 | 説明 |
| --- | --- | --- | --- |
| Directory | std::string | No | コマンドが実行される作業ディレクトリ |
| Filename | std::string | No | コンパイル対象のソースファイル |
| CommandLine | std::vector\<std::string\> | No | 実行されるコマンドライン引数 |
| Output | std::string | Yes | 出力ファイルパス |
| Heuristic | std::string | Yes | コマンドが推測された場合の説明 |

### 2. JSONCompilationDatabase

ソースファイル: `clang/include/clang/Tooling/JSONCompilationDatabase.h`

`compile_commands.json` ファイルからコンパイル情報を読み込むCompilationDatabase実装です。

#### JSON形式（外部ファイル）

```json
[
  {
    "directory": "/path/to/build",
    "command": "clang++ -c file.cpp -o file.o",
    "file": "/path/to/source/file.cpp",
    "output": "file.o"
  }
]
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| directory | string | Yes | ビルドディレクトリの絶対パス |
| command / arguments | string / array | Yes | コンパイルコマンド（どちらか一方が必要） |
| file | string | Yes | ソースファイルの絶対パス |
| output | string | No | 出力ファイルパス |

### 3. CAS DatabaseFile

ソースファイル: `llvm/lib/CAS/DatabaseFile.h`

Content-Addressable Storage (CAS) のためのオンディスクデータベースファイル形式です。

#### ファイルヘッダー構造

| オフセット | サイズ | データ型 | 説明 |
| --- | --- | --- | --- |
| 0x00 | 4 bytes | uint32_t | マジックナンバー (0xDA7ABA53) |
| 0x04 | 4 bytes | uint32_t | バージョン番号 (1) |
| 0x08 | 8 bytes | atomic\<int64_t\> | ルートテーブルオフセット |
| 0x10 | 8 bytes | - | MappedFileRegionArena用BumpPtr |

#### TableHandle 構造

| オフセット | サイズ | データ型 | 説明 |
| --- | --- | --- | --- |
| 0x00 | 2 bytes | uint16_t (enum) | テーブル種別 (TrieRawHashMap=1, DataAllocator=2) |
| 0x02 | 2 bytes | uint16_t | テーブル名サイズ |
| 0x04 | 4 bytes | int32_t | テーブル名相対オフセット |

## 備考

### 本プロジェクトにおける「データベース」の意味

LLVM Projectにおける「Database」という用語は、一般的なRDBMSとは異なる意味で使用されています:

1. **CompilationDatabase**: ビルドシステムからのコンパイル情報を抽象化したインターフェース。実体はJSONファイルやコマンドライン引数として提供される。

2. **CAS Database**: Content-Addressable Storage (内容でアドレッシングされるストレージ) のためのカスタムバイナリファイル形式。ハッシュベースのデータ検索を提供する。

### SQLデータベースは存在しない

本プロジェクトのコード解析の結果、以下を確認しました:

- SQLファイル (.sql) は存在しない
- CREATE TABLE文は存在しない
- ORM (Prisma, TypeORM, Sequelize, Mongoose等) は使用されていない
- データベース接続ライブラリ (mysql, postgresql, sqlite等) のインポートは存在しない

したがって、従来のデータベース設計書で記載するような「テーブル定義」「外部キー制約」「インデックス設計」などは本プロジェクトには該当しません。
