---
generated_at: 2026-02-01 21:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.ci/monolithic-linux.sh` - Linux CIビルドスクリプト
- E-02: `.ci/monolithic-windows.sh` - Windows CIビルドスクリプト
- E-03: `.ci/utils.sh` - CI共通ユーティリティ
- E-04: `libcxx/utils/ci/buildkite-pipeline-trigger.sh` - Buildkiteトリガー
- E-05: `llvm/utils/release/test-release.sh` - リリーステストスクリプト
- E-06: `llvm/utils/release/build-docs.sh` - ドキュメントビルドスクリプト
- E-07: `llvm/utils/release/export.sh` - ソースエクスポートスクリプト
- E-08: `llvm/utils/release/merge-request.sh` - マージリクエストスクリプト
- E-09: `llvm/utils/release/get-llvm-version.sh` - バージョン取得スクリプト
- E-10: `llvm/utils/docker/build_docker_image.sh` - Dockerイメージビルド
- E-11: `llvm/utils/docker/scripts/checkout.sh` - Dockerチェックアウト
- E-12: `llvm/utils/docker/scripts/build_install_llvm.sh` - Dockerビルドインストール
- E-13: `compiler-rt/lib/fuzzer/build.sh` - LibFuzzerビルド
- E-14: `compiler-rt/lib/tsan/go/buildgo.sh` - Go TSanビルド
- E-15: `compiler-rt/lib/sanitizer_common/symbolizer/scripts/build_symbolizer.sh` - シンボライザービルド
- E-16: `libcxx/utils/ci/apple-install-libcxx.sh` - Apple libc++インストール
- E-17: `libcxx/utils/ci/build-picolibc.sh` - Picolibcビルド
- E-18: `llvm/utils/crosstool/ARM/build-install-linux.sh` - ARMクロスビルド
- E-19: `libc/AOR_v20.02/math/test/runulp.sh` - ULPテスト
- E-20: `flang/test/Semantics/common.sh` - Flangテスト共通
- E-21: `llvm/test/TestRunner.sh` - テストランナー
- E-22: `bolt/utils/bughunter.sh` - BOLTバグハンター
- E-23: `lldb/scripts/macos-setup-codesign.sh` - macOSコード署名
- E-24: `lldb/test/Shell/SymbolFile/Inputs/dsymforuuid.sh` - dSYM UUID
- E-25: `compiler-rt/lib/tsan/check_cmake.sh` - TSan CMakeチェック
- E-26: `compiler-rt/lib/tsan/analyze_libtsan.sh` - TSan解析
- E-27: `clang/tools/diag-build/diag-build.sh` - 診断ビルド
- E-28: `clang/utils/find-unused-diagnostics.sh` - 未使用診断検出
- E-29: `clang/utils/bash-autocomplete.sh` - Bash自動補完
- E-30: `libcxx/utils/clang-format-merge-driver.sh` - clang-formatマージドライバー
- E-31: `libcxx/utils/zos_rename_dll_side_deck.sh` - z/OS DLLリネーム
- E-32: `llvm/utils/lint/remove_trailing_whitespace.sh` - 末尾空白除去
- E-33: `llvm/utils/git/arcfilter.sh` - Arcフィルター
- E-34: `libcxx/utils/ci/vendor/android/start-emulator.sh` - Androidエミュレータ起動
- E-35: `libcxx/utils/ci/vendor/android/stop-emulator.sh` - Androidエミュレータ停止
- E-36: `libcxx/utils/ci/vendor/android/build-emulator-images.sh` - エミュレータイメージビルド
- E-37: `libcxx/utils/ci/vendor/android/emulator-wait-for-ready.sh` - エミュレータ待機
- E-38: `mlir/utils/spirv/define_enum.sh` - SPIR-V enum定義
- E-39: `mlir/utils/spirv/define_inst.sh` - SPIR-V命令定義
- E-40: `mlir/utils/spirv/define_opcodes.sh` - SPIR-Vオペコード定義
- E-41: `lldb/scripts/lldb-test-qemu/setup.sh` - QEMUセットアップ
- E-42: `lldb/scripts/lldb-test-qemu/rootfs.sh` - QEMUルートファイルシステム
- E-43: `lldb/scripts/lldb-test-qemu/run-qemu.sh` - QEMU実行
- E-44: `clang/utils/ABITest/build.sh` - ABIテストビルド
- E-45: `clang/utils/ABITest/build-and-summarize.sh` - ABIテストサマリー
- E-46: `clang/utils/ABITest/build-and-summarize-all.sh` - ABIテスト一括
- E-47: `clang/utils/ABITest/summarize.sh` - ABIサマリー
- E-48: `clang/utils/analyzer/projects/*/cleanup_run_static_analyzer.sh` - 静的解析クリーンアップ
- E-49: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` - GWP-ASANシンボル化
- E-50: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` - DFSanラッパーチェック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | monolithic-linux.shはLinux環境でのモノレポビルドとテスト実行を行う | E-01 | ○ |
| C-02 | monolithic-windows.shはWindows環境でのモノレポビルドとテスト実行を行う | E-02 | ○ |
| C-03 | utils.shはCI共通ユーティリティ関数を提供する | E-03 | ○ |
| C-04 | buildkite-pipeline-trigger.shはBuildkiteパイプラインをトリガーする | E-04 | ○ |
| C-05 | test-release.shはLLVMリリース候補のテストを実行する | E-05 | ○ |
| C-06 | build-docs.shはLLVMリリース用ドキュメントをビルドする | E-06 | ○ |
| C-07 | export.shはLLVMリリース用ソースアーカイブを作成する | E-07 | ○ |
| C-08 | merge-request.shはBugzillaへのマージリクエストを提出する | E-08 | ○ |
| C-09 | get-llvm-version.shはLLVMバージョンを取得する | E-09 | ○ |
| C-10 | build_docker_image.shはLLVMビルド用Dockerイメージを作成する | E-10 | ○ |
| C-11 | checkout.shはDockerビルドでGitチェックアウトを行う | E-11 | ○ |
| C-12 | build_install_llvm.shはDocker内でLLVMをビルド・インストールする | E-12 | ○ |
| C-13 | build.sh (libfuzzer)はLibFuzzerライブラリをビルドする | E-13 | ○ |
| C-14 | buildgo.shはGo言語用TSanランタイムをビルドする | E-14 | ○ |
| C-15 | build_symbolizer.shはシンボライザーオブジェクトファイルを生成する | E-15 | ○ |
| C-16 | apple-install-libcxx.shはApple向けlibc++をインストールする | E-16 | ○ |
| C-17 | build-picolibc.shはPicolibcをクロスビルドする | E-17 | ○ |
| C-18 | build-install-linux.shはARM向けクロスコンパイルをビルドする | E-18 | ○ |
| C-19 | runulp.shは数学関数ULPテストを実行する | E-19 | ○ |
| C-20 | common.sh (flang)はFlang Semanticsテストの共通スクリプトである | E-20 | ○ |
| C-21 | TestRunner.shはLLVMテストランナーとして機能する | E-21 | ○ |
| C-22 | bughunter.shはBOLTのバグを特定する | E-22 | ○ |
| C-23 | macos-setup-codesign.shはmacOS用コード署名を設定する | E-23 | ○ |
| C-24 | dsymforuuid.shはdSYMファイルUUIDを照合する | E-24 | ○ |
| C-25 | check_cmake.shはTSan CMakeビルドをチェックする | E-25 | ○ |
| C-26 | analyze_libtsan.shはTSanライブラリシンボルを解析する | E-26 | ○ |
| C-27 | diag-build.shはClang警告を表示するラッパーである | E-27 | ○ |
| C-28 | find-unused-diagnostics.shは未使用診断メッセージを検出する | E-28 | ○ |
| C-29 | bash-autocomplete.shはClangコマンドライン補完を提供する | E-29 | ○ |
| C-30 | clang-format-merge-driver.shはclang-formatマージドライバーである | E-30 | ○ |
| C-31 | zos_rename_dll_side_deck.shはz/OS DLLサイドデッキをリネームする | E-31 | ○ |
| C-32 | remove_trailing_whitespace.shは末尾空白を除去する | E-32 | ○ |
| C-33 | arcfilter.shはArcフィルタースクリプトである | E-33 | ○ |
| C-34 | start-emulator.shはAndroidエミュレータを起動する | E-34 | ○ |
| C-35 | stop-emulator.shはAndroidエミュレータを停止する | E-35 | ○ |
| C-36 | build-emulator-images.shはAndroidエミュレータイメージをビルドする | E-36 | ○ |
| C-37 | emulator-wait-for-ready.shはエミュレータの起動を待機する | E-37 | ○ |
| C-38 | define_enum.shはSPIR-V enum定義を生成する | E-38 | ○ |
| C-39 | define_inst.shはSPIR-V命令定義を生成する | E-39 | ○ |
| C-40 | define_opcodes.shはSPIR-Vオペコード定義を生成する | E-40 | ○ |
| C-41 | setup.sh (lldb-test-qemu)はQEMUテスト環境をセットアップする | E-41 | ○ |
| C-42 | rootfs.shはQEMUルートファイルシステムを作成する | E-42 | ○ |
| C-43 | run-qemu.shはQEMUエミュレータを実行する | E-43 | ○ |
| C-44 | build.sh (ABITest)はABIテストをビルドする | E-44 | ○ |
| C-45 | build-and-summarize.shはABIテストをビルドしてサマリーを生成する | E-45 | ○ |
| C-46 | build-and-summarize-all.shは全ABIテストをビルドしてサマリーを生成する | E-46 | ○ |
| C-47 | summarize.shはABIテスト結果サマリーを生成する | E-47 | ○ |
| C-48 | cleanup_run_static_analyzer.shは静的解析後のクリーンアップを行う | E-48 | ○ |
| C-49 | symbolize.shはGWP-ASANクラッシュをシンボル化する | E-49 | ○ |
| C-50 | check_custom_wrappers.shはDFSanカスタムラッパーをチェックする | E-50 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対して実際のスクリプトファイルの内容を確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのバッチスクリプトはプロジェクト内に実在し、内容を直接確認

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切か確認する
- [ ] バッチ名とファイルパスの対応が正確か確認する
- [ ] 説明がスクリプトの実際の機能を正しく反映しているか確認する
- [ ] 重要なスクリプトが漏れていないか確認する（特にプロジェクト固有のビルドスクリプト）
