# バッチ設計書 1-monolithic-linux.sh

## 概要

本ドキュメントは、LLVMプロジェクトのLinux環境向けモノレポビルドおよびテスト実行バッチ「monolithic-linux.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMモノレポジトリ全体をLinux環境でビルドし、各プロジェクトのテストを実行するCI/CDパイプライン用スクリプトです。CMakeとNinjaビルドシステムを使用し、sccacheによるビルドキャッシュを活用して効率的なビルドを実現します。

**業務上の目的・背景**：LLVMプロジェクトは複数のサブプロジェクト（Clang、LLDB、MLIR等）で構成される大規模なコンパイラ基盤です。本バッチは、コードの変更がプロジェクト全体に与える影響を検証するために、統合ビルドとテストを自動化します。これにより、開発者はコミット前にリグレッションを検出でき、コード品質を維持できます。

**バッチの実行タイミング**：GitHub ActionsまたはBuildkiteによるCI/CDパイプラインの一部として、プルリクエスト作成時およびmainブランチへのマージ時に自動実行されます。

**主要な処理内容**：
1. utils.shの読み込みによる共通設定の初期化（sccache統計リセット、ビルドディレクトリクリア）
2. CMakeによるビルド構成（プロジェクト、ランタイム、ビルドオプションの設定）
3. Ninjaによるプロジェクトビルド実行
4. Ninjaによるランタイムビルド実行
5. C++26およびClang Modulesを使用したランタイム再構成とテスト

**前後の処理との関連**：本バッチはutils.shに依存しており、utils.shが提供するstart-group関数やat-exitハンドラを使用します。また、ビルドアーティファクトはartifactsディレクトリに収集され、CIシステムがこれを後続処理で利用します。

**影響範囲**：LLVMプロジェクト全体のビルド成果物、テスト結果XML、Ninjaビルドログ、sccacheキャッシュに影響を与えます。

## バッチ種別

CI/CDビルド・テスト自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | CI/CDパイプライントリガー時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | GitHub Actions / Buildkite イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | Ubuntu等のLinuxディストリビューションが必要 |
| ビルドツール | CMake、Ninja、sccache、llvm-symbolizerがインストール済み |
| Python環境 | pip、Python依存パッケージ（requirements.txt）がインストール可能 |
| 環境変数 | MONOREPO_ROOT、BUILD_DIRが設定されていること |

### 実行可否判定

utils.shによりMONOREPO_ROOTが自動検出される。BUILD_DIRが未設定の場合はデフォルト値が使用される。必要なツールが存在しない場合はエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| projects | string | Yes | なし | ビルド対象プロジェクト（セミコロン区切り） |
| targets | string | No | なし | Ninjaビルドターゲット |
| runtimes | string | No | なし | ビルド対象ランタイム（セミコロン区切り） |
| runtime_targets | string | No | なし | ランタイムビルドターゲット |
| runtime_targets_needs_reconfig | string | No | なし | 再構成が必要なランタイムターゲット |
| enable_cir | string | No | なし | ClangIR有効化フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| MONOREPO_ROOT/llvm | ディレクトリ | LLVMソースコードルート |
| .ci/all_requirements.txt | テキスト | Python依存パッケージリスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${BUILD_DIR}/test-results.xml | XML | LITテスト結果（JUnit形式） |
| artifacts/reproducers | ディレクトリ | Clangクラッシュ再現ファイル |
| ninja.log | テキスト | Ninjaビルドログ |
| ninja.ninja_log | テキスト | Ninja内部ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | test-results.*.xml |
| 出力先 | ${BUILD_DIR}/ |
| 文字コード | UTF-8 |
| 区切り文字 | XML形式 |

## 処理フロー

### 処理シーケンス

```
1. utils.sh読み込み
   └─ 共通設定、関数定義、sccache初期化
2. 環境変数設定
   └─ INSTALL_DIR、CLANG_CRASH_DIAGNOSTICS_DIR設定
3. CMake構成実行
   └─ プロジェクト、ランタイム、ビルドオプション指定
4. Ninjaビルド実行
   └─ 指定ターゲットのビルド、ログ出力
5. ランタイムビルド実行
   └─ runtime_targetsが指定された場合のみ
6. C++26テスト実行
   └─ runtime_targets_needs_reconfigが指定された場合
7. Clang Modulesテスト実行
   └─ runtime_targets_needs_reconfigが指定された場合
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[utils.sh読み込み]
    B --> C[環境変数設定]
    C --> D[CMake構成]
    D --> E{targets指定あり?}
    E -->|あり| F[Ninjaビルド実行]
    E -->|なし| G{runtime_targets指定あり?}
    F --> G
    G -->|あり| H[ランタイムビルド実行]
    G -->|なし| I{reconfig必要?}
    H --> I
    I -->|あり| J[C++26再構成・テスト]
    J --> K[Clang Modules再構成・テスト]
    I -->|なし| L[バッチ終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | ビルドエラー | CMakeまたはNinjaが失敗 | ビルドログを確認し、コンパイルエラーを修正 |
| 非0終了 | テストエラー | LITテストが失敗 | test-results.xmlを確認し、失敗テストを修正 |
| 非0終了 | 環境エラー | llvm-symbolizerが見つからない | ツールをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ninja.logを確認してビルドエラーの原因を特定
2. test-results.xmlを確認して失敗テストを特定
3. sccache統計を確認してキャッシュの問題を調査
4. CLANG_CRASH_DIAGNOSTICS_DIRの再現ファイルを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のフルビルド |
| 目標処理時間 | 環境依存（数十分〜数時間） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ビルドディレクトリでの同時実行は不可。utils.shにより既存のビルドディレクトリは削除される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | CMake開始時 | "::group::CMake" (GitHub Actions環境) |
| 進捗ログ | 各ステップ開始時 | start-group関数によるグループ出力 |
| 終了ログ | バッチ終了時 | at-exit関数によるsccache統計、アーティファクト収集 |
| エラーログ | エラー発生時 | ninja.log、test-results.xmlに出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1200秒（LITテストタイムアウト） | CI/CDシステム |
| テスト失敗 | 1件以上 | GitHub PR / Buildkite |

## 備考

- sccacheを使用してビルドキャッシュを最適化
- LLDリンカーを使用して高速なリンクを実現
- -k 0オプションにより、エラー発生後もビルドを継続
- ARM64ビルダーではGCSキャッシュへのアクセスが制限される
