# バッチ設計書 10-build_docker_image.sh

## 概要

本ドキュメントは、LLVMビルド用Dockerイメージ作成スクリプト「build_docker_image.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMをビルドするためのDockerイメージを構築するスクリプトです。指定されたソースイメージ（debian12、nvidia-cuda等）をベースに、LLVMのチェックアウト、ビルド、インストールを行うDockerイメージを生成します。マルチステージビルドをサポートし、2段階ブートストラップClangビルドにも対応しています。

**業務上の目的・背景**：LLVMの開発・テスト環境を再現可能な形で提供するため、Dockerコンテナを使用します。本バッチは、特定のブランチ、リビジョン、CMakeオプションを指定してカスタマイズしたLLVMビルド環境を簡単に構築できるようにします。これにより、開発者は一貫したビルド環境を共有でき、CI/CDパイプラインでの利用も可能になります。

**バッチの実行タイミング**：開発者やCI/CDシステムがカスタムDockerイメージを作成する際に手動で実行します。

**主要な処理内容**：
1. コマンドライン引数の解析（ソースイメージ、リポジトリ、タグ、ビルドオプション）
2. 一時ビルドディレクトリの作成
3. ソースイメージとビルドスクリプトのコピー
4. チェックサムファイルのコピー（オプション）
5. docker buildコマンドの実行
6. ビルドイメージとクリーンイメージの生成

**前後の処理との関連**：生成されたDockerイメージは、docker runで実行してLLVMビルド環境として使用されます。内部的にcheckout.shとbuild_install_llvm.shスクリプトを使用します。

**影響範囲**：Dockerレジストリ（ローカルまたはリモート）に新規イメージを作成します。

## バッチ種別

Docker環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イメージ更新時） |
| 実行時刻 | 手動実行 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker環境 | dockerコマンドが利用可能であること |
| ソースイメージ | 指定したソースイメージディレクトリ（Dockerfile）が存在すること |
| ネットワーク | GitHubからLLVMソースをダウンロード可能 |

### 実行可否判定

--source、--docker-repository、--install-targetオプションがすべて必須。dockerコマンドが利用可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -s, --source | string | Yes | なし | ソースイメージディレクトリ（debian12、nvidia-cuda等） |
| -d, --docker-repository | string | Yes | なし | Dockerリポジトリ名 |
| -t, --docker-tag | string | No | なし | Dockerタグ |
| -b, --branch | string | No | main | Gitブランチ |
| -r, --revision | string | No | なし | Gitリビジョン |
| -c, --cherrypick | string | No | なし | チェリーピックするリビジョン（複数指定可） |
| -p, --llvm-project | string | No | なし | ビルド対象プロジェクト（複数指定可） |
| -i, --install-target | string | Yes | なし | CMakeインストールターゲット（複数指定可） |
| --checksums | string | No | なし | チェックサムファイルパス |
| -- | | No | なし | 以降はCMake引数として渡す |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースイメージディレクトリ | Dockerfile | ベースイメージ定義 |
| scripts/ | シェルスクリプト | チェックアウト・ビルドスクリプト |
| GitHubリポジトリ | Git | LLVMソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {docker-repository}-build:{tag} | Dockerイメージ | ビルド中間イメージ |
| {docker-repository}:{tag} | Dockerイメージ | 最終イメージ（LLVMインストール済み） |

### 出力ファイル仕様

本バッチはDockerイメージを出力し、ファイルは出力しません。

| 項目 | 内容 |
|-----|------|
| イメージ名 | {docker-repository}:{docker-tag} |
| 出力先 | ローカルDockerレジストリ |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ ソース、リポジトリ、タグ、ビルドオプション取得
2. 必須パラメータ検証
   └─ source、docker-repository、install-target確認
3. Docker存在確認
   └─ command -v docker
4. ソースディレクトリ確認
   └─ ソースイメージディレクトリの存在確認
5. 一時ビルドディレクトリ作成
   └─ mktemp -d
6. リソースコピー
   └─ ソースイメージ、scripts/、checksumsをコピー
7. Docker build実行
   └─ docker build --build-arg checkout_args --build-arg buildscript_args
8. クリーンアップ
   └─ trap "rm -rf $BUILD_DIR" EXIT
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[必須パラメータ検証]
    C --> D{Docker存在?}
    D -->|No| E[エラー終了]
    D -->|Yes| F{ソースディレクトリ存在?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[一時ディレクトリ作成]
    H --> I[リソースコピー]
    I --> J[LLVM_ENABLE_PROJECTS設定]
    J --> K[docker build実行]
    K --> L[クリーンアップ]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | Dockerが見つからない | Dockerをインストール |
| 1 | 引数エラー | --source未指定 | ソースイメージを指定 |
| 1 | 引数エラー | --docker-repository未指定 | リポジトリ名を指定 |
| 1 | 引数エラー | --install-target未指定 | インストールターゲットを指定 |
| 1 | ファイルエラー | ソースディレクトリが存在しない | パスを確認 |
| 非0 | Dockerエラー | docker buildが失敗 | Dockerログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. Dockerデーモンが動作しているか確認
2. Dockerログを確認
3. ネットワーク接続を確認（GitHubからのダウンロード）
4. ディスク空き容量を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（失敗時はイメージ未生成） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1イメージ作成 |
| 目標処理時間 | 数十分〜数時間（ビルドオプション依存） |
| メモリ使用量上限 | Docker設定に依存 |

## 排他制御

同一タグへの同時ビルドは不可（Dockerによる制御）。一時ビルドディレクトリはmktempで一意に生成。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ビルド開始時 | "Using a temporary directory for the build: {path}" |
| 情報ログ | ビルド開始時 | "Building {repository}{tag} from {source}" |
| 情報ログ | ビルド完了時 | "Done" |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |
| ビルド時間 | 異常な長時間 | 手動確認 |

## 備考

- 利用可能なソースイメージ：debian12、nvidia-cuda等（ディレクトリ名で指定）
- 2段階ブートストラップビルド例：
  ```bash
  ./build_docker_image.sh -s debian12 -d mydocker/clang-debian12 -t "latest" \
    -p clang -i stage2-install-clang -i stage2-install-clang-resource-headers \
    -- \
    -DLLVM_TARGETS_TO_BUILD=Native -DCMAKE_BUILD_TYPE=Release \
    -DBOOTSTRAP_CMAKE_BUILD_TYPE=Release \
    -DCLANG_ENABLE_BOOTSTRAP=ON \
    -DCLANG_BOOTSTRAP_TARGETS="install-clang;install-clang-resource-headers"
  ```
- 生成されるイメージ：
  - {repository}-build:{tag} - ビルド用中間イメージ
  - {repository}:{tag} - 最終イメージ（コンパクト）
- --cherrypickオプションは複数回指定可能、ソート順でcherry-pick実行
- --checksumsでビルド検証用チェックサムファイルを指定可能
- trapでEXIT時に一時ディレクトリを自動削除
- set -eでエラー時に即座に停止
