# バッチ設計書 11-checkout.sh

## 概要

本ドキュメントは、DockerビルドでのGitチェックアウト処理を行う `checkout.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、Dockerコンテナ内でLLVMプロジェクトのソースコードをGitHubからチェックアウトし、必要に応じてチェリーピックを適用する処理を担当する。

**業務上の目的・背景**：LLVMプロジェクトのDockerベースビルド環境において、ビルド対象となるソースコードを取得する必要がある。特定のブランチやリビジョンを指定してチェックアウトし、必要に応じて追加のコミットをチェリーピックすることで、柔軟なビルド構成を実現する。Dockerコンテナ内での一貫したビルド環境を提供し、再現可能なビルドを保証するために本バッチが必要となる。

**バッチの実行タイミング**：Dockerイメージビルド時、またはDockerコンテナ内でのビルドプロセス開始時に実行される。CI/CDパイプラインにおいては、ビルドジョブの初期段階で呼び出される。

**主要な処理内容**：
1. コマンドライン引数のパース（ブランチ、リビジョン、チェリーピック対象の指定）
2. LLVMプロジェクトのGitリポジトリをGitHubからクローン
3. 指定されたブランチまたはリビジョンへのチェックアウト
4. 指定されたチェリーピックコミットの適用（ソート・重複排除後）
5. チェックサム検証（checksums.txtが存在する場合）

**前後の処理との関連**：本バッチは `build_install_llvm.sh` の前段処理として位置づけられる。本バッチでソースコードを取得した後、ビルド処理が実行される。

**影響範囲**：`/tmp/clang-build/src` ディレクトリにソースコードが配置される。後続のビルドプロセス全体に影響を与える。

## バッチ種別

データ取得 / ソース準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | Dockerビルド/CI実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Dockerコンテナ内での実行 | 本スクリプトはDockerコンテナ内での実行を前提とする |
| Git利用可能 | gitコマンドが利用可能であること |
| ネットワーク接続 | GitHub (github.com) への接続が可能であること |
| 書き込み権限 | /tmp/clang-build への書き込み権限があること |

### 実行可否判定

- 引数が正しく指定されていること
- ネットワーク接続が確立されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -b, --branch | string | No | main | チェックアウト対象のGitブランチ（例: main, release/19.x） |
| -r, --revision | string | No | なし（最新） | チェックアウト対象のGitリビジョン |
| -c, --cherrypick | string | No | なし | チェリーピック対象のリビジョン（複数指定可） |
| -h, --help | flag | No | - | ヘルプメッセージの表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://github.com/llvm/llvm-project.git | Git Repository | LLVMプロジェクトのソースリポジトリ |
| /tmp/checksums/checksums.txt | Text File | チェックサム検証用ファイル（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| /tmp/clang-build/src | Directory | チェックアウトされたLLVMソースコード |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ソースコード一式 |
| 出力先 | /tmp/clang-build/src |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数パース
   └─ -b/--branch, -r/--revision, -c/--cherrypick オプションを解析
2. デフォルト値設定
   └─ ブランチ未指定時は "main" を使用
3. チェリーピック整理
   └─ 重複排除とソート処理
4. ソースディレクトリ作成
   └─ /tmp/clang-build/src ディレクトリを作成
5. Gitクローン実行
   └─ 指定ブランチでシングルブランチクローン
6. リビジョンチェックアウト
   └─ 指定リビジョンがある場合はそのリビジョンへ移動
7. チェリーピック適用
   └─ 指定されたコミットを順番に適用
8. チェックサム検証
   └─ checksums.txt存在時にPythonスクリプトで検証
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数パース]
    B --> C{ヘルプ表示?}
    C -->|Yes| D[使用方法表示]
    D --> E[終了]
    C -->|No| F[ブランチデフォルト設定]
    F --> G[チェリーピック整理]
    G --> H[ソースディレクトリ作成]
    H --> I[Gitクローン実行]
    I --> J{リビジョン指定あり?}
    J -->|Yes| K[指定リビジョンへチェックアウト]
    J -->|No| L[最新状態維持]
    K --> M[チェリーピック適用]
    L --> M
    M --> N{checksums.txt存在?}
    N -->|Yes| O[チェックサム検証]
    N -->|No| P[検証スキップ]
    O --> Q[バッチ終了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不明なオプション指定時 | 正しいオプションで再実行 |
| 1 | ネットワークエラー | GitHubへの接続失敗 | ネットワーク接続を確認 |
| 1 | チェリーピックエラー | コンフリクト発生時 | 手動でコンフリクト解決 |
| 1 | チェックサムエラー | チェックサム不一致時 | ソースの整合性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e` によりエラー発生時は即座にスクリプト終了
2. /tmp/clang-build/src ディレクトリを削除して再実行
3. ネットワークエラーの場合は接続状態を確認後再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | エラー時は手動でディレクトリ削除 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リポジトリ |
| 目標処理時間 | ネットワーク速度依存（通常5-15分） |
| メモリ使用量上限 | LLVMソースサイズ依存（約2GB） |

## 排他制御

同一コンテナ内での複数実行は想定していない。複数のDockerコンテナでの並列実行は可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | チェックアウト開始時 | "Checking out sources from git" |
| 進捗ログ | クローン時 | リポジトリURLと出力先 |
| 進捗ログ | チェリーピック時 | 適用するリビジョン |
| 終了ログ | 処理完了時 | "Done" |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | CI/CDシステム |
| 終了コード | 非0 | CI/CDシステム |

## 備考

- 本スクリプトはDockerコンテナ内（`/llvm/utils/docker/scripts/`）に配置される
- ソースコードの場所: `llvm/utils/docker/scripts/checkout.sh`
- チェックサム検証にはPythonスクリプト `llvm_checksum.py` を使用
- `set -e` によりエラー時は即座に終了する設計
