# バッチ設計書 12-build_install_llvm.sh

## 概要

本ドキュメントは、Docker内でのLLVMビルド・インストール処理を行う `build_install_llvm.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、Dockerコンテナ内でCMakeとNinjaを使用してLLVMプロジェクトをビルドし、指定されたディレクトリにインストールする処理を担当する。

**業務上の目的・背景**：LLVMプロジェクトのDockerベースビルド環境において、ソースコードからコンパイラやツールチェーンをビルドする必要がある。Dockerコンテナ内での一貫したビルド環境を使用することで、再現可能なビルドを実現し、異なる環境間でのビルド結果の差異を最小化する。CI/CDパイプラインでのビルドアーティファクト生成に本バッチが使用される。

**バッチの実行タイミング**：`checkout.sh` によるソースコード取得後に実行される。CI/CDパイプラインにおいては、チェックアウト完了後のビルドステージで呼び出される。

**主要な処理内容**：
1. コマンドライン引数のパース（インストールターゲット、インストール先の指定）
2. 必須引数の検証（--to と --install-target）
3. ビルドディレクトリの作成
4. CMakeによるビルド構成（Ninjaジェネレータ使用）
5. Ninjaによる指定ターゲットのビルド実行
6. ビルドディレクトリのクリーンアップ

**前後の処理との関連**：`checkout.sh` の後続処理として実行される。ソースコードは `/tmp/clang-build/src` から読み込まれる。

**影響範囲**：指定されたインストールディレクトリ（--to オプション）にビルド成果物が配置される。

## バッチ種別

ビルド処理 / インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | Dockerビルド/CI実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ソースコード取得済み | /tmp/clang-build/src にLLVMソースが存在すること |
| CMake利用可能 | cmakeコマンドが利用可能であること |
| Ninja利用可能 | ninjaコマンドが利用可能であること |
| 書き込み権限 | インストール先ディレクトリへの書き込み権限があること |

### 実行可否判定

- 必須引数（--to, --install-target）が指定されていること
- ソースディレクトリが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -i, --install-target | string | Yes | なし | ビルド・インストール対象のCMakeターゲット（複数指定可） |
| --to | string | Yes | なし | インストール先ディレクトリ |
| -- | separator | No | - | 以降の引数をCMakeに渡す |
| -h, --help | flag | No | - | ヘルプメッセージの表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /tmp/clang-build/src/llvm | Directory | LLVMソースコードディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {--to指定先} | Directory | ビルドされたLLVMツールチェーン |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 指定ターゲットに応じたバイナリ・ライブラリ |
| 出力先 | --to オプションで指定されたパス |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数パース
   └─ --install-target, --to, -- 以降のCMake引数を解析
2. 必須引数検証
   └─ --install-target と --to が指定されていることを確認
3. インストールディレクトリ作成
   └─ 指定されたディレクトリを作成
4. ビルドディレクトリ作成
   └─ /tmp/clang-build/build を作成
5. CMake設定実行
   └─ Ninjaジェネレータでビルド構成を生成
6. Ninjaビルド実行
   └─ 指定されたインストールターゲットをビルド
7. ビルドディレクトリクリーンアップ
   └─ /tmp/clang-build/build を削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数パース]
    B --> C{ヘルプ表示?}
    C -->|Yes| D[使用方法表示]
    D --> E[終了]
    C -->|No| F{install-target指定あり?}
    F -->|No| G[エラー: ターゲット未指定]
    G --> H[終了 exit 1]
    F -->|Yes| I{--to指定あり?}
    I -->|No| J[エラー: インストール先未指定]
    J --> H
    I -->|Yes| K[インストールディレクトリ作成]
    K --> L[ビルドディレクトリ作成]
    L --> M[CMake設定実行]
    M --> N[Ninjaビルド実行]
    N --> O[ビルドディレクトリ削除]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | --install-target 未指定 | ターゲットを指定して再実行 |
| 1 | 引数エラー | --to 未指定 | インストール先を指定して再実行 |
| 1 | 引数エラー | 不明なオプション指定時 | 正しいオプションで再実行 |
| 非0 | ビルドエラー | CMakeまたはNinjaエラー | ビルドログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e` によりエラー発生時は即座にスクリプト終了
2. /tmp/clang-build/build ディレクトリが残存している場合は手動削除
3. ビルドエラーの場合はCMake引数を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | エラー時は手動でクリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | ターゲット依存（数分〜数時間） |
| メモリ使用量上限 | ビルド構成依存 |

## 排他制御

同一コンテナ内での複数実行は想定していない。ビルドディレクトリを共有しないため、異なるコンテナでの並列実行は可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | "Running build" |
| 終了ログ | 処理完了時 | "Done" |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ターゲット依存 | CI/CDシステム |
| 終了コード | 非0 | CI/CDシステム |

## 備考

- 本スクリプトはDockerコンテナ内（`/llvm/utils/docker/scripts/`）に配置される
- ソースコードの場所: `llvm/utils/docker/scripts/build_install_llvm.sh`
- CMake引数は `--` の後に自由に指定可能
- ビルド完了後、ビルドディレクトリは自動的に削除される
- `set -e` によりエラー時は即座に終了する設計
- CLANG_BUILD_DIR は `/tmp/clang-build` に固定
