# バッチ設計書 13-build.sh (libfuzzer)

## 概要

本ドキュメントは、LibFuzzerライブラリのビルドを行う `build.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、LibFuzzerのソースコード（.cppファイル）をコンパイルし、静的ライブラリ `libFuzzer.a` を生成する処理を担当する。

**業務上の目的・背景**：LibFuzzerはLLVMプロジェクトに含まれるカバレッジガイドファジングライブラリである。このライブラリを使用することで、開発者はプログラムのバグやセキュリティ脆弱性を発見するためのファズテストを実施できる。本バッチはLibFuzzerを独立したライブラリとしてビルドし、他のプロジェクトにリンクできる形式で提供することを目的としている。

**バッチの実行タイミング**：LibFuzzerライブラリが必要な場合に手動で実行される。CI/CDパイプラインでのテスト環境構築時にも使用される可能性がある。

**主要な処理内容**：
1. スクリプトディレクトリの取得
2. C++コンパイラの決定（CXX環境変数または clang）
3. ソースディレクトリ内の全.cppファイルを並列コンパイル
4. 既存の libFuzzer.a を削除
5. オブジェクトファイルをアーカイブして libFuzzer.a を生成
6. オブジェクトファイルのクリーンアップ

**前後の処理との関連**：本バッチは独立して実行可能。生成された libFuzzer.a は、ファズテスト対象のプログラムにリンクして使用される。

**影響範囲**：カレントディレクトリに libFuzzer.a が生成される。

## バッチ種別

ビルド処理 / ライブラリ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| C++コンパイラ利用可能 | clangまたはCXX環境変数で指定されたコンパイラが利用可能であること |
| arコマンド利用可能 | アーカイバ(ar)が利用可能であること |
| ソースファイル存在 | スクリプトと同じディレクトリにLibFuzzerソースがあること |

### 実行可否判定

- C++コンパイラが利用可能であること
- LibFuzzerソースファイル（*.cpp）が存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CXX | 環境変数 | No | clang | 使用するC++コンパイラ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $LIBFUZZER_SRC_DIR/*.cpp | C++ Source | LibFuzzerのソースファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| libFuzzer.a | Static Library | コンパイルされたLibFuzzer静的ライブラリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | libFuzzer.a |
| 出力先 | カレントディレクトリ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境設定
   └─ スクリプトディレクトリ取得、CXX変数設定
2. 並列コンパイル
   └─ 全.cppファイルをバックグラウンドでコンパイル
3. コンパイル完了待機
   └─ wait コマンドで全ジョブの完了を待つ
4. 既存ライブラリ削除
   └─ rm -f libFuzzer.a
5. アーカイブ作成
   └─ ar r libFuzzer.a Fuzzer*.o
6. オブジェクトファイル削除
   └─ rm -f Fuzzer*.o
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトディレクトリ取得]
    B --> C[CXX変数設定]
    C --> D[各.cppファイルを並列コンパイル]
    D --> E[wait: 全コンパイル完了待機]
    E --> F[既存libFuzzer.a削除]
    F --> G[ar: 静的ライブラリ作成]
    G --> H[オブジェクトファイル削除]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | コンパイルエラー | ソースコードのコンパイル失敗 | エラーメッセージを確認し修正 |
| 非0 | arエラー | アーカイブ作成失敗 | ディスク空き容量等を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. コンパイルエラー発生時はエラーメッセージを確認
2. 残存オブジェクトファイルを手動削除
3. コンパイラが正しく設定されているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約10-20のソースファイル |
| 目標処理時間 | 数秒〜1分（CPUコア数依存） |
| メモリ使用量上限 | 並列コンパイル数 × 数百MB |

## 排他制御

同一ディレクトリでの複数実行は競合する可能性がある。異なるディレクトリでの並列実行は可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | コンパイル時 | コンパイラの標準出力/エラー |
| エラーログ | エラー発生時 | コンパイラのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- 本スクリプトは `/compiler-rt/lib/fuzzer/` に配置される
- ソースコードの場所: `compiler-rt/lib/fuzzer/build.sh`
- コンパイルオプション: `-g -O2 -fno-omit-frame-pointer -std=c++17`
- 並列コンパイルにより高速なビルドを実現
- バッチ実行時のカレントディレクトリに libFuzzer.a が生成される
