# バッチ設計書 14-buildgo.sh

## 概要

本ドキュメントは、Go言語用ThreadSanitizer（TSan）ランタイムのビルドを行う `buildgo.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、Go言語ランタイムに組み込まれるThreadSanitizer（TSan）ライブラリをビルドする。複数のプラットフォーム（Linux、macOS、Windows、FreeBSD、NetBSD）に対応し、各プラットフォーム向けのオブジェクトファイルを生成する。

**業務上の目的・背景**：Go言語のランタイムにはデータ競合を検出するためのrace detectorが組み込まれている。このrace detectorはThreadSanitizerをベースとしており、Go言語専用にカスタマイズされたランタイムが必要となる。本バッチは、Go言語のビルドプロセスで使用されるTSanランタイムオブジェクトファイル（race_*.syso）を生成することを目的としている。

**バッチの実行タイミング**：Go言語のランタイムを更新する際、またはTSanランタイムの変更時に実行される。Goプロジェクトのリリースプロセスの一部として使用される。

**主要な処理内容**：
1. ホストOS・アーキテクチャの検出
2. ターゲットプラットフォーム向けのコンパイルフラグ設定
3. TSanソースファイルの連結（gotsan.cpp生成）
4. ターゲットプラットフォーム向けオブジェクトファイルのコンパイル
5. テストバイナリのビルドと実行
6. libcへの依存関係チェック

**前後の処理との関連**：生成されたrace_*.sysoファイルはGoのランタイムビルドに統合される。

**影響範囲**：Go言語のrace detector機能に影響。生成されたオブジェクトファイルはGoの標準ライブラリに含まれる。

## バッチ種別

ビルド処理 / ランタイムライブラリ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 / Goリリースプロセス |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Cコンパイラ利用可能 | gcc/clangが利用可能であること |
| TSanソースコード | compiler-rt/lib/tsanディレクトリ内のソースがあること |
| ターゲットOS環境 | クロスコンパイル設定またはネイティブ環境 |

### 実行可否判定

- サポートされているOS/アーキテクチャであること
- 必要なソースファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GOOS | 環境変数 | No | ホストOS | ターゲットOS (linux/darwin/windows/freebsd/netbsd) |
| GOARCH | 環境変数 | No | ホストアーキテクチャ | ターゲットアーキテクチャ (amd64/arm64/ppc64le/mips64等) |
| CC | 環境変数 | No | gcc | Cコンパイラ |
| DEBUG | 環境変数 | No | 空 | デバッグビルド有効化 |
| SILENT | 環境変数 | No | 0 | サイレントモード有効化 |
| SKIP_TEST | 環境変数 | No | 空 | テストスキップ |
| IN_TMPDIR | 環境変数 | No | 0 | 一時ディレクトリでビルド |
| EXTRA_CFLAGS | 環境変数 | No | 空 | 追加コンパイルフラグ |
| CFLAGS | 環境変数 | No | 空 | コンパイルフラグ |
| LDFLAGS | 環境変数 | No | 空 | リンクフラグ |
| ADD_SRCS | 環境変数 | No | 空 | 追加ソースファイル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tsan_go.cpp | C++ Source | Go用TSanメインソース |
| ../rtl/*.cpp | C++ Source | TSanランタイムソース |
| ../../sanitizer_common/*.cpp | C++ Source | Sanitizer共通ソース |
| test.c | C Source | テスト用ソース |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| race_{GOOS}_{GOARCH}.syso | Object File | Goランタイム用TSanオブジェクトファイル |
| gotsan.cpp | C++ Source | 連結されたソースファイル（一時） |
| test | Executable | テストバイナリ（一時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | race_{GOOS}_{GOARCH}.syso |
| 出力先 | カレントディレクトリまたは一時ディレクトリ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. ホストOS・アーキテクチャ検出
   └─ uname -a の結果を解析
2. ターゲットOS・アーキテクチャ決定
   └─ GOOS/GOARCH環境変数、またはホスト設定を使用
3. OS別コンパイルフラグ設定
   └─ Linux/macOS/Windows/FreeBSD/NetBSD別の設定
4. アーキテクチャ別フラグ設定
   └─ amd64/arm64/ppc64le/mips64/riscv64/s390x別の設定
5. ソースファイル連結
   └─ gotsan.cpp生成
6. デバッグビルドチェック
   └─ DEBUG未設定時はデバッグ版もビルド
7. リリースビルド実行
   └─ race_{SUFFIX}.sysoを生成
8. テストバイナリビルド
   └─ test.cとオブジェクトファイルをリンク
9. libc依存チェック
   └─ nm で__libc_シンボルを検査
10. テスト実行
    └─ SKIP_TEST未設定時はテスト実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ホストOS/アーキテクチャ検出]
    B --> C[ターゲット決定]
    C --> D{サポートOS?}
    D -->|No| E[エラー: Unknown platform]
    D -->|Yes| F[OS別フラグ設定]
    F --> G[アーキテクチャ別フラグ設定]
    G --> H[ソースファイル連結]
    H --> I{DEBUG設定?}
    I -->|No| J[デバッグビルド実行]
    I -->|Yes| K[デバッグフラグ使用]
    J --> L[リリースビルド実行]
    K --> L
    L --> M[テストバイナリビルド]
    M --> N{libc依存チェック}
    N -->|依存あり| O[エラー出力]
    N -->|依存なし| P{SKIP_TEST?}
    P -->|Yes| Q[バッチ終了]
    P -->|No| R[テスト実行]
    R --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | プラットフォームエラー | 未サポートOS/アーキテクチャ | サポート対象プラットフォームで実行 |
| 1 | libc依存エラー | libcシンボルへの依存検出 | ソースコードを確認・修正 |
| 非0 | コンパイルエラー | コンパイル失敗 | エラーメッセージを確認 |
| 非0 | テストエラー | テスト実行失敗 | テストログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e` によりエラー発生時は即座にスクリプト終了
2. IN_TMPDIR=1設定時は一時ディレクトリがクリーンアップされる
3. ビルドエラーの場合はコンパイラ出力を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（trap機構で一時ディレクトリクリーンアップ） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プラットフォーム分のビルド |
| 目標処理時間 | 数秒〜数分 |
| メモリ使用量上限 | コンパイラ依存 |

## 排他制御

同一ディレクトリでの複数実行は競合の可能性あり。IN_TMPDIR=1を使用することで回避可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | コンパイル時 | コンパイルコマンド（SILENT=0時） |
| エラーログ | エラー発生時 | "Unknown platform" 等のメッセージ |
| テストログ | テスト時 | テスト実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- 本スクリプトは `compiler-rt/lib/tsan/go/` に配置される
- ソースコードの場所: `compiler-rt/lib/tsan/go/buildgo.sh`
- サポートOS: Linux, macOS (Darwin), Windows (MINGW), FreeBSD, NetBSD
- サポートアーキテクチャ: amd64, arm64, ppc64le, mips64, mips64le, riscv64, s390x, loong64
- SANITIZER_GO=1 マクロでGo専用ビルドを識別
- デッドロック検出バージョン2（SANITIZER_DEADLOCK_DETECTOR_VERSION=2）を使用
- GORACE環境変数でテスト時の挙動を制御
