# バッチ設計書 16-apple-install-libcxx.sh

## 概要

本ドキュメントは、Apple向けlibc++/libc++abiのビルドとインストールを行う `apple-install-libcxx.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、Apple（macOS/iOS）プラットフォーム向けにlibc++およびlibc++abiライブラリをビルドし、ユニバーサルバイナリを生成してインストールする。複数のアーキテクチャ（arm64, x86_64等）に対応し、dSYMデバッグシンボルも出力する。

**業務上の目的・背景**：AppleプラットフォームでのC++アプリケーション開発には、libc++標準ライブラリが必要である。本バッチは、Appleの公式libc++リリースのビルドプロセスを自動化し、複数アーキテクチャに対応したユニバーサルバイナリを生成する。これにより、macOS/iOS等で動作するC++アプリケーションの開発とテストを支援する。

**バッチの実行タイミング**：Appleプラットフォーム向けlibc++のリリースビルド時、またはCI/CDパイプラインでのテスト時に実行される。

**主要な処理内容**：
1. コマンドライン引数のパース（LLVMルート、ビルド/インストール/シンボルディレクトリ、アーキテクチャ、バージョン）
2. 各アーキテクチャ向けのshimライブラリビルド
3. libc++.dylib/libc++abi.dylibの各アーキテクチャ向けビルド
4. lipoによるユニバーサルdylibの作成
5. ストリップ済みdylibのインストール
6. dSYMバンドルの生成とインストール
7. ヘッダーファイルのインストール
8. ライセンスファイルのインストール
9. 静的アーカイブのユニバーサルバイナリ作成

**前後の処理との関連**：Appleプラットフォームのランタイムビルドプロセスの一部として使用される。

**影響範囲**：Appleプラットフォーム上のC++ランタイムに影響。アプリケーションのC++動作に直結する。

## バッチ種別

ビルド処理 / ライブラリインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 / リリースプロセス |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS環境 | macOS上での実行が必要 |
| Xcode利用可能 | xcrunコマンドが利用可能であること |
| Ninja利用可能 | Ninjaビルドシステムが利用可能であること |
| LLVMソース | libcxx/libcxxabiソースが存在すること |

### 実行可否判定

- 必須引数（--llvm-root, --build-dir, --symbols-dir, --install-dir, --architectures, --version）がすべて指定されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --llvm-root | string | Yes | なし | LLVMモノレポのルートパス |
| --build-dir | string | Yes | なし | ビルド作業ディレクトリ |
| --install-dir | string | Yes | なし | インストール先ディレクトリ |
| --symbols-dir | string | Yes | なし | dSYMバンドル出力先ディレクトリ |
| --architectures | string | Yes | なし | ビルド対象アーキテクチャ（スペース区切り） |
| --version | string | Yes | なし | ライブラリバージョン（X.Y.Z形式） |
| --headers-only | flag | No | false | ヘッダーのみインストール |
| -h, --help | flag | No | - | ヘルプメッセージの表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ${llvm_root}/libcxx | Directory | libc++ソースディレクトリ |
| ${llvm_root}/libcxxabi | Directory | libc++abiソースディレクトリ |
| ${llvm_root}/runtimes | Directory | ランタイムCMake設定 |
| ${llvm_root}/libcxx/cmake/caches/Apple.cmake | CMake Cache | Appleビルド設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${install_dir}/usr/lib/libc++.1.dylib | Dynamic Library | libc++ユニバーサルdylib |
| ${install_dir}/usr/lib/libc++.dylib | Symlink | libc++.1.dylibへのシンボリックリンク |
| ${install_dir}/usr/lib/libc++abi.dylib | Dynamic Library | libc++abiユニバーサルdylib |
| ${install_dir}/usr/lib/libc++experimental.a | Static Library | 実験的機能の静的ライブラリ |
| ${install_dir}/usr/include | Directory | ヘッダーファイル |
| ${symbols_dir}/*.dSYM | dSYM Bundle | デバッグシンボル |
| ${install_dir}/usr/local/lib/libcxx/*.a | Static Library | 静的ライブラリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | libc++.1.dylib, libc++abi.dylib等 |
| 出力先 | ${install_dir}/usr/lib |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数パース
   └─ 必須引数の取得と検証
2. パス正規化
   └─ 相対パスを絶対パスに変換
3. アーキテクチャループ開始
   └─ 各アーキテクチャについて以下を実行
4. shimライブラリビルド
   └─ Apple互換性シムをビルド
5. CMake設定
   └─ Ninjaジェネレータでビルド設定
6. ビルド実行
   └─ libc++/libc++abiをビルド（またはヘッダーのみ）
7. アーキテクチャループ終了
8. ユニバーサルdylib作成
   └─ lipoで各アーキテクチャのdylibを統合
9. ストリップ・インストール
   └─ デバッグシンボルを除去してインストール
10. dSYM生成
    └─ dsymutilでデバッグシンボルバンドル生成
11. ヘッダーインストール
    └─ dittoでヘッダーファイルをコピー
12. ライセンスインストール
    └─ LICENSE.TXTをコピー
13. 静的ライブラリ作成
    └─ libtoolでユニバーサル静的ライブラリ生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数パース]
    B --> C{必須引数あり?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[パス正規化]
    E --> F[アーキテクチャループ開始]
    F --> G[shimライブラリビルド]
    G --> H[CMake設定]
    H --> I{headers-only?}
    I -->|Yes| J[ヘッダーのみインストール]
    I -->|No| K[libc++/libc++abiビルド]
    J --> L[次のアーキテクチャ]
    K --> L
    L --> M{全アーキテクチャ完了?}
    M -->|No| F
    M -->|Yes| N{headers-only?}
    N -->|Yes| O[ヘッダーコピーのみ]
    N -->|No| P[lipoでユニバーサルdylib作成]
    P --> Q[strip: デバッグシンボル除去]
    Q --> R[dsymutil: dSYM生成]
    R --> S[シンボリックリンク作成]
    S --> T[experimental.a作成]
    T --> U[ヘッダーインストール]
    O --> U
    U --> V[ライセンスインストール]
    V --> W[静的ライブラリ作成]
    W --> X[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 必須引数未指定 | 必須引数を指定 |
| 1 | 引数エラー | 引数が空文字列 | 正しい値を指定 |
| 1 | 引数エラー | 不明なオプション | 正しいオプションを使用 |
| 非0 | ビルドエラー | CMakeまたはNinjaエラー | ログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e` によりエラー発生時は即座にスクリプト終了
2. ビルドディレクトリを削除して再実行
3. Xcodeのインストール状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | エラー時は手動でクリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | アーキテクチャ数 × 1ビルド |
| 目標処理時間 | アーキテクチャ数 × 数分〜10分 |
| メモリ使用量上限 | ビルド構成依存 |

## 排他制御

ビルドディレクトリを指定するため、同一ディレクトリでの複数実行は競合する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ステップ開始時 | ステップの説明（step関数による表示） |
| エラーログ | エラー発生時 | "error: ..." メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- 本スクリプトは `libcxx/utils/ci/` に配置される
- ソースコードの場所: `libcxx/utils/ci/apple-install-libcxx.sh`
- Apple.cmakeキャッシュファイルを使用してApple向け設定を適用
- shimライブラリでシステムlibc++との互換性を確保
- dSYMバンドルでデバッグシンボルを個別管理
- rootユーザー実行時はヘッダーの所有者をroot:wheelに変更
- ライセンスファイルは/usr/local/OpenSourceLicensesにインストール
