# バッチ設計書 17-build-picolibc.sh

## 概要

本ドキュメントは、組み込み向けCライブラリであるPicolibcのクロスビルドを行う `build-picolibc.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、組み込みシステム向けの軽量Cライブラリ「Picolibc」をソースからビルドする。libc++のベアメタル環境向けテストに使用するためのライブラリを構築する。

**業務上の目的・背景**：libc++をベアメタル環境（OS無し）でテストするためには、基盤となるCライブラリが必要である。Picolibcは小さなフットプリントを持つCライブラリで、組み込み向けのlibc++テスト環境を構築するために使用される。本バッチは、Picolibcのソースをダウンロードし、指定されたターゲット向けにクロスコンパイルを行う。

**バッチの実行タイミング**：libc++のベアメタル環境向けテスト準備時、またはCI/CDパイプラインでの環境構築時に実行される。

**主要な処理内容**：
1. コマンドライン引数のパース（ビルドディレクトリ、インストールディレクトリ、ターゲット）
2. Picolibcソースのダウンロード（GitHub）
3. Mesonクロスビルド設定ファイルの生成
4. Python仮想環境でMesonをインストール
5. Mesonによるビルド設定
6. Mesonによるインストール

**前後の処理との関連**：libc++のベアメタル環境向けテストの前段処理として使用される。

**影響範囲**：指定されたインストールディレクトリにPicolibcがインストールされる。libc++のベアメタルテストに影響する。

## バッチ種別

ビルド処理 / クロスコンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 / CI環境構築時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python3利用可能 | python3コマンドが利用可能であること |
| ネットワーク接続 | GitHubへの接続が可能であること |
| クロスコンパイラ | 指定ターゲット向けコンパイラ（CC環境変数またはcc） |
| LLVMツール | llvm-ar, llvm-as, llvm-strip, lldが利用可能であること |
| unzip | アーカイブ展開用 |
| curl | ソースダウンロード用 |

### 実行可否判定

- 必須引数（--build-dir, --install-dir, --target）がすべて指定されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --build-dir | string | Yes | なし | ビルド作業ディレクトリ |
| --install-dir | string | Yes | なし | インストール先ディレクトリ |
| --target | string | Yes | なし | クロスコンパイルターゲット |
| CC | 環境変数 | No | cc | Cコンパイラ |
| -h, --help | flag | No | - | ヘルプメッセージの表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://github.com/picolibc/picolibc | ZIP Archive | Picolibcソース（特定コミット） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${install_dir}/include | Directory | Picolibcヘッダーファイル |
| ${install_dir}/lib | Directory | Picolibcライブラリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種ヘッダー・ライブラリ |
| 出力先 | ${install_dir}/include, ${install_dir}/lib |
| 文字コード | バイナリ/テキスト |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数パース
   └─ --build-dir, --install-dir, --target の取得と検証
2. ソースダウンロード
   └─ 特定コミットのZIPアーカイブを取得
3. アーカイブ展開
   └─ unzipでソースを展開
4. Mesonクロスビルド設定生成
   └─ meson-cross-build.txtを作成
5. Python仮想環境構築
   └─ python3 -m venv でvenv作成
6. Mesonインストール
   └─ pip install meson==1.9.0
7. Mesonセットアップ
   └─ meson setup で設定
8. Mesonインストール
   └─ meson install でインストール
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数パース]
    B --> C{必須引数あり?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[ソースディレクトリ作成]
    E --> F[curlでZIPダウンロード]
    F --> G[unzipで展開]
    G --> H[ソース移動]
    H --> I[Mesonクロスビルド設定生成]
    I --> J[Python仮想環境作成]
    J --> K[pip: Mesonインストール]
    K --> L[meson setup実行]
    L --> M[meson install実行]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 必須引数未指定 | 必須引数を指定 |
| 1 | 引数エラー | 引数が空文字列 | 正しい値を指定 |
| 1 | 引数エラー | 不明なオプション | 正しいオプションを使用 |
| 非0 | ダウンロードエラー | ネットワークエラー | ネットワーク接続を確認 |
| 非0 | ビルドエラー | Mesonエラー | ログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -e` によりエラー発生時は即座にスクリプト終了
2. ビルドディレクトリを削除して再実行
3. ネットワーク接続状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | エラー時は手動でクリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | 数分〜10分 |
| メモリ使用量上限 | ビルド構成依存 |

## 排他制御

ビルドディレクトリを指定するため、同一ディレクトリでの複数実行は競合する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ダウンロード開始時 | "--- Downloading picolibc" |
| エラーログ | エラー発生時 | "error: ..." メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- 本スクリプトは `libcxx/utils/ci/` に配置される
- ソースコードの場所: `libcxx/utils/ci/build-picolibc.sh`
- Picolibcの特定コミット（48fbc2009c6473293d03d5ec6f190565c6223a5c）を使用
- Meson 1.9.0を使用（Python venv内にインストール）
- クロスビルド設定でsoft float ABIを使用（-mfloat-abi=soft）
- ターゲットはARM向け組み込み環境を想定
- skip_sanity_check=trueでコンパイラ検証をスキップ
- multilib=false, picoexit=falseで最小構成
