# バッチ設計書 18-build-install-linux.sh

## 概要

本ドキュメントは、Linux/x86_64からLinux/ARMへのクロスコンパイルツールチェーンをビルド・インストールする `build-install-linux.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、LLVMとLLVM-GCC-4.2をベースとしたLinux/x86_64からLinux/ARM向けのクロスツールチェーンを構築する。CodeSourceryのARMツールチェーンをベースに、LLVM/LLVM-GCCをビルドしてインストールする。

**業務上の目的・背景**：ARMプロセッサ向けのソフトウェア開発を行う際、x86_64マシン上でARMバイナリをビルドするためのクロスコンパイル環境が必要である。本バッチは、LLVMをベースとしたARMクロスコンパイラ環境を構築し、ARM Linux向けソフトウェア開発を可能にする。これは歴史的なスクリプトであり、LLVM-GCC-4.2時代のツールチェーン構築手順を記録している。

**バッチの実行タイミング**：ARMクロスコンパイル環境の構築が必要な場合に手動で実行される。

**主要な処理内容**：
1. CodeSourcery ARMツールチェーンのインストール
2. LLVMのconfigure/ビルド/インストール
3. LLVM-GCC-4.2のconfigure/ビルド/インストール

**前後の処理との関連**：LLVMとLLVM-GCCのtarballが事前に用意されている必要がある。

**影響範囲**：/usr/local/crosstool以下にクロスツールチェーンがインストールされる。一部処理でsudo権限が必要。

## バッチ種別

ビルド処理 / ツールチェーン構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/x86_64環境 | x86_64 Linuxシステム上で実行 |
| sudo権限 | インストールディレクトリへの書き込みに必要 |
| LLVMソースtarball | LLVM_PKG_PATHに配置 |
| LLVM-GCCソースtarball | LLVM_PKG_PATHに配置 |
| CodeSourceryパッケージ | CODE_SOURCERY_PKG_PATHに配置（またはダウンロード） |

### 実行可否判定

- 必要なtarballが存在すること
- sudo権限が利用可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| INSTALL_ROOT | 環境変数 | No | /usr/local/crosstool | インストール先ルート |
| LLVM_PKG_PATH | 環境変数 | No | ${HOME}/llvm-project/snapshots | LLVMソースtarball配置先 |
| CODE_SOURCERY_PKG_PATH | 環境変数 | No | ${HOME}/codesourcery | CodeSourceryパッケージ配置先 |
| CROSS_MARCH | 環境変数 | No | armv6 | ターゲットARMアーキテクチャ |
| LLVM_SVN_REV | 環境変数 | No | 74530 | LLVMのSVNリビジョン |
| LLVMGCC_SVN_REV | 環境変数 | No | 74535 | LLVM-GCCのSVNリビジョン |
| MAKE_OPTS | 環境変数 | No | -j2 | makeオプション（並列数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| llvm-{rev}.tar.bz2 | tarball | LLVMソースアーカイブ |
| llvm-gcc-4.2-{rev}.tar.bz2 | tarball | LLVM-GCCソースアーカイブ |
| arm-2007q3-*.tar.bz2 | tarball | CodeSourcery ARMツールチェーン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${INSTALL_ROOT}/codesourcery | Directory | CodeSourceryツールチェーン |
| ${INSTALL_ROOT}/${CROSS_TARGET}/llvm | Directory | LLVM インストール |
| ${INSTALL_ROOT}/${CROSS_TARGET}/llvm-gcc-4.2 | Directory | LLVM-GCC インストール |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種コンパイラ・ツール |
| 出力先 | ${INSTALL_ROOT} 以下 |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境設定
   └─ ディレクトリ変数、ターゲット設定
2. ディレクトリ作成
   └─ SRC_ROOT, OBJ_ROOT 作成
3. CodeSourceryインストール
   └─ tarball展開、ツールチェーン検証
4. LLVMインストール
   └─ tarball展開 → configure → make → make install
5. LLVM-GCCインストール
   └─ tarball展開 → configure → make → make install
6. 完了メッセージ
   └─ "Done." 出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境設定]
    B --> C[ディレクトリ作成]
    C --> D{CodeSourcery存在?}
    D -->|Yes| E[CodeSourceryスキップ]
    D -->|No| F[CodeSourceryインストール]
    F --> G{tarball存在?}
    G -->|No| H[エラー終了]
    G -->|Yes| I[tarball展開]
    I --> J[ツールチェーン検証]
    E --> K{LLVM存在?}
    J --> K
    K -->|Yes| L[LLVMスキップ]
    K -->|No| M[LLVM tarball展開]
    M --> N[LLVM configure]
    N --> O[LLVM make]
    O --> P[LLVM make install]
    L --> Q{LLVM-GCC存在?}
    P --> Q
    Q -->|Yes| R[LLVM-GCCスキップ]
    Q -->|No| S[LLVM-GCC tarball展開]
    S --> T[LLVM-GCC configure]
    T --> U[LLVM-GCC make]
    U --> V[LLVM-GCC make install]
    R --> W[Done出力]
    V --> W
    W --> X[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 3 | ディレクトリエラー | 存在するがディレクトリでない | 手動で削除 |
| - | ファイル不足 | tarballが見つからない | パスを修正しtarballを配置 |
| - | ツール不足 | CodeSourceryツールが見つからない | CodeSourceryを正しくインストール |
| 非0 | ビルドエラー | configure/makeエラー | ログファイルを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -o errexit` によりエラー発生時は即座にスクリプト終了
2. ログファイル（*-configure.log, *-build.log, *-install.log）を確認
3. SCRATCH_ROOT（一時ディレクトリ）を削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | エラー時は手動でクリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ツールチェーン |
| 目標処理時間 | 数十分〜数時間（MAKE_OPTS依存） |
| メモリ使用量上限 | LLVMビルド依存（数GB） |

## 排他制御

SCRATCH_ROOTは一時ディレクトリ（mktemp）として作成されるため、複数実行時も競合しない。ただしINSTALL_ROOTへの書き込みは競合の可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | "Welcome to LLVM Linux/X86_64 -> Linux/ARM crosstool..." |
| 進捗ログ | 各コマンド実行時 | runCommand/runAndLog関数経由で出力 |
| 終了ログ | 成功時 | "Done." |
| 詳細ログ | ファイル | *-configure.log, *-build.log, *-install.log |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- 本スクリプトは `llvm/utils/crosstool/ARM/` に配置される
- ソースコードの場所: `llvm/utils/crosstool/ARM/build-install-linux.sh`
- 歴史的スクリプト: LLVM-GCC-4.2時代のツールチェーン構築用
- ターゲット: arm-none-linux-gnueabi
- ホスト: x86_64-unknown-linux-gnu
- sudo権限が必要な箇所あり（sudoCreateDir関数）
- `set -o nounset` で未定義変数使用時にエラー
- `set -o errexit` でコマンドエラー時に終了
- CodeSourcery ARM 2007q3ツールチェーンを前提
