# バッチ設計書 19-runulp.sh

## 概要

本ドキュメントは、数学関数のULP（Units in the Last Place）エラーテストを実行する `runulp.sh` バッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、LLVM libcに含まれる数学関数の精度を検証するULPテストを実行する。様々な数学関数（exp, log, pow, sin, cos等）に対して、異なる丸めモードと入力範囲でテストを行い、精度が許容範囲内であることを確認する。

**業務上の目的・背景**：数学ライブラリの実装において、浮動小数点演算の精度は非常に重要である。ULP（Units in the Last Place）は浮動小数点数の精度を測定する標準的な単位であり、各数学関数が規定された精度要件を満たしているかを検証する必要がある。本バッチは、ARM最適化ルーチン（AOR）ライブラリの数学関数の精度検証を自動化する。

**バッチの実行タイミング**：数学ライブラリの変更後、またはCI/CDパイプラインでの品質検証時に実行される。

**主要な処理内容**：
1. 丸めモード（n, u, d, z）ごとのスカラー関数テスト
2. ULPエラー閾値とテスト範囲の設定
3. 各数学関数（exp, exp2, log, log2, pow, expf, log2f, logf, powf等）のテスト実行
4. ベクトル関数（__s_*, __v_*, __vn_*, _ZGV*）のテスト
5. テスト結果の集計（PASS/FAIL）

**前後の処理との関連**：ulpテストバイナリが事前にビルドされている必要がある。

**影響範囲**：テスト結果のみ出力。ファイルシステムへの永続的な変更なし。

## バッチ種別

テスト実行 / 精度検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動実行 / CIテスト時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ulpバイナリ存在 | ./ulp テストバイナリがビルド済みであること |
| スクリプト実行環境 | bash環境で実行可能であること |

### 実行可否判定

- ./ulp バイナリが存在し、実行可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string | No | なし | エミュレータコマンド（オプション） |
| ULPFLAGS | 環境変数 | No | -q | ulpコマンドへの追加フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ./ulp | Executable | ULPテストバイナリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Text | テスト実行結果 |
| 標準エラー出力 | Text | エラーメッセージ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 環境設定
   └─ 丸めモード(rmodes)、フラグ(flags)、エミュレータ(emu)の設定
2. スカラー関数テスト
   └─ 各丸めモードでexp, exp2, log, log2, pow, expf, exp2f, logf, log2f, powfをテスト
3. ベクトル関数チェック
   └─ __s_*, __v_*, __vn_*関数の存在確認
4. ベクトル関数テスト
   └─ 存在するベクトル関数に対してテスト実行
5. 結果集計
   └─ PASS/FAIL件数をカウント
6. 終了判定
   └─ FAILがあればexit 1、なければ正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境設定]
    B --> C[丸めモードループ開始]
    C --> D[スカラー関数テスト]
    D --> E[PASS/FAILカウント]
    E --> F{全丸めモード完了?}
    F -->|No| C
    F -->|Yes| G[ベクトル関数存在チェック]
    G --> H[ベクトル関数テスト]
    H --> I[結果集計]
    I --> J{FAIL > 0?}
    J -->|Yes| K[エラー出力・exit 1]
    J -->|No| L[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | ULPエラーが閾値を超過 | 数学関数の実装を確認 |
| 非0 | 実行エラー | ulpバイナリ実行失敗 | バイナリのビルドを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `set -eu` によりエラー発生時は即座にスクリプト終了
2. ulpバイナリが正しくビルドされているか確認
3. テスト対象の数学関数実装を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 関数数 × 丸めモード数 × テスト範囲 |
| 目標処理時間 | 数分〜数十分（テスト範囲依存） |
| メモリ使用量上限 | ulpバイナリ依存 |

## 排他制御

テスト実行のみのため、排他制御は不要。複数インスタンスの同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各テスト実行時 | ulpコマンド出力 |
| 結果ログ | テスト完了時 | "FAILED X PASSED Y" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| FAIL件数 | > 0 | CI/CDシステム |
| 終了コード | 1 | CI/CDシステム |

## 備考

- 本スクリプトは `libc/AOR_v20.02/math/test/` に配置される
- ソースコードの場所: `libc/AOR_v20.02/math/test/runulp.sh`
- テスト対象関数: exp, exp2, log, log2, pow (double) / expf, exp2f, logf, log2f, powf (float)
- 丸めモード: n (nearest), u (up), d (down), z (toward zero)
- ベクトル関数サポート: __s_*, __v_*, __vn_*, _ZGV* 形式
- ULP閾値は関数ごとに設定（例: exp=1.9, log=1.2, pow=0.05）
- `set -eu` で未定義変数使用時とエラー時に終了
- ULPFLAGS環境変数でulpコマンドへの追加オプションを指定可能
