# バッチ設計書 2-monolithic-windows.sh

## 概要

本ドキュメントは、LLVMプロジェクトのWindows環境向けモノレポビルドおよびテスト実行バッチ「monolithic-windows.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMモノレポジトリ全体をWindows環境でビルドし、各プロジェクトのテストを実行するCI/CDパイプライン用スクリプトです。clang-clコンパイラとNinjaビルドシステムを使用し、sccacheによるビルドキャッシュを活用して効率的なビルドを実現します。

**業務上の目的・背景**：LLVMプロジェクトはクロスプラットフォーム対応が重要であり、Windows環境での動作検証は不可欠です。本バッチは、Windows固有の問題（マニフェストファイル、リンカー設定等）に対応しながら、統合ビルドとテストを自動化します。これにより、Windows向けの開発においてもリグレッションを検出でき、プラットフォーム間の互換性を維持できます。

**バッチの実行タイミング**：GitHub ActionsによるCI/CDパイプラインの一部として、プルリクエスト作成時およびmainブランチへのマージ時に自動実行されます。

**主要な処理内容**：
1. utils.shの読み込みによる共通設定の初期化
2. Python依存パッケージのインストール
3. clang-clコンパイラの設定
4. CMakeによるビルド構成（マニフェスト無効化オプション含む）
5. Ninjaによるプロジェクトビルド実行
6. Ninjaによるランタイムビルド実行

**前後の処理との関連**：本バッチはutils.shに依存しており、Linux版と共通の関数（start-group等）を使用します。ビルドアーティファクトはartifactsディレクトリに収集されます。

**影響範囲**：Windows環境でのLLVMプロジェクト全体のビルド成果物、テスト結果XML、Ninjaビルドログに影響を与えます。

## バッチ種別

CI/CDビルド・テスト自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | CI/CDパイプライントリガー時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | GitHub Actions イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows環境 | Windows 10以降が必要 |
| コンパイラ | C:/clang/clang-msvc/bin/clang-cl.exeがインストール済み |
| ビルドツール | CMake、Ninja、sccache、MSVCリンカー(link)が利用可能 |
| Python環境 | pip、Python依存パッケージがインストール可能 |

### 実行可否判定

utils.shによりMONOREPO_ROOTが自動検出される。clang-clコンパイラが指定パスに存在する必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| projects | string | Yes | なし | ビルド対象プロジェクト（セミコロン区切り） |
| targets | string | No | なし | Ninjaビルドターゲット |
| runtimes | string | No | なし | ビルド対象ランタイム（セミコロン区切り） |
| runtimes_targets | string | No | なし | ランタイムビルドターゲット |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| MONOREPO_ROOT/llvm | ディレクトリ | LLVMソースコードルート |
| .ci/all_requirements.txt | テキスト | Python依存パッケージリスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${BUILD_DIR}/test-results.xml | XML | LITテスト結果（JUnit形式） |
| ninja.log | テキスト | Ninjaビルドログ |
| ninja.ninja_log | テキスト | Ninja内部ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | test-results.*.xml |
| 出力先 | ${BUILD_DIR}/ |
| 文字コード | UTF-8 |
| 区切り文字 | XML形式 |

## 処理フロー

### 処理シーケンス

```
1. utils.sh読み込み
   └─ 共通設定、関数定義、sccache初期化
2. Python依存パッケージインストール
   └─ pip install -q -r requirements.txt
3. コンパイラ環境変数設定
   └─ CC, CXX, LD設定
4. CMake構成実行
   └─ マニフェスト無効化オプション含む
5. Ninjaビルド実行
   └─ 指定ターゲットのビルド、ログ出力
6. ランタイムビルド実行
   └─ runtimes_targetsが指定された場合のみ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[utils.sh読み込み]
    B --> C[pip install実行]
    C --> D[コンパイラ設定]
    D --> E[CMake構成]
    E --> F{targets指定あり?}
    F -->|あり| G[Ninjaビルド実行]
    F -->|なし| H{runtimes_targets指定あり?}
    G --> H
    H -->|あり| I[ランタイムビルド実行]
    H -->|なし| J[バッチ終了]
    I --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | ビルドエラー | CMakeまたはNinjaが失敗 | ビルドログを確認し、コンパイルエラーを修正 |
| 非0終了 | テストエラー | LITテストが失敗 | test-results.xmlを確認し、失敗テストを修正 |
| 非0終了 | コンパイラエラー | clang-clが見つからない | コンパイラパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ninja.logを確認してビルドエラーの原因を特定
2. test-results.xmlを確認して失敗テストを特定
3. マニフェスト関連のエラーの場合、リンカーフラグを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のフルビルド |
| 目標処理時間 | 環境依存（数十分〜数時間） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ビルドディレクトリでの同時実行は不可。utils.shにより既存のビルドディレクトリは削除される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | CMake開始時 | "::group::CMake" (GitHub Actions環境) |
| 進捗ログ | 各ステップ開始時 | start-group関数によるグループ出力 |
| 終了ログ | バッチ終了時 | at-exit関数によるsccache統計、アーティファクト収集 |
| エラーログ | エラー発生時 | ninja.log、test-results.xmlに出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1200秒（LITテストタイムアウト） | CI/CDシステム |
| テスト失敗 | 1件以上 | GitHub PR |

## 備考

- Windows固有のマニフェスト問題に対応するため、CMAKE_*_LINKER_FLAGSに"/MANIFEST:NO"を設定
- 参照: https://github.com/llvm/llvm-project/pull/82393
- 参照: https://discourse.llvm.org/t/rfc-future-of-windows-pre-commit-ci/76840/40
- COMPILER_RT_BUILD_ORCはWindowsでは無効化
- Linux版と比較してC++26/Clang Modulesの追加テストは実行しない
