# バッチ設計書 20-common.sh (flang)

## 概要

本ドキュメントは、Flang Semanticsテストの共通機能を提供する `common.sh` スクリプトの設計仕様を定義するものである。

### 本バッチの処理概要

このスクリプトは、Flang（LLVMベースのFortranコンパイラ）のSemanticsテストで共通に使用されるシェル関数と変数の初期化を行う。テストスクリプトにsourceされて使用され、引数処理やパス設定などの共通処理を提供する。

**業務上の目的・背景**：Flangコンパイラの開発において、Semantics（意味解析）テストは重要な品質保証活動である。複数のテストスクリプトで共通の処理が必要となるため、本スクリプトで共通機能を集約することで、コードの重複を避け、メンテナンス性を向上させている。

**バッチの実行タイミング**：Flang Semanticsテストスクリプトから source コマンドで読み込まれて使用される。直接実行されることは想定していない。

**主要な処理内容**：
1. 引数数のチェック（3つ以上必要）
2. ソースファイルパスの正規化（絶対パス/相対パス対応）
3. 一時ディレクトリの作成
4. Flang FC1ドライバのパス設定
5. die関数の提供（エラー終了用）

**前後の処理との関連**：テストスクリプトの先頭で source され、以降のテスト処理で $src, $temp, $FLANG_FC1 変数を使用。

**影響範囲**：Flang Semanticsテスト全体の基盤機能として機能。

## バッチ種別

テストユーティリティ / 共通ライブラリ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | テスト実行時 |
| 実行時刻 | テスト実行時 |
| 実行曜日 | テスト実行時 |
| 実行日 | テスト実行時 |
| トリガー | テストスクリプトからのsource |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 引数3つ以上 | ソースファイル、一時ディレクトリ、f18コマンドの3引数が必要 |
| f18実行ファイル存在 | 第3引数で指定されたf18コマンドが存在すること |

### 実行可否判定

- 引数が3つ以上あること
- f18実行ファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | なし | Fortranソースファイルパス |
| $2 | string | Yes | なし | 一時テストディレクトリ |
| $3+ | string | Yes | なし | f18コマンドとオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Fortranソースファイル | .f90/.f等 | テスト対象のFortranソース |

## 出力仕様

### 出力データ

本スクリプトは直接的な出力を行わない。以下の変数を設定する。

| 変数名 | 説明 |
|-------|------|
| $src | ソースファイルの絶対パス |
| $temp | 一時ディレクトリパス |
| $FLANG_FC1 | Flang FC1ドライバコマンド |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（変数設定のみ） |
| 出力先 | なし |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ $# < 3 の場合、使用方法を表示して終了
2. ソースパス設定
   └─ 絶対パス（/始まり）ならそのまま、相対パスならスクリプトディレクトリ基準で解決
3. ソースパス変数からの除去
   └─ shiftで引数を削除
4. 一時ディレクトリ設定と作成
   └─ $1をtempに設定、mkdir -p $temp
5. 一時ディレクトリ変数からの除去
   └─ shiftで引数を削除
6. f18コマンド存在チェック
   └─ $1が存在しない場合、dieで終了
7. FLANG_FC1変数設定
   └─ 残りの全引数を$FLANG_FC1に設定
```

### フローチャート

```mermaid
flowchart TD
    A[source common.sh] --> B{引数 >= 3?}
    B -->|No| C[使用方法表示・exit 1]
    B -->|Yes| D{$1が絶対パス?}
    D -->|Yes| E[src=$1]
    D -->|No| F[src=スクリプトディレクトリ/$1]
    E --> G[shift]
    F --> G
    G --> H[temp=$1, mkdir -p $temp]
    H --> I[shift]
    I --> J{$1ファイル存在?}
    J -->|No| K[die: f18 executable not found]
    J -->|Yes| L[FLANG_FC1=$*]
    L --> M[設定完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が3つ未満 | 正しい引数でテストを再実行 |
| 1 | ファイル不足 | f18実行ファイルが見つからない | f18のパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（設定スクリプトのため） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 引数の正しさを確認
2. f18コマンドのパスを確認
3. ソースファイルの存在を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（変数設定のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1設定 |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 無視可能 |

## 排他制御

一時ディレクトリは引数で指定されるため、異なる一時ディレクトリを使用すれば複数テストの同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 使用方法 | 引数エラー時 | "Usage: $(basename $0) <fortran-source> <temp test dir> <f18-command>" |
| エラーログ | die関数呼び出し時 | "$(basename $0): $*" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | テストフレームワーク |

## 備考

- 本スクリプトは `flang/test/Semantics/` に配置される
- ソースコードの場所: `flang/test/Semantics/common.sh`
- sourceで読み込まれることを前提としたライブラリスクリプト
- die関数: スクリプト名付きでエラーメッセージを出力してexit 1
- 相対パスはスクリプトディレクトリ（dirname $0）基準で解決
- FLANG_FC1には残り全引数（$*）を設定（オプション付きでf18を呼び出し可能）
