# バッチ設計書 21-TestRunner.sh

## 概要

本ドキュメントは、LLVMテストランナーである `TestRunner.sh` の設計仕様を記載したものです。このスクリプトは、LLVM litテストフレームワークへの互換性ラッパーとして機能し、レガシーな呼び出し方法から新しいllvm-litコマンドへの移行を支援します。

### 本バッチの処理概要

**業務上の目的・背景**：LLVMプロジェクトでは、テスト実行ツールとして `lit`（LLVM Integrated Tester）が使用されています。以前は `TestRunner.sh` が直接テストランナーとして機能していましたが、現在はより高機能な `llvm-lit` コマンドに移行しています。本スクリプトは、既存のテストスクリプトやCIパイプラインとの後方互換性を維持するために存在し、古い呼び出し方法が使用された場合に警告を表示しつつ、適切なコマンドに転送します。

**バッチの実行タイミング**：随時実行（テスト実行時）。開発者がレガシーな方法でテストを実行しようとした際に自動的に呼び出されます。

**主要な処理内容**：
1. 非推奨警告メッセージを標準出力に表示
2. 受け取ったすべての引数を `llvm-lit` コマンドに転送
3. `llvm-lit` の実行結果をそのまま返却

**前後の処理との関連**：本スクリプトは単独で実行されることもありますが、主にレガシーなテストスクリプトや古いCI設定から呼び出されます。実際のテスト実行は `llvm-lit` が担当します。

**影響範囲**：LLVMのテスト実行環境全体に影響します。本スクリプトを呼び出す既存のスクリプトは、警告メッセージが出力されるようになりますが、機能的には正常に動作します。

## バッチ種別

テスト実行 / 互換性ラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動/スクリプト呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| llvm-litコマンドの存在 | PATH上にllvm-litが存在する必要がある |
| テスト環境の構築済み | LLVMビルド環境が構築され、litテストが実行可能な状態 |

### 実行可否判定

llvm-litコマンドがPATH上に存在すれば実行可能。存在しない場合はコマンド未発見エラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | 可変長引数 | No | なし | llvm-litに転送されるすべてのオプションとテストパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | 文字列 | llvm-litに渡すオプションとテスト対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 非推奨警告メッセージ + llvm-litの出力 |
| 標準エラー | テキスト | llvm-litのエラー出力 |
| 終了コード | 整数 | llvm-litの終了コードをそのまま返却 |

### 出力ファイル仕様

本スクリプト自体はファイル出力を行わない（llvm-litの設定に依存）。

## 処理フロー

### 処理シーケンス

```
1. 非推奨警告出力
   └─ 標準出力に「'$0' is deprecated, use 'llvm-lit' instead.」を表示
2. llvm-lit実行
   └─ execコマンドでllvm-litに制御を移譲し、全引数を転送
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[警告メッセージ出力]
    B --> C[exec llvm-lit with all arguments]
    C --> D[llvm-litの終了コードで終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 127 | コマンド未発見 | llvm-litがPATH上に存在しない | llvm-litをインストールするか、PATHを設定 |
| その他 | llvm-litエラー | llvm-litが返すエラー | llvm-litのドキュメントを参照 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

llvm-litの実行に失敗した場合は、llvm-litのインストール状態とPATH設定を確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のexec呼び出し |
| 目標処理時間 | 即時（ラッパーのオーバーヘッドは無視可能） |
| メモリ使用量上限 | 最小（execで置き換わるため） |

## 排他制御

本スクリプトは排他制御を行わない。llvm-litの排他制御に依存。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | バッチ開始時 | 非推奨メッセージ（標準出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- 本スクリプトは非推奨（deprecated）であり、新規の使用は推奨されません
- 既存のスクリプトは `llvm-lit` を直接呼び出すように更新することを推奨します
- ソースコード場所: `llvm/test/TestRunner.sh`
