# バッチ設計書 22-bughunter.sh

## 概要

本ドキュメントは、BOLTバグ特定ツールである `bughunter.sh` の設計仕様を記載したものです。このスクリプトは、BOLT（Binary Optimization and Layout Tool）で発生するバグを二分探索によって特定の関数に絞り込むためのデバッグ支援ツールです。

### 本バッチの処理概要

**業務上の目的・背景**：BOLTはバイナリの最適化ツールですが、特定の関数を最適化した際にバグが発生することがあります。このような問題が発生した場合、数千もの関数の中から問題の原因となっている関数を特定することは困難です。本スクリプトは、二分探索アルゴリズムを用いて、問題の関数を効率的に特定することで、デバッグ作業を大幅に軽減します。バイナリサーチにより、O(log n)の効率で問題関数を絞り込むことができます。

**バッチの実行タイミング**：随時実行（デバッグ時）。BOLTで最適化したバイナリに問題が発生した際に、開発者が手動で実行します。

**主要な処理内容**：
1. 入力バイナリの検証（正常に動作することを確認）
2. 最適化バイナリの生成と検証（問題が再現することを確認）
3. 関数リストの取得（nmコマンドまたは指定ファイルから）
4. 二分探索による問題関数の特定（関数名ベースまたはmax-funcsベース）
5. 結果の出力と再現コマンドの表示

**前後の処理との関連**：本スクリプトは単独で実行されます。前提としてBOLTのビルドが完了している必要があります。特定された問題関数の情報は、後続のBOLTデバッグ作業に使用されます。

**影響範囲**：本スクリプトは一時ファイルを生成しますが、最終的にクリーンアップされます。システムへの永続的な影響はありません。デバッグ対象のバイナリや元のソースコードには変更を加えません。

## バッチ種別

デバッグ / バグ特定ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（デバッグ時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| INPUT_BINARY | 実行可能なバイナリファイルのパスが環境変数で設定されていること |
| BOLT | llvm-boltコマンドのパス（デフォルト: llvm-bolt） |
| BOLT_OPTIONS | BOLTに渡すオプション |
| 期待出力の定義 | GOLD_FILEまたはIGNORE_ERRORで成功判定基準が設定されていること |

### 実行可否判定

- INPUT_BINARYが実行可能ファイルとして存在すること
- BOLTコマンドが実行可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BOLT | 環境変数(文字列) | No | llvm-bolt | llvm-boltへのパス |
| BOLT_OPTIONS | 環境変数(文字列) | Yes | なし | BOLTに渡すオプション |
| INPUT_BINARY | 環境変数(文字列) | Yes | なし | 入力バイナリのパス |
| PRE_COMMAND | 環境変数(文字列) | No | : (no-op) | バイナリ実行前のコマンド |
| POST_COMMAND | 環境変数(文字列) | No | cat | 出力フィルタリングコマンド |
| TIMEOUT_OR_CMD | 環境変数(文字列) | No | なし | タイムアウト値またはラッパーコマンド |
| COMMAND_LINE | 環境変数(文字列) | No | なし | バイナリ実行時の引数 |
| IGNORE_ERROR | 環境変数(文字列) | No | 0 | 1の場合エラーコードを無視 |
| GOLD_FILE | 環境変数(文字列) | No | なし | 期待出力ファイル |
| FUNC_NAMES | 環境変数(文字列) | No | なし | 関数名リストファイル |
| OFFLINE | 環境変数(文字列) | No | なし | 設定時は対話モード |
| MAX_FUNCS | 環境変数(文字列) | No | なし | max-funcsモードの初期値 |
| MAX_FUNCS_FLAG | 環境変数(文字列) | No | -max-funcs | 使用するBOLTフラグ |
| VERBOSE | 環境変数(文字列) | No | なし | 設定時は詳細出力 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力バイナリ | 実行可能ファイル | BOLT最適化対象のバイナリ |
| 関数名リスト | テキストファイル | FUNC_NAMES指定時の関数リスト |
| 期待出力 | テキストファイル | GOLD_FILE指定時の比較対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 探索の進捗と結果 |
| 一時ファイル | バイナリ/テキスト | 最適化バイナリ、ログ、出力ファイル（実行後削除） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 一時バイナリ | ${INPUT_BINARY}.XXX.bolt |
| ログファイル | boltXXX.log |
| 出力ファイル | ${OPTIMIZED_BINARY}.out |
| 関数リスト | func-names.XXX.txt |

## 処理フロー

### 処理シーケンス

```
1. 環境変数の初期化
   └─ デフォルト値の設定、core dumpの無効化
2. 入力バイナリの検証（OFFLINEモード以外）
   └─ 元のバイナリが正常に動作することを確認
3. 最適化バイナリの生成と検証
   └─ BOLT_OPTIONSで最適化し、失敗することを確認
4. 関数リストの取得
   └─ nmコマンドまたはFUNC_NAMESから関数名を抽出
5. 二分探索ループ
   └─ 関数の半分を選択してテスト、成功/失敗で範囲を絞り込み
6. 結果出力
   └─ 問題関数と再現コマンドを表示
7. クリーンアップ
   └─ 一時ファイルの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数初期化]
    B --> C{OFFLINEモード?}
    C -->|No| D[入力バイナリ検証]
    C -->|Yes| E[最適化バイナリ生成]
    D --> E
    E --> F{最適化成功?}
    F -->|Yes| G[最適化バイナリ実行]
    F -->|No| H[BOLTクラッシュとして処理]
    G --> I{失敗確認?}
    I -->|No| J[警告: 最適化バイナリがパス]
    I -->|Yes| K[関数リスト取得]
    H --> K
    J --> K
    K --> L{MAX_FUNCSモード?}
    L -->|No| M[関数名で二分探索]
    L -->|Yes| N[max-funcsで二分探索]
    M --> O{収束?}
    N --> O
    O -->|No| P[範囲を半分に]
    P --> M
    P --> N
    O -->|Yes| Q[結果出力]
    Q --> R[一時ファイル削除]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力エラー | INPUT_BINARYが未設定または非実行ファイル | 環境変数を正しく設定 |
| N/A | 再現不可 | 最適化バイナリが正常に動作 | 問題の再現条件を確認 |
| N/A | 特定不可 | 二分探索で収束しない | 探索条件やGOLD_FILEを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（二分探索内で自動的に継続） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- 入力バイナリの検証に失敗した場合は、バイナリ自体の問題を確認
- 最適化バイナリが正常に動作する場合は、問題の再現条件を見直し
- 二分探索が収束しない場合は、GOLD_FILEやPOST_COMMANDの設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | log2(関数数)回のイテレーション |
| 目標処理時間 | 関数数とバイナリ実行時間に依存 |
| メモリ使用量上限 | バイナリサイズに依存 |

## 排他制御

本スクリプトは排他制御を行わないが、一時ファイル名にランダムサフィックスを使用することで衝突を回避。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各イテレーション | 「Iteration N, trying FF / HALF functions」 |
| BOLTログ | BOLT実行時 | BOLTの出力（一時ファイルに保存） |
| 結果ログ | 探索終了時 | 「The function(s) that failed are in FF」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（対話型ツール） |

## 備考

- TIMEOUT_OR_CMD環境変数で実行時間制限やラッパーコマンドを指定可能
- OFFLINEモードでは、バイナリの実行結果を手動で入力（0=成功、1=失敗）
- VERBOSEモードでコマンドの詳細を表示
- MAX_FUNCSモードでは、-max-funcs（または指定フラグ）を使用した数値ベースの探索が可能
- ソースコード場所: `bolt/utils/bughunter.sh`
