# バッチ設計書 23-macos-setup-codesign.sh

## 概要

本ドキュメントは、macOS用コード署名設定スクリプトである `macos-setup-codesign.sh` の設計仕様を記載したものです。このスクリプトは、LLDBデバッガがmacOS上でプロセスにアタッチするために必要な自己署名証明書を生成・インストールします。

### 本バッチの処理概要

**業務上の目的・背景**：macOSでは、セキュリティ上の理由からデバッガが他のプロセスにアタッチするためにはコード署名が必要です。LLDBを使用してデバッグを行う際、適切な証明書でLLDBバイナリが署名されている必要があります。本スクリプトは、開発者がLLDB開発環境をセットアップする際に、必要な `lldb_codesign` 証明書を自動的に生成し、システムキーチェーンにインストールします。

**バッチの実行タイミング**：初回セットアップ時（1回のみ）。LLDB開発環境の初期構築時、またはmacOSのクリーンインストール後に実行します。

**主要な処理内容**：
1. 既存証明書の確認（System keychain内にlldb_codesign証明書が存在するか）
2. 証明書テンプレートファイルの生成（OpenSSL用設定）
3. 自己署名証明書の生成（RSA 2048bit、SHA-512、有効期限10年）
4. 証明書のシステムキーチェーンへのインストール（信頼されたルート証明書として）
5. 秘密鍵のシステムキーチェーンへのインポート
6. taskgatedデーモンの再起動（設定反映のため）
7. 一時ファイルのクリーンアップ

**前後の処理との関連**：本スクリプトはLLDBのビルド・インストール前に実行する必要があります。証明書がインストールされた後、LLDBバイナリはこの証明書で署名され、デバッグ機能が有効になります。

**影響範囲**：システムキーチェーン（/Library/Keychains/System.keychain）に証明書と秘密鍵が追加されます。また、taskgatedデーモンが再起動されます。管理者権限（sudo）が必要です。

## バッチ種別

環境構築 / セキュリティ設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初回のみ |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行（セットアップ時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS環境 | macOS上でのみ実行可能 |
| 管理者権限 | sudoが実行可能であること |
| OpenSSL | opensslコマンドが利用可能であること |
| security | macOSのsecurityコマンドが利用可能であること |

### 実行可否判定

- lldb_codesign証明書がシステムキーチェーンに既に存在する場合は処理をスキップ（正常終了）
- 証明書が存在しない場合に新規生成・インストールを実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | N/A | N/A | N/A | コマンドライン引数なし |

### 入力データソース

本スクリプトは外部入力を必要としない。

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| システムキーチェーン | 証明書 | lldb_codesign証明書 |
| システムキーチェーン | 秘密鍵 | lldb_codesign用RSA秘密鍵 |
| 標準出力 | テキスト | 処理状況メッセージ |
| 標準エラー | テキスト | エラーメッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 一時テンプレート | $TMPDIR/lldb_codesign.tmpl |
| 一時証明書 | $TMPDIR/lldb_codesign.cer |
| 一時秘密鍵 | $TMPDIR/lldb_codesign.key |

※上記一時ファイルはスクリプト終了時にtrapでクリーンアップされる

## 処理フロー

### 処理シーケンス

```
1. 既存証明書チェック
   └─ security find-certificateで確認、存在すれば終了コード0で終了
2. 証明書テンプレート生成
   └─ OpenSSL設定をヒアドキュメントで作成
3. 証明書生成
   └─ openssl reqで自己署名証明書と秘密鍵を生成
4. 証明書インストール
   └─ sudo security add-trusted-certでシステムキーチェーンに追加
5. 秘密鍵インポート
   └─ sudo security importでシステムキーチェーンに追加
6. taskgated再起動
   └─ sudo pkill -f /usr/libexec/taskgatedで再起動
7. クリーンアップ（EXIT trap）
   └─ 一時ファイルの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{証明書存在?}
    B -->|Yes| C[メッセージ出力して終了]
    B -->|No| D[テンプレート生成]
    D --> E[証明書生成]
    E --> F{生成成功?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[証明書インストール]
    H --> I{インストール成功?}
    I -->|No| G
    I -->|Yes| J[秘密鍵インポート]
    J --> K{インポート成功?}
    K -->|No| G
    K -->|Yes| L[taskgated再起動]
    L --> M[正常終了]
    C --> N[バッチ終了]
    G --> O[一時ファイル削除]
    M --> O
    O --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### キーチェーン操作詳細

| 操作 | 対象 | 詳細 |
|-----|------|------|
| 検索 | System.keychain | lldb_codesign証明書の存在確認 |
| 追加 | System.keychain | 信頼されたルート証明書として追加 |
| インポート | System.keychain | 秘密鍵のインポート（-Aフラグで全アプリからアクセス可能） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 証明書生成エラー | OpenSSLコマンド失敗 | OpenSSLのインストール確認 |
| 1 | インストールエラー | security add-trusted-cert失敗 | 管理者権限・キーチェーン状態確認 |
| 1 | インポートエラー | security import失敗 | 管理者権限・キーチェーン状態確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- 証明書生成に失敗した場合は、OpenSSLのインストール状態を確認
- キーチェーン操作に失敗した場合は、管理者権限とシステムキーチェーンの状態を確認
- 既存の不正な証明書がある場合は、Keychain Access.appから手動で削除後に再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（アトミックではない） |
| コミットタイミング | 各操作ごとに即時反映 |
| ロールバック条件 | 自動ロールバックなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小 |

## 排他制御

本スクリプトは排他制御を行わない。複数回実行しても、2回目以降は証明書存在チェックでスキップされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 証明書存在時 | 「Certificate has already been generated and installed」 |
| 情報ログ | 生成開始時 | 「Generating and installing lldb_codesign certificate」 |
| エラーログ | エラー発生時 | 「error: Something went wrong when...」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（手動実行ツール） |

## 備考

- 証明書の有効期限は3650日（約10年）
- RSA鍵長は2048bit、ハッシュアルゴリズムはSHA-512
- keyUsageはdigitalSignature（critical）
- extendedKeyUsageはcodeSigning（critical）
- 秘密鍵は-Aフラグで全アプリケーションからアクセス可能に設定
- trapでEXIT時に一時ファイルをクリーンアップ
- ソースコード場所: `lldb/scripts/macos-setup-codesign.sh`
