# バッチ設計書 25-check_cmake.sh

## 概要

本ドキュメントは、TSan CMakeビルドチェックスクリプトである `check_cmake.sh` の設計仕様を記載したものです。このスクリプトは、ThreadSanitizer (TSan) を含むLLVM Sanitizerのビルドと検証テストを自動化します。

### 本バッチの処理概要

**業務上の目的・背景**：ThreadSanitizer（TSan）は、マルチスレッドプログラムにおけるデータ競合を検出するツールです。TSanの開発では、ビルド構成が正しく動作することを継続的に検証する必要があります。本スクリプトは、CMake/Ninjaベースのビルドシステムを使用して、compiler-rtプロジェクト内のSanitizerコンポーネント（TSan、ASan、MSan、LSan）のビルドとテストを一括で実行します。

**バッチの実行タイミング**：随時実行（開発時）。Sanitizerの変更をコミットする前の検証、またはビルド環境の正常性確認時に実行します。

**主要な処理内容**：
1. ビルドディレクトリの作成または既存ディレクトリへの移動
2. CMake設定の実行（初回のみ）- Clang/Clang++コンパイラ、Ninja、Release、Assertions有効、-Werror有効
3. Ninjaによるプロジェクトビルド
4. check-sanitizerテストの実行
5. check-tsanテストの実行
6. check-asanテストの実行
7. check-msanテストの実行
8. check-lsanテストの実行

**前後の処理との関連**：本スクリプトは単独で実行可能です。前提として、ClangとCMakeがインストールされている必要があります。Sanitizerの開発ワークフローの一部として、コード変更後の検証に使用されます。

**影響範囲**：スクリプト実行ディレクトリ配下に `llvm-build` ディレクトリが作成され、ビルド成果物が配置されます。システム全体への影響はありません。

## バッチ種別

ビルド / テスト検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Clangインストール済み | clang/clang++がPATH上に存在すること |
| CMakeインストール済み | cmakeコマンドが利用可能であること |
| Ninjaインストール済み | ninjaコマンドが利用可能であること |
| LLVMソースコード | スクリプトの4階層上にLLVMルートがあること |

### 実行可否判定

- set -eにより、いずれかのコマンドが失敗した時点でスクリプトが終了
- set -uにより、未定義変数の使用でエラー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | N/A | N/A | N/A | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| LLVMソースツリー | ディレクトリ | ビルド対象のソースコード（スクリプトの4階層上） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| llvm-build/ | ディレクトリ | ビルド成果物 |
| 標準出力 | テキスト | CMake/Ninja/テストの出力 |
| 標準エラー | テキスト | エラーメッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ビルドディレクトリ | $ROOT/llvm-build |
| CMakeキャッシュ | $ROOT/llvm-build/CMakeCache.txt |
| ビルド成果物 | $ROOT/llvm-build/lib/, bin/等 |

## 処理フロー

### 処理シーケンス

```
1. カレントディレクトリ解決
   └─ スクリプトのあるディレクトリをROOTとして取得
2. ビルドディレクトリ処理
   ├─ 存在する場合: ディレクトリに移動
   └─ 存在しない場合: ディレクトリ作成、CMake設定実行
3. Ninjaビルド実行
   └─ プロジェクト全体のビルド
4. テスト実行（順次）
   ├─ check-sanitizer
   ├─ check-tsan
   ├─ check-asan
   ├─ check-msan
   └─ check-lsan
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ROOT変数設定]
    B --> C{llvm-build存在?}
    C -->|Yes| D[ディレクトリ移動]
    C -->|No| E[ディレクトリ作成]
    E --> F[CMake設定実行]
    F --> D
    D --> G[ninja実行]
    G --> H[ninja check-sanitizer]
    H --> I[ninja check-tsan]
    I --> J[ninja check-asan]
    J --> K[ninja check-msan]
    K --> L[ninja check-lsan]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | CMakeエラー | cmake設定失敗 | CMake/Clangのインストール確認 |
| 非ゼロ | ビルドエラー | ninja失敗 | コンパイルエラーを修正 |
| 非ゼロ | テストエラー | check-*失敗 | テスト失敗の原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（set -eで即時終了） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- CMake設定に失敗した場合は、llvm-buildディレクトリを削除して再実行
- ビルドエラーの場合は、ソースコードのコンパイルエラーを修正
- テスト失敗の場合は、個別のテストログを確認して原因を調査

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（手動でllvm-buildを削除） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 5テストスイートの実行 |
| 目標処理時間 | 数十分〜数時間（初回ビルド時） |
| メモリ使用量上限 | ビルド規模に依存（数GB） |

## 排他制御

本スクリプトは排他制御を行わない。同一ディレクトリでの並列実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| CMakeログ | CMake実行時 | 設定情報 |
| ビルドログ | ninja実行時 | コンパイル進捗 |
| テストログ | テスト実行時 | テスト結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（手動実行ツール） |

## 備考

- CMakeオプション: `-G Ninja -DLLVM_ENABLE_WERROR=ON -DCMAKE_BUILD_TYPE=Release -DLLVM_ENABLE_ASSERTIONS=ON`
- Clang/Clang++コンパイラを使用（CC=clang CXX=clang++）
- LLVMソースツリーは `$ROOT/../../../..` に期待
- set -e, set -uでエラー時の挙動を厳格化
- ソースコード場所: `compiler-rt/lib/tsan/check_cmake.sh`
