# バッチ設計書 26-analyze_libtsan.sh

## 概要

本ドキュメントは、TSanライブラリシンボル解析スクリプトである `analyze_libtsan.sh` の設計仕様を記載したものです。このスクリプトは、ThreadSanitizer（TSan）ランタイムの生成コード品質を分析し、主要な関数の命令構成を統計情報として出力します。

### 本バッチの処理概要

**業務上の目的・背景**：TSanは高性能なデータ競合検出ツールであり、そのランタイムの性能が重要です。特に、`__tsan_read*`、`__tsan_write*`、`__tsan_func_entry`、`__tsan_func_exit`などのホットな関数は、インストルメントされたプログラムの全関数呼び出しで実行されるため、その効率が全体的なパフォーマンスに大きく影響します。本スクリプトは、これらの関数の逆アセンブリを解析し、命令の種類と数を統計化することで、コード生成の品質評価と最適化の指針を提供します。

**バッチの実行タイミング**：随時実行（開発・分析時）。TSanランタイムの変更後やパフォーマンス分析時に実行します。

**主要な処理内容**：
1. 指定バイナリの逆アセンブリ取得（objdumpコマンド）
2. シンボルテーブルからTSan関数を抽出（nmコマンド）
3. 各TSan関数（write1-8、read1-8、func_entry、func_exit）の解析
4. 命令種別（mov、lea、push、pop、call、shr/shl、cmp/test等）のカウント
5. 関数サイズ、命令数、メモリ操作数等の統計出力

**前後の処理との関連**：本スクリプトは単独で実行可能です。TSanでコンパイルされたバイナリが入力として必要です。出力される統計情報は、TSan開発者がコード生成の品質を評価するために使用します。

**影響範囲**：一時ディレクトリに解析ファイルを出力しますが、システムへの永続的な影響はありません。解析対象のバイナリは読み取りのみで変更されません。

## バッチ種別

解析 / パフォーマンス分析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（分析時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| objdumpコマンド | 逆アセンブリ生成に必要 |
| nmコマンド | シンボルテーブル抽出に必要 |
| grepコマンド | パターンマッチングに必要 |
| awkコマンド | データ処理に必要 |
| wc/cut/printf | 統計処理・出力に必要 |

### 実行可否判定

- コマンドライン引数が1つでない場合、使用方法を表示して終了
- set -e, set -uでエラー時の挙動を厳格化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | 文字列 | Yes | なし | TSanでビルドされたバイナリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| バイナリファイル | ELF/Mach-O | TSanでインストルメントされた実行可能ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各関数の統計情報（フォーマット済み） |
| 一時ディレクトリ | テキスト | objdump出力、nm出力、個別アセンブリファイル |

### 出力フォーマット

```
関数名 tot 行数; size サイズ; rsp RSP操作数; push PUSH数; pop POP数; call CALL数; load LOAD数; store STORE数; sh SHIFT数; mov MOV数; lea LEA数; cmp CMP数
```

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ 引数が1つでなければ使用方法を表示して終了
2. 一時ディレクトリ作成
   └─ mktempで出力ディレクトリを作成
3. objdump実行
   └─ バイナリ全体の逆アセンブリを一時ファイルに保存
4. nm実行
   └─ __tsan_*シンボルを抽出して一時ファイルに保存
5. 関数リストのループ処理
   └─ write1-8, read1-8, func_entry, func_exitの各関数に対して:
      ├─ get_asm関数でアセンブリを抽出
      ├─ 各種命令をgrepでカウント
      └─ printfでフォーマット済み統計を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数 != 1| C[使用方法出力・終了]
    B -->|引数 == 1| D[一時ディレクトリ作成]
    D --> E[objdump実行]
    E --> F[nm実行・TSanシンボル抽出]
    F --> G[関数リストでループ開始]
    G --> H[get_asmでアセンブリ抽出]
    H --> I[各命令カウント]
    I --> J[統計情報出力]
    J --> K{次の関数?}
    K -->|Yes| G
    K -->|No| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が1つでない | 正しい引数でスクリプトを実行 |
| 非ゼロ | コマンドエラー | objdump/nm失敗 | バイナリパスを確認、ツールのインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- 引数エラーの場合は、使用方法に従って正しいパスを指定
- objdump/nmの失敗は、ツールのインストール状態とバイナリの形式を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 10関数の解析 |
| 目標処理時間 | バイナリサイズに依存（数秒〜数分） |
| メモリ使用量上限 | 逆アセンブリファイルサイズに依存 |

## 排他制御

本スクリプトは排他制御を行わない。一時ディレクトリにランダムサフィックスを使用して衝突を回避。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 各関数解析後 | 統計情報（標準出力） |
| 一時ファイル | 解析中 | objdump出力、nm出力、個別アセンブリ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（手動実行ツール） |

## 備考

- 解析対象関数リスト: write1, write2, write4, write8, read1, read2, read4, read8, func_entry, func_exit
- get_asm関数でobjdump出力から特定関数のアセンブリを抽出（次の関数まで）
- nmの-Sオプションでシンボルサイズを取得
- awkの--non-decimal-dataで16進数サイズを10進数に変換
- grepでカウントする命令: (%rsp), push, pop, call, mov/cmp+メモリ参照, mov+ストア, mov, lea, shr/shl, cmp/test
- ソースコード場所: `compiler-rt/lib/tsan/analyze_libtsan.sh`
