# バッチ設計書 27-diag-build.sh

## 概要

本ドキュメントは、Clang警告表示ラッパーである `diag-build.sh` の設計仕様を記載したものです。このスクリプトは、ビルドシステムのラッパーとして動作し、プロジェクトで有効になっている警告オプションを `diagtool show-enabled` コマンドで表示します。

### 本バッチの処理概要

**業務上の目的・背景**：Clangコンパイラには多数の警告オプションが存在し、プロジェクトごとに異なる警告設定が使用されています。開発者がプロジェクトでどの警告が有効になっているかを確認するのは、特に複雑なビルドシステムでは困難です。本スクリプトは、`diagtool show-enabled`（Clang付属の診断ツール）のラッパーとして機能し、ビルドシステム（make、xcodebuild等）から実際のコンパイルコマンドを抽出して、有効な警告の一覧を表示します。

**バッチの実行タイミング**：随時実行（開発時）。プロジェクトの警告設定を確認したい時、新しい警告を追加・削除する際の影響確認時に実行します。

**主要な処理内容**：
1. コンパイラパス（CC/CXX環境変数）の解決
2. diagtoolコマンドの検索
3. ビルドコマンドのドライラン実行（-dry-run/-n）
4. コンパイルコマンドの抽出とパース
5. diagtool show-enabledコマンドへの変換と実行
6. 有効な警告オプションの一覧表示

**前後の処理との関連**：本スクリプトは単独で実行可能です。ビルドシステム（make、xcodebuild）に対するラッパーとして動作します。出力結果は、警告設定の確認やドキュメント作成に使用できます。

**影響範囲**：読み取り専用の操作で、ファイルシステムやビルド成果物への変更は行いません。ドライラン（-dry-run/-n）でビルドコマンドを取得するため、実際のコンパイルは行われません。

## バッチ種別

解析 / ビルドシステムラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| diagtool | diagtoolコマンドがPATH上に存在すること |
| Clang | clang/clang++がPATH上に存在すること |
| ビルドシステム | make/xcodebuild等が利用可能であること |

### 実行可否判定

- diagtoolが見つからない場合はエラー終了
- CC環境変数が未設定でClangも見つからない場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -v | フラグ | No | なし | Verboseモード（実行コマンドを表示） |
| $1 | 文字列 | Yes | なし | ビルドツール名（make/xcodebuild等） |
| $@ | 可変長 | No | なし | ビルドツールに渡すオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ビルドシステム出力 | テキスト | ドライランで出力されるコンパイルコマンド |
| CC/CXX環境変数 | 文字列 | 使用するコンパイラのパス |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 有効な警告オプションの一覧（diagtool出力） |
| 標準エラー | テキスト | エラーメッセージ、警告 |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. sedフラグの検出
   └─ BSD sed (-E) / GNU sed (-r) のどちらかを判定
2. Verboseモード確認
   └─ -vフラグがあれば設定
3. CC/CXX変数の解決
   ├─ 環境変数が設定されていればそれを使用
   └─ 未設定の場合はclang/clang++を検索
4. diagtoolの検索
   └─ PATH上またはスクリプト同一ディレクトリから検索
5. ビルドツール判定
   ├─ xcodebuild: -dry-run, CC/CXX設定
   ├─ make: -n, CC/CXX設定
   └─ その他: CC環境変数が必要
6. ビルドコマンド抽出
   └─ ドライランを実行し、コンパイルコマンドをgrep/sed/headで抽出
7. コマンド変換
   └─ CC/CXXをdiagtool show-enabledに置換
8. コマンド実行
   └─ 変換されたコマンドを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[sedフラグ検出]
    B --> C{-vフラグ?}
    C -->|Yes| D[verbose設定]
    C -->|No| E[CC/CXX解決]
    D --> E
    E --> F{CC設定済み?}
    F -->|No| G[clang検索]
    F -->|Yes| H[diagtool検索]
    G --> H
    H --> I{diagtool発見?}
    I -->|No| J[エラー終了]
    I -->|Yes| K[ビルドツール判定]
    K --> L{xcodebuild/make?}
    L -->|Yes| M[dry_run/set_compiler設定]
    L -->|No| N{CC設定済み?}
    N -->|No| O[エラー終了]
    N -->|Yes| M
    M --> P[ドライラン実行]
    P --> Q[コンパイルコマンド抽出]
    Q --> R{コマンド発見?}
    R -->|No| S[エラー終了]
    R -->|Yes| T[diagtoolコマンドに変換]
    T --> U[コマンド実行]
    U --> V[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コンパイラ未発見 | CC未設定かつclangが見つからない | CC環境変数を設定 |
| 1 | diagtool未発見 | diagtoolがPATHにない | diagtoolをインストール |
| 1 | CC必須エラー | 不明なビルドシステムでCC未設定 | CC環境変数を設定 |
| 2 | コマンド未発見 | ビルドコマンドを抽出できない | ビルドシステムの設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- コンパイラが見つからない場合は、CC/CXX環境変数を設定
- diagtoolが見つからない場合は、LLVMツールをインストール
- ビルドコマンドが抽出できない場合は、ビルドシステムの出力形式を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクトの解析 |
| 目標処理時間 | ビルドシステムのドライラン時間に依存 |
| メモリ使用量上限 | 最小 |

## 排他制御

本スクリプトは排他制御を行わない。読み取り専用の操作のため、並列実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Verboseログ | -v指定時 | 実行されるコマンド |
| エラーログ | エラー発生時 | エラーメッセージ |
| 警告ログ | 不明ビルドシステム時 | 警告メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（手動実行ツール） |

## 備考

- scan-buildと同様のアプローチでビルドコマンドを傍受
- xcodebuildとmakeに対応、他のビルドシステムはCC環境変数が必要
- BSD sed（-E）とGNU sed（-r）の両方に対応
- コンパイルコマンドからif文を除去、バックスラッシュで続く行を結合
- CC/CXXをdiagtool show-enabledに置換して実行
- 末尾の&&、||、;を除去
- ソースコード場所: `clang/tools/diag-build/diag-build.sh`
