# バッチ設計書 28-find-unused-diagnostics.sh

## 概要

本ドキュメントは、未使用診断メッセージ検出スクリプトである `find-unused-diagnostics.sh` の設計仕様を記載したものです。このスクリプトは、Clangの診断メッセージ定義ファイル（.tdファイル）で定義されているが、ソースコード内で使用されていない診断識別子を検出します。

### 本バッチの処理概要

**業務上の目的・背景**：Clangコンパイラには、エラー（err_）、警告（warn_）、拡張（ext_）、ノート（note_）といった多数の診断メッセージが定義されています。開発の過程で、一部の診断メッセージが使用されなくなることがあります。未使用の診断メッセージはコードベースの肥大化を招き、メンテナンスコストを増加させます。本スクリプトは、定義済みだが未使用の診断識別子を自動検出し、コードベースのクリーンアップを支援します。

**バッチの実行タイミング**：随時実行（コード品質チェック時）。定期的なコードレビュー、リファクタリング前後、リリース前の品質チェック時に実行します。

**主要な処理内容**：
1. Diagnostic*.tdファイルから診断識別子を抽出（err_、warn_、ext_、note_プレフィックス）
2. ソースコード（*.cpp、*.h）から使用されている診断識別子を抽出
3. .tdファイルに定義されているが、ソースコードで使用されていない識別子を出力

**前後の処理との関連**：本スクリプトは単独で実行可能です。Clangのソースコードディレクトリ（include/clang/Basic/、lib/、tools/等）が必要です。出力結果は、不要な診断メッセージの削除作業に使用されます。

**影響範囲**：読み取り専用の操作で、ファイルシステムへの変更は行いません。結果は標準出力に出力されるのみです。

## バッチ種別

解析 / コード品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（品質チェック時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Clangソースツリー | clang/ディレクトリ内で実行すること |
| grep/find/comm | 標準UNIXコマンドが利用可能であること |

### 実行可否判定

- include/clang/Basic/Diagnostic*.tdファイルが存在すること
- lib、include、tools、utilsディレクトリが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | N/A | N/A | N/A | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Diagnostic*.td | TableGenファイル | 診断メッセージ定義 |
| *.cpp, *.h | ソースコード | 診断識別子の使用箇所 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 未使用の診断識別子（1行1識別子） |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

### 出力例

```
err_old_feature_removed
warn_deprecated_option
note_unused_diagnostic
```

## 処理フロー

### 処理シーケンス

```
1. 診断識別子の収集（.tdファイル）
   └─ Diagnostic*.tdからerr_/warn_/ext_/note_プレフィックスの識別子を抽出
2. 使用識別子の収集（ソースコード）
   └─ lib/include/tools/utils配下の*.cpp/*.hからerr_/warn_/ext_/note_を抽出
3. 差分の出力
   └─ commコマンドで.tdにあってソースにない識別子を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Diagnostic*.tdから識別子抽出]
    B --> C[ソースファイル一覧取得]
    C --> D[ソースから使用識別子抽出]
    D --> E[両方をソートしてユニーク化]
    E --> F[commで差分抽出]
    F --> G[未使用識別子を出力]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | ファイル未発見 | Diagnostic*.tdが存在しない | clangディレクトリ内で実行 |
| 非ゼロ | ディレクトリ未発見 | lib/include/tools/utilsが存在しない | Clangソースツリーで実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- ファイルが見つからない場合は、clangソースディレクトリで実行しているか確認
- grep/find/commコマンドが正常に動作するか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千の診断識別子を検査 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小（grepのバッファサイズ程度） |

## 排他制御

本スクリプトは排他制御を行わない。読み取り専用の操作のため、並列実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 処理完了時 | 未使用診断識別子リスト |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（手動実行ツール） |

## 備考

- 検出対象のプレフィックス: err_, warn_, ext_, note_
- 正規表現: `(err_|warn_|ext_|note_)[a-z_]+`
- grep -Eで拡張正規表現を使用
- --only-matchingでマッチ部分のみ抽出
- --no-filenameでファイル名を除外
- sort -uで重複を除去してソート
- comm -23で「.tdにあってソースにない」ものを出力
- プロセス置換（<(...)）を使用してパイプラインを構築
- ソースコード場所: `clang/utils/find-unused-diagnostics.sh`
