# バッチ設計書 3-utils.sh

## 概要

本ドキュメントは、LLVMプロジェクトのCI共通ユーティリティ関数を提供するバッチ「utils.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、monolithic-linux.shおよびmonolithic-windows.shで使用される共通設定とユーティリティ関数を提供するスクリプトです。ビルド環境の初期化、sccache統計の収集、テスト結果の集約、GitHub Actions/Buildkiteとの連携機能を実装しています。

**業務上の目的・背景**：CI/CDパイプラインにおいて、Linux/Windows環境で共通して使用される機能を一元管理することで、コードの重複を排除し、保守性を向上させます。また、CI環境（GitHub Actions、Buildkite、ポストコミットCI）ごとに適切なログ出力形式を提供し、ビルド結果の可視化を支援します。

**バッチの実行タイミング**：monolithic-linux.shまたはmonolithic-windows.shから`source`コマンドで読み込まれ、CIパイプライン実行時に機能します。

**主要な処理内容**：
1. シェルオプション設定（set -ex, set -o pipefail）
2. 環境変数の初期化（MONOREPO_ROOT, BUILD_DIR）
3. sccache統計のリセット
4. at-exitハンドラの登録（アーティファクト収集、テストレポート生成）
5. start-group関数の定義（CI環境別ログ出力）
6. Python依存パッケージのインストール
7. LITタイミングファイルキャッシュのダウンロード

**前後の処理との関連**：本スクリプトはmonolithic-linux.sh/windows.shの冒頭で読み込まれ、ビルド終了時にat-exit関数が自動実行されます。premerge_advisorスクリプト群と連携してテスト結果を分析・報告します。

**影響範囲**：すべてのモノレポビルドバッチの初期化、ログ出力、アーティファクト収集に影響を与えます。

## バッチ種別

CI/CD共通ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 親スクリプト実行時（随時） |
| 実行時刻 | 親スクリプトからのsource実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | monolithic-linux.sh / monolithic-windows.shからの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Bashシェルが利用可能であること |
| Git環境 | gitコマンドが利用可能（MONOREPO_ROOT検出用） |
| sccache | sccacheコマンドが利用可能であること |
| Python環境 | pip、Pythonが利用可能であること |

### 実行可否判定

gitリポジトリ内で実行される必要がある（git rev-parse --show-toplevel）。MONOREPO_ROOTが環境変数で設定されている場合はそれを使用。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| MONOREPO_ROOT | 環境変数 | No | git rev-parse結果 | モノレポルートパス |
| BUILD_DIR | 環境変数 | No | ${MONOREPO_ROOT}/build | ビルドディレクトリ |
| GITHUB_ACTIONS | 環境変数 | No | なし | GitHub Actions環境フラグ |
| POSTCOMMIT_CI | 環境変数 | No | なし | ポストコミットCI環境フラグ |
| GITHUB_PR_NUMBER | 環境変数 | No | なし | PRナンバー |
| GITHUB_TOKEN | 環境変数 | No | なし | GitHub APIトークン |
| BUILDBOT_BUILDNUMBER | 環境変数 | No | なし | Buildbotビルド番号 |
| RUNNER_ARCH | 環境変数 | No | なし | ランナーアーキテクチャ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .ci/all_requirements.txt | テキスト | Python依存パッケージリスト |
| ${BUILD_DIR}/test-results.*.xml | XML | テスト結果ファイル |
| ${MONOREPO_ROOT}/ninja*.log | テキスト | Ninjaビルドログ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/ | ディレクトリ | アーティファクト格納先 |
| artifacts/sccache_stats.txt | テキスト | sccache統計情報 |
| $GITHUB_STEP_SUMMARY | テキスト | GitHub Actions ステップサマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sccache_stats.txt |
| 出力先 | artifacts/ |
| 文字コード | UTF-8 |
| 区切り文字 | テキスト形式 |

## 処理フロー

### 処理シーケンス

```
1. シェルオプション設定
   └─ set -ex, set -o pipefail
2. 環境変数初期化
   └─ MONOREPO_ROOT, BUILD_DIR設定
3. ビルドディレクトリクリア
   └─ rm -rf ${BUILD_DIR}
4. sccache統計リセット
   └─ sccache --zero-stats
5. at-exit関数定義・登録
   └─ trap at-exit EXIT
6. start-group関数定義
   └─ CI環境別ログ出力
7. Python依存パッケージインストール
   └─ pip install -q -r requirements.txt
8. LITタイミングキャッシュダウンロード（条件付き）
   └─ GitHub Actions + 非ARM64環境のみ
```

### フローチャート

```mermaid
flowchart TD
    A[source utils.sh] --> B[シェルオプション設定]
    B --> C[環境変数初期化]
    C --> D[ビルドディレクトリクリア]
    D --> E[sccache統計リセット]
    E --> F[at-exit関数登録]
    F --> G[start-group関数定義]
    G --> H[pip install実行]
    H --> I{GitHub Actions かつ 非ARM64?}
    I -->|Yes| J[LITタイミングキャッシュDL]
    I -->|No| K[初期化完了]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | 環境エラー | sccacheコマンドが見つからない | sccacheをインストール |
| 非0終了 | 環境エラー | gitコマンドが失敗 | gitリポジトリ内で実行 |
| 非0終了 | Pythonエラー | pip installが失敗 | ネットワーク接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

at-exit関数は終了コードを保持しながら実行されるため、エラー時でもアーティファクト収集は試行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の初期化 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

BUILD_DIRのクリアにより、古いビルドとの競合を回避。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | start-group呼び出し時 | グループ名（CI環境別形式） |
| 進捗ログ | 各コマンド実行時 | set -xによるコマンドエコー |
| 終了ログ | バッチ終了時（at-exit） | sccache統計、テストレポート |
| エラーログ | エラー発生時 | 標準エラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| sccacheヒット率 | 低下時 | 開発チーム |

## 備考

- PIP_BREAK_SYSTEM_PACKAGES=1を設定してシステムPythonへのインストールを許可
- shopt -s nullglobを使用してファイル不存在時のエラーを回避
- premerge_advisor_explain.pyでPRへのコメント投稿、premerge_advisor_upload.pyで結果アップロード
- ARM64ランナーはAWS上で動作し、GCSキャッシュにアクセスできないため、LITタイミングキャッシュのダウンロードをスキップ
