# バッチ設計書 30-clang-format-merge-driver.sh

## 概要

本ドキュメントは、clang-formatマージドライバーである `clang-format-merge-driver.sh` の設計仕様を記載したものです。このスクリプトは、Gitのカスタムマージドライバーとして機能し、libc++のコードベース全体がclang-formatで再フォーマットされた後でも、古いパッチをリベースできるようにします。

### 本バッチの処理概要

**業務上の目的・背景**：libc++プロジェクトでは、コードベース全体にclang-formatが適用されました。この大規模なフォーマット変更以前に作成されたパッチをリベースする際、フォーマットの差異によって大量のマージコンフリクトが発生します。本スクリプトは、マージ対象の各ファイルをマージ前にclang-formatで統一することで、フォーマットの差異を解消し、実質的なコード変更のみをマージできるようにします。

**バッチの実行タイミング**：Gitマージ/リベース時（自動）。.gitattributesでマージドライバーとして設定されている場合、Gitが自動的に呼び出します。

**主要な処理内容**：
1. 祖先バージョン（base）をclang-formatでフォーマット
2. 現在バージョン（current）をclang-formatでフォーマット
3. 他ブランチバージョン（other）をclang-formatでフォーマット
4. フォーマット済みの3ファイルでgit merge-fileを実行

**前後の処理との関連**：本スクリプトはGitのマージ処理の一部として呼び出されます。.gitconfigでマージドライバーとして登録する必要があります。マージ結果は通常のGitワークフローに戻ります。

**影響範囲**：マージ対象ファイルのみに影響。一時ファイルを作成・上書きしますが、Gitが管理する一時パスで操作されます。clang-formatの設定（.clang-format）に従ってフォーマットされます。

## バッチ種別

ユーティリティ / Gitマージドライバー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | Gitマージ/リベース時 |
| 実行時刻 | Git操作時 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Gitマージドライバー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| clang-format | clang-formatコマンドがPATH上に存在すること |
| Git | Gitリポジトリ内で実行されること |
| .gitconfig設定 | マージドライバーとして登録されていること |

### 実行可否判定

- Gitがマージドライバーとして呼び出す（.gitattributesの設定に基づく）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %O ($1) | ファイルパス | Yes | N/A | 祖先バージョン（base）の一時ファイルパス |
| %A ($2) | ファイルパス | Yes | N/A | 現在バージョン（current）の一時ファイルパス |
| %B ($3) | ファイルパス | Yes | N/A | 他ブランチバージョン（other）の一時ファイルパス |
| %P ($4) | 文字列 | Yes | N/A | リポジトリ内でのファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 一時ファイル | テキスト | Gitが作成するマージ対象の各バージョン |
| .clang-format | 設定ファイル | clang-formatの設定（--style=file） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $2 (current) | テキスト | マージ結果（git merge-fileの出力先） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| マージ結果 | $2（current）に上書き |
| 終了コード | git merge-fileの終了コード（0=成功、>0=コンフリクト数） |

## 処理フロー

### 処理シーケンス

```
1. 引数受け取り
   └─ base=$1, current=$2, other=$3, path=$4
2. baseをclang-format
   └─ clang-format --style=file --assume-filename="$path" < "$base" > "$base.tmp"
   └─ mv "$base.tmp" "$base"
3. currentをclang-format
   └─ clang-format --style=file --assume-filename="$path" < "$current" > "$current.tmp"
   └─ mv "$current.tmp" "$current"
4. otherをclang-format
   └─ clang-format --style=file --assume-filename="$path" < "$other" > "$other.tmp"
   └─ mv "$other.tmp" "$other"
5. git merge-file実行
   └─ git merge-file -Lcurrent -Lbase -Lother "$current" "$base" "$other"
```

### フローチャート

```mermaid
flowchart TD
    A[Git呼び出し] --> B[引数受け取り]
    B --> C[baseをclang-format]
    C --> D[currentをclang-format]
    D --> E[otherをclang-format]
    E --> F[git merge-file実行]
    F --> G{コンフリクト?}
    G -->|Yes| H[コンフリクトマーカー付きで終了]
    G -->|No| I[正常終了]
    H --> J[終了コード > 0]
    I --> K[終了コード = 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | clang-formatエラー | clang-formatコマンド失敗 | clang-formatのインストール確認 |
| 非ゼロ | マージコンフリクト | git merge-fileでコンフリクト発生 | 手動でコンフリクト解決 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- clang-formatが失敗した場合は、clang-formatのインストールと設定を確認
- マージコンフリクトが発生した場合は、通常のGitコンフリクト解決プロセスで対応

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一ファイル |
| コミットタイミング | Gitのコミット時 |
| ロールバック条件 | git merge --abort / git rebase --abort |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | マージ対象ファイル数 |
| 目標処理時間 | ファイルサイズに依存（通常は即時） |
| メモリ使用量上限 | clang-formatのメモリ使用量 |

## 排他制御

Gitが排他制御を管理。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | N/A | ログ出力なし（Gitの出力に依存） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（Git操作の一部） |

## 備考

### 設定方法

リポジトリのルートで以下のコマンドを実行:

```bash
git config merge.libcxx-reformat.name "Run clang-format when rebasing libc++ patches"
git config merge.libcxx-reformat.driver "libcxx/utils/clang-format-merge-driver.sh %O %A %B %P"
```

### 技術的詳細

- --style=file: リポジトリの.clang-formatを使用
- --assume-filename: パスからファイルタイプを推測させる
- git merge-file -L: コンフリクトマーカーのラベル設定
- 参照: https://github.com/nico/hack/blob/main/notes/auto_git_rebase_across_mechanical_changes.md
- ソースコード場所: `libcxx/utils/clang-format-merge-driver.sh`
