# バッチ設計書 31-zos_rename_dll_side_deck

## 概要

本ドキュメントは、z/OS環境におけるDLL(Dynamic Link Library)サイドデッキファイル内のDLL名を変更するバッチスクリプト`zos_rename_dll_side_deck.sh`の設計書です。

### 本バッチの処理概要

このバッチは、z/OSメインフレーム環境でビルドされたlibc++ライブラリのDLLサイドデッキファイル内に記述されているDLL名を、別の名前に置換する処理を行います。

**業務上の目的・背景**：z/OS環境でlibc++をビルドする際、生成されるDLLサイドデッキファイル（リンク時に使用されるシンボル情報を含むファイル）内のDLL名を変更する必要がある場合があります。例えば、バージョン管理やカスタムビルドにおいて、デフォルトのDLL名から特定の命名規則に従った名前に変更する必要があります。このスクリプトは、そのような名前変更を自動化し、手作業によるミスを防止します。

**バッチの実行タイミング**：libc++のz/OS向けビルド後、DLLサイドデッキファイルの生成後に手動または自動で実行されます。CIパイプラインの一部として、ビルドステップ完了後に実行されることもあります。

**主要な処理内容**：
1. コマンドライン引数の検証（サイドデッキファイル、旧DLL名、新DLL名の3つが必須）
2. 入力ファイルの存在確認
3. 新DLL名の文字数制限チェック（旧DLL名以下の文字数であること）
4. 必要に応じてパディング文字を計算
5. 一時ファイルを作成し、文字コードタグ（1047）を設定
6. sedコマンドでIMPORT文内のDLL名を置換
7. 一時ファイルで元ファイルを上書き

**前後の処理との関連**：このスクリプトは、libc++のz/OS向けビルドプロセスにおけるポストビルドステップとして位置づけられます。CMakeビルドシステムで生成されたDLLサイドデッキファイルを入力として受け取ります。

**影響範囲**：指定されたDLLサイドデッキファイルのみに影響します。ファイルは直接上書きされるため、バックアップを取得することが推奨されます。

## バッチ種別

データ変換 / ファイル編集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド後） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| z/OS環境 | z/OSシステム上で実行されること |
| サイドデッキファイル存在 | 対象のDLLサイドデッキファイルが存在すること |
| 書き込み権限 | 対象ファイルに書き込み権限があること |
| sed/chtagコマンド | z/OS向けのsedとchtagコマンドが利用可能であること |

### 実行可否判定

全ての引数が指定され、対象ファイルが存在し、新DLL名の文字数が旧DLL名以下であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| sidedeck | string | Yes | なし | DLLサイドデッキファイルのパス |
| old_dll_name | string | Yes | なし | 置換対象の旧DLL名 |
| new_dll_name | string | Yes | なし | 置換後の新DLL名（旧DLL名以下の文字数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| DLLサイドデッキファイル | テキストファイル（EBCDIC 1047） | z/OSリンカ用サイドデッキファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 入力ファイル（上書き） | テキストファイル（EBCDIC 1047） | DLL名が置換されたサイドデッキファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ |
| 出力先 | 入力と同じパス |
| 文字コード | EBCDIC 1047 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ 3つの引数がすべて指定されているか確認
2. ファイル存在確認
   └─ サイドデッキファイルの存在を確認
3. 文字数チェック
   └─ 新DLL名が旧DLL名以下の文字数か確認
4. パディング計算
   └─ 文字数の差分だけ空白パディングを生成
5. 一時ファイル準備
   └─ tmpファイルを作成し、文字コードタグを1047に設定
6. DLL名置換
   └─ sedでIMPORT行内のDLL名を置換
7. ファイル更新
   └─ 一時ファイルで元ファイルを上書き
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|不足| C[エラー終了]
    B -->|OK| D{ファイル存在確認}
    D -->|なし| C
    D -->|あり| E{文字数チェック}
    E -->|超過| C
    E -->|OK| F[パディング計算]
    F --> G[一時ファイル作成]
    G --> H[文字コードタグ設定]
    H --> I[sed置換実行]
    I --> J[ファイル上書き]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | 3つの引数が指定されていない | 正しい引数で再実行 |
| 1 | ファイル不在 | サイドデッキファイルが存在しない | ファイルパスを確認 |
| 1 | 文字数超過 | 新DLL名が旧DLL名より長い | 短いDLL名を指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（エラー時は即座に終了） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、エラーメッセージを確認し、原因を特定して対処します。set -eにより、コマンドエラー時は即座にスクリプトが終了します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 一時ファイルで元ファイルを上書き時 |
| ロールバック条件 | 中間でエラー発生時（元ファイルは変更されない） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限（sedによるストリーム処理） |

## 排他制御

同一ファイルに対する同時実行は想定していません。複数プロセスからの同時アクセスがある場合は、外部でロック機構を設ける必要があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | エラー発生時 | ERROR: メッセージ |
| ヘルプ | 引数不正時 | 使用方法 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |

## 備考

- z/OS固有のchtagコマンドを使用しているため、他のOSでは動作しません
- 文字コード1047はEBCDICの一種で、z/OSのデフォルト文字コードです
- IMPORT文のパターンマッチングにより、DLL名の置換を行います
