# バッチ設計書 32-remove_trailing_whitespace

## 概要

本ドキュメントは、ソースコードファイルから行末の不要な空白文字を削除するバッチスクリプト`remove_trailing_whitespace.sh`の設計書です。

### 本バッチの処理概要

このバッチは、指定されたファイル群から行末の空白文字（スペース、タブなど）をインプレースで削除します。コードスタイルの統一とリポジトリの整合性維持を目的としています。

**業務上の目的・背景**：LLVMプロジェクトでは、コーディング規約として行末に不要な空白を残さないことが求められています。エディタの設定によっては行末に空白が追加されることがあり、これがコミット時の差分ノイズとなります。このスクリプトは、コミット前やCI段階でのコード品質チェックとして、末尾空白を自動的に除去することで、コードレビューの効率化とリポジトリの一貫性を保証します。

**バッチの実行タイミング**：開発者がコミット前に手動で実行、またはpre-commitフックの一部として自動実行されます。CIパイプラインでのlintチェック段階でも使用される可能性があります。

**主要な処理内容**：
1. コマンドライン引数として指定されたファイルリストを受け取る
2. Perlスクリプトによる正規表現置換を使用
3. 各ファイルの行末空白を改行文字のみに置換
4. ファイルを直接（インプレースで）更新

**前後の処理との関連**：このスクリプトは独立したユーティリティとして使用されます。llvm/utils/lintディレクトリ配下にあり、他のlintツールと組み合わせて使用されることがあります。

**影響範囲**：指定されたすべてのファイルが直接変更されます。バイナリファイルやUTF-8以外のエンコーディングのファイルには使用しないでください。

## バッチ種別

コードフォーマット / Lintツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / pre-commitフック |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Perl | Perlインタプリタがインストールされていること |
| 書き込み権限 | 対象ファイルへの書き込み権限があること |
| テキストファイル | 対象がテキストファイルであること |

### 実行可否判定

1つ以上のファイルが引数として指定されていれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| files | string... | Yes | なし | 処理対象のファイルパス（複数指定可、ワイルドカード対応） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースファイル | テキストファイル | 任意のテキストファイル（.cpp, .h, .py など） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 入力ファイル（上書き） | テキストファイル | 行末空白が除去されたファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ |
| 出力先 | 入力と同じパス |
| 文字コード | 入力と同じ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数からファイルリストを取得
   └─ $* でシェル引数を展開
2. Perl処理実行
   └─ -pi オプションでインプレース編集
   └─ 正規表現 s/\s+$/\n/ で行末空白を改行に置換
3. 処理完了
   └─ 各ファイルが直接更新される
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ファイルリスト取得]
    B --> C{ファイルあり?}
    C -->|なし| D[処理なしで終了]
    C -->|あり| E[Perl処理実行]
    E --> F[各ファイルの行末空白を削除]
    F --> G[ファイル上書き保存]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | Perl実行エラー | Perlが見つからない、または実行エラー | Perlをインストール |
| 非0 | 権限エラー | ファイルへの書き込み権限がない | 権限を付与 |
| 非0 | ファイル不在 | 指定ファイルが存在しない | パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、Perlのエラーメッセージを確認し、対象ファイルの状態を確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各ファイル処理完了時 |
| ロールバック条件 | なし（部分的に処理が完了する可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限（Perlによるストリーム処理） |

## 排他制御

ファイルレベルでのロック機構はありません。複数プロセスからの同時実行は避けてください。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 標準出力・エラー出力なし（エラー時のみPerl出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 実行元に返却 |

## 備考

- Perlの-piオプションは「print in-place」の意味で、ファイルを直接編集します
- 正規表現`\s+$`は行末の1つ以上の空白文字にマッチします
- バイナリファイルへの適用は避けてください
- 使用例：`./remove_trailing_whitespace.sh *.cpp`
