# バッチ設計書 33-arcfilter

## 概要

本ドキュメントは、Phabricatorコードレビューシステムから生成されたコミットメッセージからメタデータタグを除去するバッチスクリプト`arcfilter.sh`の設計書です。

### 本バッチの処理概要

このバッチは、Phabricator（Arc）によって追加されたコミットメッセージ内のレビュー関連メタデータを削除し、クリーンなコミットメッセージでGitコミットを再作成します。

**業務上の目的・背景**：LLVMプロジェクトは以前Phabricatorをコードレビューシステムとして使用していました。Arcコマンドでパッチをコミットすると、「Reviewers:」「Subscribers:」「Summary:」などのメタデータがコミットメッセージに自動追加されます。これらのタグはコミットログを読みにくくし、GitHubなどへの移行後は不要となります。このスクリプトは、これらのメタデータを除去してコミット履歴をクリーンに保つために使用されます。

**バッチの実行タイミング**：Phabricatorからのパッチ適用後、コミットをプッシュする前に手動で実行されます。レビュー完了後のコミット整理フェーズで使用されます。

**主要な処理内容**：
1. HEADコミットのメッセージを取得（git log -1 --pretty=%B）
2. 「Summary:」タグを除去
3. 「Reviewers:」から「Reviewed By:」または「Differential Revision:」までの行を削除
4. 「Summary: 」プレフィックスを本文から除去
5. 処理後のメッセージでコミットをamend（--date=nowで現在時刻に更新）

**前後の処理との関連**：Phabricatorのarcコマンドでパッチを適用した後に実行されます。コミットメッセージ整形後、git pushでリモートにプッシュされます。

**影響範囲**：現在のHEADコミットのみに影響します。コミットメッセージとコミット日時が変更されます。

## バッチ種別

コミットメッセージ整形 / Gitユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | Gitリポジトリ内で実行されること |
| HEADコミット存在 | 少なくとも1つのコミットが存在すること |
| sed/awkコマンド | 標準的なUNIXツールが利用可能であること |

### 実行可否判定

Gitリポジトリ内でHEADコミットが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| HEADコミット | Git | 現在のHEADコミットのメッセージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Gitコミット（amend） | Git | メタデータ除去後のコミットメッセージでamendされたコミット |

### 出力ファイル仕様

ファイル出力はありません。Gitコミットオブジェクトが更新されます。

## 処理フロー

### 処理シーケンス

```
1. HEADコミットメッセージ取得
   └─ git log -1 --pretty=%B
2. Summary:タグ除去
   └─ sed 's/^Summary://'
3. Phabricatorメタデータ除去
   └─ awkでReviewers:〜Reviewed By:/Differential Revision:の範囲を削除
4. Summary:プレフィックス除去
   └─ sub(/^Summary: /,"") で本文冒頭のプレフィックスを削除
5. コミットamend
   └─ git commit --amend --date=now -F - で新メッセージを適用
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[HEADコミットメッセージ取得]
    B --> C[Summary:タグ除去]
    C --> D[Reviewers:〜範囲削除]
    D --> E[Summary:プレフィックス除去]
    E --> F[git commit --amend実行]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | Git非リポジトリ | Gitリポジトリ外で実行 | Gitリポジトリ内で実行 |
| 非0 | コミット不在 | HEADコミットが存在しない | 初回コミット後に実行 |
| 非0 | amendエラー | git commit --amendが失敗 | Gitの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、git logでコミット状態を確認し、必要に応じてgit reflogから復旧してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一コミット |
| コミットタイミング | git commit --amend実行時 |
| ロールバック条件 | パイプライン失敗時（amendは実行されない） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1コミット |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

Gitリポジトリのロック機構により、同時実行は防止されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Gitメッセージ | amend完了時 | 新しいコミットハッシュ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 実行元に返却 |

## 備考

- --date=nowオプションにより、コミット日時が現在時刻に更新されます
- 除去対象のPhabricatorタグ：Summary:, Reviewers:, Subscribers:, Reviewed By:, Differential Revision:
- このスクリプトはllvm/utils/gitディレクトリに配置されており、他のGitユーティリティと共に使用されます
- LLVMプロジェクトがGitHubに移行した後も、過去のPhabricatorパッチを適用する際に使用できます
