# バッチ設計書 34-start-emulator

## 概要

本ドキュメントは、libc++のAndroidテスト用にDockerコンテナ上でAndroidエミュレータを起動するバッチスクリプト`start-emulator.sh`の設計書です。

### 本バッチの処理概要

このバッチは、指定されたAndroidエミュレータイメージを使用してDockerコンテナを起動し、エミュレータが使用可能な状態になるまで待機します。libc++のAndroidプラットフォーム向けテストを実行するためのテスト環境を構築します。

**業務上の目的・背景**：libc++はAndroidプラットフォームでも使用されるため、Android向けのテストが必要です。実機を使用せずにCI環境でテストを実行するため、Androidエミュレータを使用します。このスクリプトは、Dockerを使用してエミュレータ環境を隔離し、再現性のあるテスト環境を提供します。KVMデバイスを使用したハードウェアアクセラレーションにより、エミュレータのパフォーマンスを向上させています。

**バッチの実行タイミング**：CI/CDパイプラインでAndroidテストを実行する前に自動実行されます。開発者がローカルでAndroidテストを実行する際にも手動で使用できます。

**主要な処理内容**：
1. エミュレータイメージ名の検証（形式：API-TYPE-ARCH）
2. 既存のエミュレータコンテナが存在する場合は停止・削除（stop-emulator.sh呼び出し）
3. Dockerコンテナをデタッチモードで起動（KVMデバイス、ボリュームマウント付き）
4. コンテナ内でエミュレータ起動完了を待機（emulator-wait-for-ready.sh）
5. 起動ログの出力とエラー確認
6. adb wait-for-deviceでデバイス接続確認

**前後の処理との関連**：このスクリプトはbuild-emulator-images.shで事前にビルドされたDockerイメージを使用します。テスト終了後はstop-emulator.shでコンテナを停止・削除します。

**影響範囲**：Dockerコンテナとして隔離されているため、ホストシステムへの影響は限定的です。/dev/kvmデバイスへのアクセスが必要です。

## バッチ種別

テスト環境構築 / エミュレータ起動

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI実行時） |
| 実行時刻 | CIトリガー時 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker | Dockerがインストールされ、動作していること |
| KVMデバイス | /dev/kvmが利用可能であること（Linux） |
| Dockerイメージ | 指定されたエミュレータイメージがビルド済みであること |
| android-platform-tools | adbなどのツールがボリュームマウントされていること |

### 実行可否判定

エミュレータイメージ名が有効な形式で、対応するDockerイメージが存在し、Dockerが動作していれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| EMU_IMG | string | Yes | なし | エミュレータイメージ名（例：21-def-x86, 33-goog-x86_64） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Dockerイメージ | Docker | android-emulator-{EMU_IMG}というイメージ |
| emulator-functions.sh | シェルスクリプト | イメージ名解析用関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Dockerコンテナ | Docker | libcxx-ci-android-emulatorという名前のコンテナ |
| 標準出力 | テキスト | 起動ログ、エラーメッセージ |

### 出力ファイル仕様

ファイル出力はありません。Dockerコンテナが起動されます。

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ validate_emu_img関数でイメージ名を検証
2. 既存コンテナ停止
   └─ stop-emulator.sh を呼び出し
3. Dockerコンテナ起動
   └─ docker run --detach --device /dev/kvm
   └─ パーティションサイズ8192MB設定
   └─ android-platform-toolsボリュームマウント
4. エミュレータ起動待機
   └─ docker exec emulator-wait-for-ready.sh
5. 起動ログ出力
   └─ docker logs libcxx-ci-android-emulator
6. 環境設定
   └─ setup-env-for-emulator.sh を source
7. デバイス接続確認
   └─ adb wait-for-device
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{イメージ名検証}
    B -->|無効| C[エラー終了]
    B -->|有効| D[既存コンテナ停止]
    D --> E[Dockerコンテナ起動]
    E --> F[エミュレータ起動待機]
    F --> G{起動成功?}
    G -->|失敗| H[ログ出力後エラー終了]
    G -->|成功| I[起動ログ出力]
    I --> J[環境設定読み込み]
    J --> K[adbデバイス待機]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | イメージ名無効 | 形式が不正 | 正しい形式で指定（API-TYPE-ARCH） |
| 1 | Dockerイメージ不在 | イメージがビルドされていない | build-emulator-images.shを実行 |
| 1 | Docker未動作 | docker infoが失敗 | Dockerデーモンを起動 |
| 非0 | エミュレータ起動失敗 | タイムアウトまたはエラー | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベルでは） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、docker logsでコンテナログを確認し、原因を特定します。KVMデバイスのアクセス権限も確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Dockerコンテナ操作 |
| コミットタイミング | 各Dockerコマンド実行時 |
| ロールバック条件 | エラー時はコンテナが起動途中で停止（自動クリーンアップなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1コンテナ |
| 目標処理時間 | 30秒〜2分（エミュレータ起動まで） |
| メモリ使用量上限 | Dockerコンテナ依存（数GB） |

## 排他制御

コンテナ名がlibcxx-ci-android-emulatorで固定されているため、同一ホストでの同時実行はできません。スクリプト開始時に既存コンテナを停止・削除することで排他制御を実現しています。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 起動ログ | エミュレータ起動後 | "Emulator container initial logs:" + docker logs |
| エラーログ | 起動失敗時 | エラーメッセージ + docker logs |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |
| 起動時間 | 300秒超過 | CIタイムアウト |

## 備考

- イメージ名の形式：{API}-{TYPE}-{ARCH}
  - API: Androidバージョン（例：21, 33）
  - TYPE: def（default）, goog（google_apis）, play（google_apis_playstore）
  - ARCH: arm, arm64, x86, x86_64
- 使用例：`./start-emulator.sh 33-goog-x86_64`
- EMU_PARTITION_SIZE=8192で8GBのパーティションサイズを設定
- setup-env-for-emulator.shで環境変数を設定し、ホストからadbでアクセス可能にする
