# バッチ設計書 35-stop-emulator

## 概要

本ドキュメントは、libc++のAndroidテスト用に起動されたDockerコンテナ上のAndroidエミュレータを停止・削除するバッチスクリプト`stop-emulator.sh`の設計書です。

### 本バッチの処理概要

このバッチは、start-emulator.shで起動されたAndroidエミュレータのDockerコンテナを停止し、コンテナを削除してリソースをクリーンアップします。

**業務上の目的・背景**：CI/CDパイプラインでAndroidテストを実行した後、使用済みのエミュレータコンテナを適切に停止・削除する必要があります。リソースの解放と次回テスト実行時のクリーンな状態を保証するため、このスクリプトが使用されます。また、start-emulator.shから呼び出され、新しいエミュレータ起動前に既存コンテナを削除する役割も担います。

**バッチの実行タイミング**：Androidテスト完了後に自動実行されます。また、start-emulator.shから新規エミュレータ起動前に呼び出されます。開発者がローカルでテストを終了する際にも手動で使用できます。

**主要な処理内容**：
1. libcxx-ci-android-emulatorコンテナの存在確認（docker container inspect）
2. コンテナが存在する場合、docker stopでコンテナを停止
3. docker logsで最終ログを出力（デバッグ・監視用）
4. docker rmでコンテナを削除

**前後の処理との関連**：start-emulator.shで起動されたコンテナを停止します。テスト実行完了後、またはstart-emulator.shの冒頭で呼び出されます。

**影響範囲**：libcxx-ci-android-emulatorという名前のDockerコンテナのみに影響します。他のコンテナやシステムには影響しません。

## バッチ種別

リソースクリーンアップ / エミュレータ停止

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（テスト終了後） |
| 実行時刻 | テスト完了時 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/手動/他スクリプトから呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker | Dockerがインストールされ、動作していること |
| コンテナ存在（オプション） | コンテナが存在しない場合は何もせず正常終了 |

### 実行可否判定

Dockerが動作していれば実行可能。コンテナが存在しない場合でもエラーにならず正常終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Dockerコンテナ | Docker | libcxx-ci-android-emulatorコンテナ |
| emulator-functions.sh | シェルスクリプト | ヘルパー関数（source） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 停止/削除ログ、最終コンテナログ |

### 出力ファイル仕様

ファイル出力はありません。Dockerコンテナが停止・削除されます。

## 処理フロー

### 処理シーケンス

```
1. コンテナ存在確認
   └─ docker container inspect libcxx-ci-android-emulator
2. 存在する場合のみ以下を実行
   2a. コンテナ停止
       └─ docker stop libcxx-ci-android-emulator
   2b. 最終ログ出力
       └─ docker logs libcxx-ci-android-emulator
   2c. コンテナ削除
       └─ docker rm libcxx-ci-android-emulator
3. 存在しない場合
   └─ 何もせず正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{コンテナ存在?}
    B -->|存在しない| C[処理なしで終了]
    B -->|存在する| D[コンテナ停止メッセージ出力]
    D --> E[docker stop実行]
    E --> F[最終ログ出力]
    F --> G[コンテナ削除メッセージ出力]
    G --> H[docker rm実行]
    H --> I[バッチ終了]
    C --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | Docker未動作 | docker inspectが失敗 | Dockerデーモンを起動 |
| 非0 | stop失敗 | コンテナ停止に失敗 | docker psで状態確認 |
| 非0 | rm失敗 | コンテナ削除に失敗 | docker ps -aで確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、docker ps -aでコンテナ状態を確認し、手動でdocker stop/docker rmを実行してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Dockerコンテナ操作 |
| コミットタイミング | 各Dockerコマンド実行時 |
| ロールバック条件 | なし（各操作は独立） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1コンテナ |
| 目標処理時間 | 5〜10秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

コンテナ名が固定のため、複数プロセスからの同時実行でも問題ありません（冪等性あり）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 停止メッセージ | コンテナ停止前 | "Stopping existing emulator container..." |
| 最終ログ | コンテナ停止後 | "Emulator container final logs:" + docker logs |
| 削除メッセージ | コンテナ削除前 | "Removing existing emulator container..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |

## 備考

- コンテナが存在しない場合は何もせず正常終了（冪等性）
- set -eにより、Dockerコマンドエラー時はスクリプトが即座に終了
- 最終ログ出力はデバッグ目的で、エミュレータの動作状況を確認するために使用
- start-emulator.shから呼び出されることで、クリーンなエミュレータ起動を保証
