# バッチ設計書 36-build-emulator-images

## 概要

本ドキュメントは、libc++のAndroidテスト用Androidエミュレータを含むDockerイメージをビルドするバッチスクリプト`build-emulator-images.sh`の設計書です。

### 本バッチの処理概要

このバッチは、複数のAndroid APIレベルとアーキテクチャの組み合わせに対応したDockerイメージをビルドします。これらのイメージはstart-emulator.shで使用され、libc++のAndroidテスト環境を提供します。

**業務上の目的・背景**：libc++のAndroidプラットフォームでのテストを実行するには、Androidエミュレータが必要です。CIサーバー上で再現性のあるテスト環境を構築するため、Dockerイメージとしてエミュレータ環境をパッケージ化します。複数のAndroid APIレベル（21、33など）とイメージタイプ（default、google_apis）をサポートすることで、さまざまな環境でのテストが可能になります。

**バッチの実行タイミング**：CIインフラのセットアップ時、またはエミュレータイメージの更新が必要な時に実行されます。通常のテスト実行前には既にビルド済みのイメージを使用します。

**主要な処理内容**：
1. スクリプトディレクトリに移動
2. 21-def-x86イメージのビルド（Android API 21、default、x86）
3. 33-goog-x86_64イメージのビルド（Android API 33、google_apis、x86_64）
4. docker build コマンドでDockerfile.emulatorを使用してビルド
5. --build-argでAPI、TYPE、ABIを指定

**前後の処理との関連**：ビルドされたイメージはstart-emulator.shで使用されます。Dockerfile.emulatorが同じディレクトリに必要です。

**影響範囲**：Dockerイメージレジストリにイメージが作成されます。ローカルのDockerキャッシュを消費します。

## バッチ種別

イメージビルド / テスト環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（インフラ更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / インフラ構築スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker | Dockerがインストールされ、動作していること |
| Dockerfile.emulator | 同じディレクトリにDockerfile.emulatorが存在すること |
| emulator-functions.sh | ヘルパー関数ファイルが存在すること |
| ネットワーク接続 | Dockerイメージ取得とSDKダウンロードのため |

### 実行可否判定

Dockerが動作しており、必要なファイルが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数不要（ビルド対象はスクリプト内にハードコード） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Dockerfile.emulator | Dockerfile | エミュレータイメージのビルド定義 |
| emulator-functions.sh | シェルスクリプト | イメージ名解析用ヘルパー関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Dockerイメージ | Docker | android-emulator-21-def-x86 |
| Dockerイメージ | Docker | android-emulator-33-goog-x86_64 |

### 出力ファイル仕様

ファイル出力はありません。Dockerイメージがローカルレジストリに作成されます。

## 処理フロー

### 処理シーケンス

```
1. スクリプトディレクトリに移動
   └─ cd "${THIS_DIR}"
2. 21-def-x86イメージビルド
   └─ build_image 21-def-x86
   └─ API=21, TYPE=default, ABI=x86
3. 33-goog-x86_64イメージビルド
   └─ build_image 33-goog-x86_64
   └─ API=33, TYPE=google_apis, ABI=x86_64
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトディレクトリに移動]
    B --> C[21-def-x86イメージビルド]
    C --> D{ビルド成功?}
    D -->|失敗| E[エラー終了]
    D -->|成功| F[33-goog-x86_64イメージビルド]
    F --> G{ビルド成功?}
    G -->|失敗| E
    G -->|成功| H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | イメージ名無効 | EMU_IMGの形式が不正 | 正しい形式で指定 |
| 非0 | Dockerビルド失敗 | docker buildエラー | Dockerファイルを確認 |
| 非0 | ネットワークエラー | ベースイメージ取得失敗 | ネットワーク接続確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

docker build のエラーログを確認し、Dockerfile.emulatorの内容やネットワーク状態を確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各イメージビルド |
| コミットタイミング | docker build完了時 |
| ロールバック条件 | ビルド失敗時（イメージは作成されない） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2イメージ |
| 目標処理時間 | 10〜30分（ネットワーク状況依存） |
| メモリ使用量上限 | 数GB（Dockerビルド依存） |

## 排他制御

複数プロセスからの同時実行は想定していません。Dockerの内部ロック機構により、イメージビルドは適切に処理されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | ビルド中 | docker buildの出力 |
| エラーログ | エラー発生時 | Dockerエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI通知 |
| ビルド時間 | 60分超過 | CI通知 |

## 備考

- ビルド対象イメージはスクリプト内にハードコードされています
  - 21-def-x86: Android API 21、default、x86アーキテクチャ
  - 33-goog-x86_64: Android API 33、google_apis、x86_64アーキテクチャ
- emulator-functions.shのヘルパー関数を使用してイメージ名を解析
  - docker_image_of_emu_img: イメージ名からDockerイメージ名を生成
  - api_of_emu_img: イメージ名からAPIレベルを抽出
  - type_of_emu_img: イメージ名からタイプを抽出
  - abi_of_arch: アーキテクチャからABIを取得
- 新しいイメージを追加する場合は、build_image関数の呼び出しを追加
