# バッチ設計書 37-emulator-wait-for-ready

## 概要

本ドキュメントは、Androidエミュレータが完全に起動するまで待機するバッチスクリプト`emulator-wait-for-ready.sh`の設計書です。

### 本バッチの処理概要

このバッチは、Dockerコンテナ内で起動中のAndroidエミュレータが利用可能な状態になるまでポーリングして待機します。ADB（Android Debug Bridge）サーバーへの接続とデバイスの準備完了を確認します。

**業務上の目的・背景**：Androidエミュレータの起動には時間がかかり、起動直後はADB接続が確立されていません。libc++のテストを実行する前に、エミュレータが完全に起動し、ADB経由でコマンドを実行できる状態になっていることを確認する必要があります。このスクリプトは、start-emulator.shから呼び出され、エミュレータの起動完了を保証します。

**バッチの実行タイミング**：Dockerコンテナ内でエミュレータ起動後、start-emulator.shによってdocker execで実行されます。

**主要な処理内容**：
1. ADBサーバーソケットの設定（127.0.0.1:5037）
2. タイムアウト値の設定（デフォルト300秒）
3. ncコマンドでポート5037への接続確認ループ
4. adb wait-for-deviceでデバイス準備完了待機
5. 0.5秒間隔でリトライ

**前後の処理との関連**：start-emulator.shからdocker execで呼び出されます。このスクリプトが成功すると、ホスト側でadb wait-for-deviceが実行されます。

**影響範囲**：Dockerコンテナ内で実行され、外部への影響はありません。エミュレータの起動状態を確認するのみです。

## バッチ種別

待機処理 / 起動完了確認

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | start-emulator.sh実行時 |
| 実行時刻 | エミュレータ起動後 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | docker exec |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Dockerコンテナ内 | エミュレータDockerコンテナ内で実行されること |
| エミュレータ起動中 | Androidエミュレータプロセスが起動していること |
| nc/adbコマンド | netcat(nc)とadbコマンドが利用可能であること |

### 実行可否判定

Dockerコンテナ内でエミュレータが起動中であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TIMEOUT | integer | No | 300 | タイムアウト秒数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ADBサーバー | TCP | localhost:5037 |
| Androidデバイス | エミュレータ | 起動中のエミュレータインスタンス |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 終了コード | integer | 0: 成功、非0: タイムアウトまたはエラー |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. ADBサーバーソケット設定
   └─ ADB_SERVER_SOCKET=tcp:127.0.0.1:5037
2. タイムアウト値取得
   └─ 引数から取得、またはデフォルト300秒
3. ポーリングループ開始
   └─ timeout ${TIMEOUT} bash -c '...'
4. 接続確認
   └─ nc -z localhost 5037 でポート確認
   └─ adb wait-for-device でデバイス確認
5. 失敗時リトライ
   └─ sleep 0.5 で待機後再試行
6. 成功時終了
   └─ ループから抜けて正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数設定]
    B --> C[タイムアウト設定]
    C --> D[ポーリングループ開始]
    D --> E{ポート5037接続可能?}
    E -->|No| F{タイムアウト?}
    F -->|No| G[0.5秒待機]
    G --> E
    F -->|Yes| H[タイムアウトエラー終了]
    E -->|Yes| I[adb wait-for-device]
    I --> J{デバイス準備完了?}
    J -->|No| F
    J -->|Yes| K[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 124 | タイムアウト | 指定時間内にエミュレータが起動しない | タイムアウト値を増やす、エミュレータログ確認 |
| 非0 | 接続エラー | ADBサーバーに接続できない | エミュレータプロセスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | タイムアウトまで無制限 |
| リトライ間隔 | 0.5秒 |
| リトライ対象エラー | ポート接続失敗、デバイス未準備 |

### 障害時対応

タイムアウト発生時は、docker logsでエミュレータログを確認し、起動失敗の原因を調査してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1エミュレータ |
| 目標処理時間 | 5〜60秒（エミュレータ依存） |
| メモリ使用量上限 | 最小限 |

## 排他制御

単一コンテナ内で実行されるため、排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コマンド実行ログ | 各コマンド実行時 | set -exによる実行トレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | start-emulator.shに伝播 |
| 待機時間 | 300秒超過 | タイムアウトエラー |

## 備考

- ADB_SERVER_SOCKET環境変数で127.0.0.1を明示的に指定し、adbクライアントがサーバーをフォークしないようにしています
- ncコマンドでまずポート5037への接続を確認し、その後adbコマンドを使用します
- コメントにあるように、dev.bootcompleteプロパティの確認は行っていませんが、libc++テストには問題ないとされています
- 21-def-x86では約5秒、33-goog-x86_64では約15秒の追加待機が発生する可能性がありますが、現在は省略されています
