# バッチ設計書 38-define_enum

## 概要

本ドキュメントは、SPIR-V仕様からenum属性定義を自動生成するバッチスクリプト`define_enum.sh`の設計書です。

### 本バッチの処理概要

このバッチは、SPIR-V（Standard Portable Intermediate Representation for Vulkan）の公式仕様からenum（列挙型）属性の定義を取得し、MLIR（Multi-Level Intermediate Representation）のSPIR-V方言で使用するTableGen定義を自動生成します。

**業務上の目的・背景**：MLIRはLLVMプロジェクトの一部として、複数のIR（中間表現）を統一的に扱うためのフレームワークです。SPIR-V方言はGPUプログラミング向けのSPIR-V表現をMLIRで扱うために使用されます。SPIR-V仕様は頻繁に更新され、多数のenum定義が存在するため、手動での更新は困難です。このスクリプトは、公式のSPIR-V仕様（spirv.core.grammar.json）から自動的にenum定義を生成し、保守作業を効率化します。

**バッチの実行タイミング**：SPIR-V仕様の更新時、または新しいenumの追加が必要な時に手動で実行されます。

**主要な処理内容**：
1. 引数から新規enum名を取得（オプション）
2. gen_spirv_dialect.pyスクリプトを呼び出し
3. SPIRVBase.tdファイルを更新（またはenum定義を生成）
4. 引数がない場合は既存のenum定義を更新

**前後の処理との関連**：define_inst.shやdefine_opcodes.shと組み合わせて使用され、SPIR-V方言の完全な定義を生成します。生成されたTableGen定義はMLIRビルドプロセスで使用されます。

**影響範囲**：mlir/include/mlir/Dialect/SPIRV/IR/SPIRVBase.tdファイルに影響します。

## バッチ種別

コード生成 / 自動生成ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SPIR-V仕様更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python3 | Python3がインストールされていること |
| gen_spirv_dialect.py | 同じディレクトリにスクリプトが存在すること |
| ネットワーク接続 | SPIR-V仕様のダウンロードのため（オプション） |
| readlink | readlinkコマンドが利用可能であること |

### 実行可否判定

Python3と必要なファイルが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| enum-class-name | string | No | なし | 新規追加するenum名（省略時は既存定義を更新） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| spirv.core.grammar.json | JSON | SPIR-V公式仕様（operand_kinds内のenum定義） |
| SPIRVBase.td | TableGen | 既存のMLIR SPIR-V定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| SPIRVBase.td | TableGen | 更新されたenum属性定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SPIRVBase.td |
| 出力先 | mlir/include/mlir/Dialect/SPIRV/IR/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数取得
   └─ new_enum=$1 で新規enum名を取得
2. スクリプトパス解決
   └─ readlinkで絶対パスを取得
   └─ dirnameでディレクトリを取得
3. Python3スクリプト呼び出し
   └─ gen_spirv_dialect.py を実行
   └─ --base-td-path でSPIRVBase.tdを指定
   └─ --new-enum で新規enum名を渡す
4. TableGen定義更新
   └─ SPIRVBase.tdが更新される
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数取得]
    B --> C[スクリプトパス解決]
    C --> D[gen_spirv_dialect.py呼び出し]
    D --> E{新規enum指定?}
    E -->|あり| F[新規enum定義生成]
    E -->|なし| G[既存定義更新]
    F --> H[SPIRVBase.td更新]
    G --> H
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | Python実行エラー | Python3が見つからない | Python3をインストール |
| 非0 | ファイル不在 | SPIRVBase.tdが見つからない | パスを確認 |
| 非0 | ネットワークエラー | SPIR-V仕様取得失敗 | ネットワーク接続確認 |
| 非0 | 無効なenum名 | 指定したenumが仕様に存在しない | enum名を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、gen_spirv_dialect.pyのエラー出力を確認し、入力パラメータやファイルパスを確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | Pythonスクリプト終了時 |
| ロールバック条件 | なし（ファイル直接更新） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜数件のenum |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一ファイルへの同時書き込みは想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Python出力 | 処理中 | gen_spirv_dialect.pyの出力 |
| エラーログ | エラー発生時 | Pythonエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 実行元に返却 |

## 備考

- SPIR-V仕様のoperand_kinds辞書に定義されているenum名を指定できます
- 引数を省略すると、既存のenum定義が最新仕様に基づいて更新されます
- 使用例：`./define_enum.sh ImageOperands`
- 生成されたTableGen定義は、MLIRビルド時にC++コードに変換されます
- 関連スクリプト：define_inst.sh, define_opcodes.sh
