# バッチ設計書 39-define_inst

## 概要

本ドキュメントは、SPIR-V仕様から命令（オペレーション）定義を自動生成するバッチスクリプト`define_inst.sh`の設計書です。

### 本バッチの処理概要

このバッチは、SPIR-V（Standard Portable Intermediate Representation for Vulkan）の公式仕様から命令定義を取得し、MLIR（Multi-Level Intermediate Representation）のSPIR-V方言で使用するTableGen定義を自動生成します。さらに、define_opcodes.shを呼び出してオペコードのマッピングも更新します。

**業務上の目的・背景**：SPIR-Vには数百の命令が定義されており、それぞれの命令を手動でMLIR TableGen形式に変換するのは非常に手間がかかります。このスクリプトは、命令のカテゴリ（算術演算、論理演算、制御フローなど）に基づいて適切なベースクラスを継承したTableGen定義を自動生成します。これにより、SPIR-V仕様への追従が容易になり、開発効率が向上します。

**バッチの実行タイミング**：新しいSPIR-V命令をMLIRにサポート追加する時、またはSPIR-V仕様の更新時に手動で実行されます。

**主要な処理内容**：
1. ファイル名とベースクラスを引数から取得
2. ベースクラスの妥当性チェック（許可されたクラスのみ）
3. gen_spirv_dialect.pyスクリプトを呼び出し
4. 指定されたTableGenファイルを更新
5. define_opcodes.shを呼び出してオペコード定義を更新

**前後の処理との関連**：このスクリプトは内部でdefine_opcodes.shを呼び出します。define_enum.shと組み合わせて、SPIR-V方言の完全な定義を生成できます。

**影響範囲**：指定されたmlir/include/mlir/Dialect/SPIRV/IR/配下のTableGenファイルとSPIRVBase.tdに影響します。

## バッチ種別

コード生成 / 自動生成ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SPIR-V仕様更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python3 | Python3がインストールされていること |
| gen_spirv_dialect.py | 同じディレクトリにスクリプトが存在すること |
| define_opcodes.sh | 同じディレクトリにスクリプトが存在すること |
| readlink | readlinkコマンドが利用可能であること |

### 実行可否判定

必須引数（ファイル名、ベースクラス）が指定され、ベースクラスが許可リストに含まれていれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| filename | string | Yes | なし | 更新対象のTableGenファイル名（例：SPIRVArithmeticOps.td） |
| baseclass | string | Yes | なし | 命令のベースクラス（下記参照） |
| opname | string... | No | なし | 追加する命令名（複数指定可、省略時は既存を更新） |

### 許可されたベースクラス

- Op
- ArithmeticBinaryOp
- ArithmeticUnaryOp
- LogicalBinaryOp
- LogicalUnaryOp
- CastOp
- ControlFlowOp
- StructureOp
- AtomicUpdateOp
- AtomicUpdateWithValueOp
- KhrVendorOp
- ExtVendorOp
- IntelVendorOp
- NvVendorOp

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SPIR-V仕様 | JSON | spirv.core.grammar.jsonのinstructionsリスト |
| 対象TableGenファイル | TableGen | 更新対象のOps定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 指定TableGenファイル | TableGen | 更新された命令定義 |
| SPIRVBase.td | TableGen | 更新されたオペコード定義（define_opcodes.sh経由） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 引数で指定されたファイル |
| 出力先 | mlir/include/mlir/Dialect/SPIRV/IR/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数取得
   └─ file_name=$1, baseclass=$2
2. ベースクラス検証
   └─ case文で許可リストをチェック
   └─ 不正な場合はUsage表示してエラー終了
3. 残りの引数シフト
   └─ shift; shift で opname 引数を取得
4. スクリプトパス解決
   └─ readlinkとdirnameで絶対パスを取得
5. gen_spirv_dialect.py呼び出し
   └─ --op-td-path で対象ファイルを指定
   └─ --inst-category でベースクラスを指定
   └─ --new-inst で命令名を渡す
6. define_opcodes.sh呼び出し
   └─ 追加した命令のオペコードを登録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数取得]
    B --> C{ベースクラス有効?}
    C -->|無効| D[Usage表示してエラー終了]
    C -->|有効| E[引数シフト]
    E --> F[gen_spirv_dialect.py呼び出し]
    F --> G[TableGenファイル更新]
    G --> H[define_opcodes.sh呼び出し]
    H --> I[オペコード定義更新]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不正 | ベースクラスが許可リストにない | 許可されたベースクラスを指定 |
| 非0 | Python実行エラー | Python3が見つからない | Python3をインストール |
| 非0 | ファイル不在 | 対象ファイルが見つからない | パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、出力されるエラーメッセージとUsage情報を確認し、正しい引数で再実行してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各Pythonスクリプト終了時 |
| ロールバック条件 | なし（ファイル直接更新） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜数件の命令 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一ファイルへの同時書き込みは想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Python出力 | 処理中 | gen_spirv_dialect.pyの出力 |
| エラーログ | エラー発生時 | Usage情報、Pythonエラー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 実行元に返却 |

## 備考

- 使用例：
  - `./define_inst.sh SPIRVArithmeticOps.td ArithmeticBinaryOp OpIAdd`
  - `./define_inst.sh SPIRVLogicalOps.td LogicalOp OpFOrdEqual`
- 引数なしの場合（filename, baseclassのみ）は既存の命令定義を更新
- ベースクラスは命令のカテゴリを表し、適切なクラスを選択することで正しい定義が生成される
- このスクリプトはdefine_opcodes.shを内部的に呼び出すため、オペコードも自動更新される
- 関連スクリプト：define_enum.sh, define_opcodes.sh
