# バッチ設計書 4-buildkite-pipeline-trigger.sh

## 概要

本ドキュメントは、LLVMプロジェクトのlibc++ Buildkiteパイプライントリガースクリプト「buildkite-pipeline-trigger.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMモノレポへのプルリクエストがlibc++/libcxxabi/libunwind関連のディレクトリに変更を加えているかを検出し、必要に応じてlibc++ BuildkiteパイプラインをトリガーするCI/CDスクリプトです。すべてのPRに対してBuildkiteが通知を受けるため、関連するPRのみでパイプラインを実行するフィルタリングの役割を果たします。

**業務上の目的・背景**：LLVMモノレポには多数のサブプロジェクトが含まれており、すべてのPRに対してすべてのテストを実行することは非効率です。本バッチは、libc++関連の変更のみを検出してBuildkiteパイプラインを選択的にトリガーすることで、CI/CDリソースの効率的な利用を実現します。

**バッチの実行タイミング**：Buildkiteがプルリクエストを検知した際に自動実行されます。

**主要な処理内容**：
1. originリポジトリをfetchして最新状態を取得
2. PRベースブランチとHEADの差分から変更ファイルリストを取得
3. 変更されたディレクトリを抽出
4. libc++関連ディレクトリ（libcxx, libcxxabi, libunwind, runtimes, cmake）への変更を検出
5. 該当する場合、buildkite-agent pipeline uploadを実行

**前後の処理との関連**：本スクリプトはBuildkiteから直接呼び出され、条件を満たす場合にbuildkite-pipeline.ymlをアップロードして後続のパイプラインを開始します。

**影響範囲**：libc++ Buildkiteパイプラインの実行可否に影響を与えます。関係のないPRではパイプラインを実行しないことで、CIリソースを節約します。

## バッチ種別

CI/CDパイプライントリガー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（プルリクエスト作成・更新時） |
| 実行時刻 | Buildkiteイベントトリガー時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Buildkite PRイベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Buildkite環境 | Buildkiteエージェントが動作していること |
| Git環境 | gitコマンドが利用可能であること |
| 環境変数 | BUILDKITE_PULL_REQUEST_BASE_BRANCHが設定されていること |

### 実行可否判定

プルリクエストのベースブランチ情報がBuildkiteから提供される必要がある。MODIFIED_FILESが環境変数で提供される場合はそれを使用。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BUILDKITE_PULL_REQUEST_BASE_BRANCH | 環境変数 | Yes | 空文字 | PRのベースブランチ名 |
| MODIFIED_FILES | 環境変数 | No | git diff結果 | 変更ファイルリスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Git リポジトリ | Git | origin/ベースブランチとHEADの差分 |
| libcxx/utils/ci/buildkite-pipeline.yml | YAML | アップロードするパイプライン定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Buildkite | パイプライン | 条件を満たす場合、パイプラインをアップロード |
| 標準エラー出力 | テキスト | 変更ファイル・ディレクトリのログ |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境変数初期化
   └─ BUILDKITE_PULL_REQUEST_BASE_BRANCHのデフォルト値設定
2. originリポジトリfetch
   └─ git fetch origin
3. 変更ファイルリスト取得
   └─ git diff --name-only origin/${BASE_BRANCH}...HEAD
4. ログ出力
   └─ 変更ファイル・ディレクトリを標準エラーに出力
5. ディレクトリ抽出
   └─ 最上位ディレクトリを抽出・ソート・重複排除
6. パターンマッチング
   └─ libcxx|libcxxabi|libunwind|runtimes|cmakeへの変更を検出
7. パイプライントリガー
   └─ マッチした場合、buildkite-agent pipeline uploadを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[git fetch origin]
    B --> C[変更ファイルリスト取得]
    C --> D[変更ディレクトリ抽出]
    D --> E{libc++関連の変更?}
    E -->|Yes| F[buildkite-agent pipeline upload]
    E -->|No| G[No Buildkite jobs to trigger 出力]
    F --> H[バッチ終了]
    G --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | Gitエラー | git fetchが失敗 | ネットワーク接続、認証を確認 |
| 非0終了 | Buildkiteエラー | buildkite-agentコマンドが見つからない | Buildkite環境を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. Buildkiteのビルドログを確認
2. git fetch失敗時はネットワーク・認証設定を確認
3. パイプラインファイルのパスが正しいか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の判定処理 |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特になし。各PRに対して独立して実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 変更検出時 | "Files modified:" + ファイルリスト |
| 情報ログ | 変更検出時 | "Directories modified:" + ディレクトリリスト |
| 情報ログ | パイプライン未実行時 | "No Buildkite jobs to trigger" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行時間 | 異常な長時間 | Buildkite |
| 失敗率 | 連続失敗 | 開発チーム |

## 備考

- 検出対象ディレクトリ：libcxx, libcxxabi, libunwind, runtimes, cmake
- パイプライン定義ファイル：libcxx/utils/ci/buildkite-pipeline.yml
- 標準エラー出力（>&2）を使用して診断情報を出力
- grepの-qオプションで静かにパターンマッチを実行
