# バッチ設計書 40-define_opcodes

## 概要

本ドキュメントは、SPIR-V仕様から命令名とオペコードのマッピングを自動生成するバッチスクリプト`define_opcodes.sh`の設計書です。

### 本バッチの処理概要

このバッチは、SPIR-V（Standard Portable Intermediate Representation for Vulkan）の公式仕様から命令名（OpName）とオペコード（数値識別子）のマッピングを取得し、MLIR（Multi-Level Intermediate Representation）のSPIR-V方言で使用するTableGen定義を自動生成します。

**業務上の目的・背景**：SPIR-Vの各命令は一意のオペコード（数値）で識別されます。MLIRでSPIR-V命令を処理する際、命令名とオペコードの対応関係が必要です。SPIR-V仕様のinstructionsリストには全命令の定義が含まれており、このスクリプトはその情報を使って自動的にオペコードマッピングを生成します。これにより、新しい命令がSPIR-V仕様に追加された際も、簡単にMLIRに反映できます。

**バッチの実行タイミング**：新しいSPIR-V命令をサポートする時、define_inst.shから呼び出されます。また、既存のオペコード定義を更新する際にも手動で実行できます。

**主要な処理内容**：
1. 引数から命令名を取得（オプション、複数指定可）
2. gen_spirv_dialect.pyスクリプトを呼び出し
3. SPIRVBase.tdファイル内のオペコードマッピングを更新
4. 引数がない場合は既存のオペコード定義を更新

**前後の処理との関連**：define_inst.shから呼び出されます。define_enum.shと組み合わせて、SPIR-V方言の完全な定義を生成できます。

**影響範囲**：mlir/include/mlir/Dialect/SPIRV/IR/SPIRVBase.tdに影響します。

## バッチ種別

コード生成 / 自動生成ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SPIR-V仕様更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / define_inst.shから呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python3 | Python3がインストールされていること |
| gen_spirv_dialect.py | 同じディレクトリにスクリプトが存在すること |
| readlink | readlinkコマンドが利用可能であること |

### 実行可否判定

Python3と必要なファイルが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| op-name | string... | No | なし | オペコードを登録する命令名（複数指定可、省略時は既存を更新） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SPIR-V仕様 | JSON | spirv.core.grammar.jsonのinstructionsリスト |
| SPIRVBase.td | TableGen | 既存のMLIR SPIR-V定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| SPIRVBase.td | TableGen | 更新されたオペコードマッピング |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SPIRVBase.td |
| 出力先 | mlir/include/mlir/Dialect/SPIRV/IR/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパス解決
   └─ readlinkで絶対パスを取得
   └─ dirnameでディレクトリを取得
2. Python3スクリプト呼び出し
   └─ gen_spirv_dialect.py を実行
   └─ --base-td-path でSPIRVBase.tdを指定
   └─ --new-opcode で命令名を渡す（$@で全引数）
3. オペコード定義更新
   └─ SPIRVBase.tdが更新される
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[gen_spirv_dialect.py呼び出し]
    C --> D{命令名指定あり?}
    D -->|あり| E[新規オペコード登録]
    D -->|なし| F[既存定義更新]
    E --> G[SPIRVBase.td更新]
    F --> G
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | Python実行エラー | Python3が見つからない | Python3をインストール |
| 非0 | ファイル不在 | SPIRVBase.tdが見つからない | パスを確認 |
| 非0 | 無効な命令名 | 指定した命令がSPIR-V仕様に存在しない | 命令名を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

### 障害時対応

エラー発生時は、gen_spirv_dialect.pyのエラー出力を確認し、命令名やファイルパスを確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | Pythonスクリプト終了時 |
| ロールバック条件 | なし（ファイル直接更新） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜数件のオペコード |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一ファイルへの同時書き込みは想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Python出力 | 処理中 | gen_spirv_dialect.pyの出力 |
| エラーログ | エラー発生時 | Pythonエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 実行元に返却 |

## 備考

- 使用例：
  - `./define_opcodes.sh OpTypeVoid OpTypeFunction`
  - `./define_opcodes.sh` （引数なし：既存定義の更新）
- SPIR-V仕様のinstructionsリストから命令名とオペコードの対応を取得
- define_inst.shから自動的に呼び出されるため、通常は直接実行する必要はない
- $@で全ての引数を渡すため、複数の命令名を一度に指定可能
- 関連スクリプト：define_enum.sh, define_inst.sh
