# バッチ設計書 41-setup.sh (lldb-test-qemu)

## 概要

本ドキュメントは、LLDB QEMUテスト環境セットアップスクリプト（setup.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、LLDBのリモートデバッグ機能をQEMUエミュレータ上でテストするための環境構築を自動化するバッチです。ARMおよびAArch64アーキテクチャ向けのQEMUエミュレータとLinuxカーネルをソースからビルドし、LLDBのクロスプラットフォームデバッグテスト環境を提供します。

**業務上の目的・背景**：LLDBデバッガは多様なアーキテクチャをサポートしており、ARM/AArch64環境でのデバッグ機能をテストするには実機がなくてもQEMUエミュレータを使用することで検証が可能です。このスクリプトは、開発者がQEMUとLinuxカーネルを手動でビルドする手間を省き、一貫したテスト環境を構築することを目的としています。

**バッチの実行タイミング**：開発者がLLDBのARM/AArch64向けリモートデバッグ機能をテストする際に手動で実行します。初回セットアップ時、または環境の再構築時に使用されます。

**主要な処理内容**：
1. aptリポジトリの更新と確認
2. QEMU用ビルド依存パッケージのインストール
3. QEMUソースコードのクローンとビルド（arm-softmmu, aarch64-softmmu）
4. Linuxカーネル用ビルド依存パッケージのインストール
5. Linuxカーネルソースのクローンとビルド（ARM/AArch64向け）
6. クリーンアップオプションによるビルドディレクトリの削除

**前後の処理との関連**：本スクリプトの実行後、rootfs.sh（No.42）でルートファイルシステムを作成し、run-qemu.sh（No.43）でQEMUを起動してLLDBテストを実行できます。

**影響範囲**：ローカルファイルシステム（qemu.git、linux.git、linux.buildディレクトリ）、システムパッケージ（apt経由でインストール）

## バッチ種別

環境構築 / ビルド自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| OS | Ubuntu/Debian系Linux |
| 権限 | sudo権限（パッケージインストール用） |
| ネットワーク | GitリポジトリへのHTTPSアクセス |
| ディスク容量 | QEMUとLinuxカーネルのビルドに十分な空き容量（10GB以上推奨） |

### 実行可否判定

ユーザーの確認入力（y/Y）により処理を継続するかどうかを判定します。既存ディレクトリが存在する場合も確認を求めます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --help | フラグ | No | - | ヘルプメッセージを表示 |
| --kernel | 文字列 | No | - | Linuxカーネルをビルドするアーキテクチャ（arm/arm64） |
| --qemu | フラグ | No | - | QEMUをビルドするフラグ |
| --clean | フラグ | No | - | ビルドディレクトリを削除 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://gitlab.com/qemu-project/qemu.git | Git リポジトリ | QEMUソースコード |
| https://git.kernel.org/.../linux.git | Git リポジトリ | Linuxカーネルソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| qemu.git/ | ディレクトリ | QEMUソースコードとビルド成果物 |
| linux.git/ | ディレクトリ | Linuxカーネルソースコード |
| linux.build/arm/ | ディレクトリ | ARM向けカーネルビルド成果物 |
| linux.build/arm64/ | ディレクトリ | AArch64向けカーネルビルド成果物 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| QEMUバイナリ | qemu.git/arm-softmmu/qemu-system-arm, qemu.git/aarch64-softmmu/qemu-system-aarch64 |
| Linuxカーネル（ARM） | linux.build/arm/arch/arm/boot/zImage |
| Linuxカーネル（AArch64） | linux.build/arm64/arch/arm64/boot/Image |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --help, --kernel, --qemu, --clean オプションを解析

2. aptリポジトリの更新
   └─ ユーザー確認後、sudo apt update を実行

3. QEMUビルド（--qemu指定時）
   └─ 依存パッケージインストール
   └─ ソースコードクローン（深さ1）
   └─ configure実行（arm-softmmu, aarch64-softmmu）
   └─ make実行（並列ビルド）

4. Linuxカーネルビルド（--kernel指定時）
   └─ 依存パッケージインストール
   └─ ソースコードクローン（深さ1）
   └─ クロスコンパイラインストール
   └─ カーネルコンフィグ設定
   └─ make実行（並列ビルド）

5. クリーンアップ（--clean指定時）
   └─ linux.git, linux.build, qemu.git ディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数解析}
    B --> C{--clean?}
    C -->|Yes| D[ディレクトリ削除]
    D --> E[終了]
    C -->|No| F[aptリポジトリ更新]
    F --> G{ユーザー確認}
    G -->|No| E
    G -->|Yes| H{--kernel指定?}
    H -->|Yes| I[Linuxカーネルビルド]
    H -->|No| J{--qemu指定?}
    I --> J
    J -->|Yes| K[QEMUビルド]
    J -->|No| L[バッチ終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正な引数が指定された場合 | ヘルプメッセージを表示して終了 |
| 1 | アーキテクチャエラー | --kernelに不正な値が指定された場合 | arm/arm64のみ指定可能 |
| - | ユーザー中断 | 確認でy/Y以外が入力された場合 | 処理を中断して終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

ビルドが失敗した場合は、--cleanオプションで環境をクリアした後、再度実行することを推奨します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回 |
| 目標処理時間 | 30分〜2時間（ネットワーク環境・CPUコア数に依存） |
| メモリ使用量上限 | ビルド時に数GBを消費する可能性あり |

## 排他制御

同一ディレクトリでの同時実行は想定していません。既存ディレクトリがある場合はユーザーに確認を求めます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ステップ開始時 | 処理内容の説明 |
| ビルドログ | ビルド中 | make/configureの出力 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- QEMUとLinuxカーネルは最新のmasterブランチからshallow clone（depth=1）されます
- ビルドはシステムのCPUコア数に応じて並列化されます（getconf _NPROCESSORS_ONLN）
- ARM向けにはvexpress_defconfig、AArch64向けにはdefconfigが使用されます
