# バッチ設計書 42-rootfs.sh

## 概要

本ドキュメントは、QEMUテスト用Ubuntuルートファイルシステムイメージ作成スクリプト（rootfs.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、LLDBリモートデバッグテスト用のQEMU仮想マシンで使用するUbuntuルートファイルシステム（rootfs）イメージを作成するバッチです。debootstrapとqemu-user-staticを使用して、ARMまたはAArch64アーキテクチャ向けのUbuntuファイルシステムイメージを生成します。

**業務上の目的・背景**：LLDBのリモートデバッグ機能をQEMUエミュレータ上でテストするには、完全なLinuxユーザーランド環境が必要です。このスクリプトは、指定したアーキテクチャとUbuntuディストリビューションのルートファイルシステムを自動生成し、QEMUでブート可能なイメージを作成します。テスト環境の再現性と一貫性を確保することが目的です。

**バッチの実行タイミング**：開発者がLLDBのQEMUテスト環境を構築する際に手動で実行します。新しいテスト環境を作成する場合、または異なるUbuntuバージョン・アーキテクチャのイメージが必要な場合に使用されます。

**主要な処理内容**：
1. コマンドライン引数の検証（アーキテクチャ、ディストリビューション、サイズ）
2. ビルド依存パッケージのインストール（debootstrap、qemu-user-static等）
3. qemu-imgによる空のディスクイメージ作成
4. ext4ファイルシステムの作成
5. qemu-debootstrapによるUbuntuベースシステムのインストール
6. ロケール設定、リポジトリ設定、基本パッケージのインストール
7. ユーザーアカウントの作成

**前後の処理との関連**：setup.sh（No.41）でQEMUとLinuxカーネルをビルドした後に実行し、作成されたルートファイルシステムはrun-qemu.sh（No.43）でQEMU起動時に使用されます。

**影響範囲**：ローカルファイルシステム（生成されるイメージファイル）、システムパッケージ（apt経由でインストール）

## バッチ種別

環境構築 / イメージ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| OS | Ubuntu/Debian系Linux |
| 権限 | sudo権限（パッケージインストール、マウント、chroot用） |
| ネットワーク | Ubuntuリポジトリへのアクセス |
| ディスク容量 | 指定サイズ以上の空き容量 |

### 実行可否判定

必須パラメータ（--arch、--distro、--size）が全て指定され、値が有効な場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --help | フラグ | No | - | ヘルプメッセージを表示 |
| --arch | 文字列 | Yes | - | アーキテクチャ（armhf/arm64） |
| --distro | 文字列 | Yes | - | Ubuntuディストリビューション（bionic/focal） |
| --size | 文字列 | Yes | - | イメージサイズ（例: 1G, 512M） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Ubuntuリポジトリ | debootstrap | Ubuntuパッケージアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {distro}-{arch}-rootfs.img | ext4イメージ | ルートファイルシステムイメージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {distro}-{arch}-rootfs.img（例: focal-arm64-rootfs.img） |
| 出力先 | カレントディレクトリ |
| ファイルシステム | ext4 |
| 内容 | Ubuntuベースシステム、SSH、bash-completion |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析と検証
   └─ --arch, --distro, --size の必須チェック
   └─ アーキテクチャの有効性チェック（armhf/arm64）
   └─ サイズ形式の検証（数値+K/M/G）

2. aptリポジトリの更新
   └─ ユーザー確認後、sudo apt update を実行

3. ビルド依存パッケージのインストール
   └─ debootstrap, qemu-user-static, schroot, qemu-utils

4. ディスクイメージの作成
   └─ qemu-img create でイメージファイル作成
   └─ mkfs.ext4 でファイルシステム作成
   └─ ループマウント

5. Ubuntuベースシステムのインストール
   └─ qemu-debootstrap でベースシステム展開

6. システム設定
   └─ ロケール設定（en_US.UTF-8）
   └─ apt sources.list の更新
   └─ DNS設定（8.8.8.8）
   └─ 追加パッケージインストール（ssh, bash-completion）
   └─ ユーザーアカウント作成

7. クリーンアップ
   └─ アンマウント
   └─ 一時ディレクトリ削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析・検証]
    B --> C{引数有効?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[aptリポジトリ更新]
    E --> F{ユーザー確認}
    F -->|No| G[終了]
    F -->|Yes| H[依存パッケージインストール]
    H --> I[qemu-imgでイメージ作成]
    I --> J[mkfs.ext4でフォーマット]
    J --> K[ループマウント]
    K --> L[qemu-debootstrap実行]
    L --> M[システム設定]
    M --> N[パッケージインストール]
    N --> O[ユーザー作成]
    O --> P[アンマウント]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正な引数が指定された場合 | ヘルプメッセージを表示して終了 |
| 1 | アーキテクチャエラー | arm64/armhf以外が指定された場合 | 有効なアーキテクチャを指定 |
| 1 | サイズ形式エラー | 数値+K/M/G以外の形式 | 正しい形式で指定（例: 1G） |
| - | 必須パラメータ欠落 | --arch, --distro, --size が未指定 | 全ての必須パラメータを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

`set -e`により、エラー発生時は即座に処理が中断されます。マウント済みのイメージがある場合は手動でアンマウントする必要があります。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回 |
| 目標処理時間 | 10〜30分（ネットワーク速度・イメージサイズに依存） |
| メモリ使用量上限 | debootstrap処理に依存 |

## 排他制御

同時実行は想定していません。同名のイメージファイルが存在する場合は上書きされます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ステップ開始時 | イメージ名、サイズ等の情報 |
| パッケージログ | インストール中 | apt/debootstrapの出力 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- 作成されるイメージは現在のユーザー名でアカウントが作成されます（$USER変数を使用）
- DNS設定として8.8.8.8（Google Public DNS）がハードコードされています
- ルートファイルシステムにはmain, restricted, multiverse, universeリポジトリが設定されます
