# バッチ設計書 43-run-qemu.sh

## 概要

本ドキュメントは、QEMUエミュレータ実行スクリプト（run-qemu.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、LLDBリモートデバッグテスト用のQEMUシステムモードエミュレーションを起動するバッチです。ARMまたはAArch64アーキテクチャ向けのQEMU仮想マシンを、指定されたLinuxカーネルとルートファイルシステムを使用して起動します。SVE（Scalable Vector Extension）、MTE（Memory Tagging Extension）、SME（Scalable Matrix Extension）などのAArch64拡張機能もサポートしています。

**業務上の目的・背景**：LLDBのリモートデバッグ機能をテストするには、ターゲットとなるARM/AArch64環境が必要です。実機を用意する代わりに、QEMUエミュレータを使用することでローカル環境でテストが可能になります。このスクリプトは、setup.sh（No.41）でビルドしたQEMUとLinuxカーネル、rootfs.sh（No.42）で作成したルートファイルシステムを組み合わせて、テスト可能な仮想マシン環境を起動します。

**バッチの実行タイミング**：LLDBのリモートデバッグ機能をテストする際に手動で実行します。テストセッション開始前にQEMU仮想マシンを起動し、テスト完了後に終了させます。

**主要な処理内容**：
1. コマンドライン引数の解析（アーキテクチャ、各種パス、CPU拡張機能）
2. ルートファイルシステムイメージの存在確認
3. Linuxカーネルイメージの検索または指定パスの確認
4. QEMUバイナリの検索または指定パスの確認
5. アーキテクチャに応じたQEMU設定（CPU、マシンタイプ）
6. CPU拡張機能（SVE/MTE/SME）の設定
7. QEMUエミュレータの起動

**前後の処理との関連**：setup.sh（No.41）でQEMUとLinuxカーネルをビルドし、rootfs.sh（No.42）でルートファイルシステムを作成した後に実行します。起動したQEMU環境でLLDBリモートデバッグテストを実行します。

**影響範囲**：システムリソース（CPU、メモリ）、ネットワーク（tapデバイス）

## バッチ種別

エミュレータ実行 / テスト環境起動

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| QEMU | ビルド済みまたは指定されたQEMUバイナリ |
| Linuxカーネル | ビルド済みまたは指定されたカーネルイメージ |
| rootfs | 作成済みのルートファイルシステムイメージ |
| ネットワーク | tapデバイスの設定（DHCPネットワーク用） |

### 実行可否判定

ルートファイルシステムイメージが存在し、Linuxカーネルイメージとqemu-systemバイナリが利用可能な場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --arch | 文字列 | Yes | - | アーキテクチャ（arm/arm64） |
| --rootfs | パス | Yes | - | ルートファイルシステムイメージのパス |
| --kernel | パス | No | linux.build/{arch}/arch/{arch}/boot/Image | Linuxカーネルイメージのパス |
| --qemu | パス | No | qemu.git/{arch}-softmmu/qemu-system-* | QEMUバイナリのパス |
| --sve | フラグ | No | - | AArch64 SVEモードを有効化 |
| --mte | フラグ | No | - | AArch64 MTEモードを有効化 |
| --sme | フラグ | No | - | AArch64 SMEモードを有効化 |
| --help | フラグ | No | - | ヘルプメッセージを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| rootfsイメージ | ext4 raw | ルートファイルシステムイメージファイル |
| Linuxカーネル | zImage/Image | カーネルバイナリ |
| QEMUバイナリ | 実行ファイル | qemu-system-arm/aarch64 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | QEMUコンソール出力 |

### 出力ファイル仕様

本バッチはファイル出力を行いません。QEMUコンソールは標準出力にリダイレクトされます（-nographic オプション）。

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --arch, --rootfs, --kernel, --qemu, --sve, --mte, --sme

2. rootfsイメージの確認
   └─ ファイルが存在しない場合はエラー終了

3. Linuxカーネルイメージの検索
   └─ --kernel指定がない場合はデフォルトパスを検索
   └─ ARMはzImage、AArch64はImageを使用

4. QEMUバイナリの検索
   └─ --qemu指定がない場合はqemu.git内を検索

5. アーキテクチャ別QEMU設定
   └─ ARM: virt,highmem=off / cortex-a15
   └─ AArch64: virt / cortex-a53 (または max)

6. CPU拡張機能の設定（AArch64のみ）
   └─ SVE/MTE/SME指定時はCPU=maxに変更
   └─ SVE: sve-max-vq=4を追加
   └─ MTE: mte=onをマシンに追加

7. QEMUの起動
   └─ 2コア、1024MBメモリで起動
   └─ virtio-blkでrootfs、virtio-netでネットワーク
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{rootfs存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E{kernel指定?}
    E -->|No| F[デフォルトパス検索]
    E -->|Yes| G[指定パス使用]
    F --> H{kernel存在?}
    G --> H
    H -->|No| I[エラー終了]
    H -->|Yes| J{qemu指定?}
    J -->|No| K[デフォルトパス検索]
    J -->|Yes| L[指定パス使用]
    K --> M{qemu存在?}
    L --> M
    M -->|No| N[エラー終了]
    M -->|Yes| O[アーキテクチャ設定]
    O --> P{SVE/MTE/SME?}
    P -->|Yes| Q[CPU拡張設定]
    P -->|No| R[QEMU起動]
    Q --> R
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正な引数が指定された場合 | ヘルプを参照して正しい引数を指定 |
| - | rootfsなし | rootfsイメージが存在しない | rootfs.shでイメージを作成 |
| - | カーネルなし | カーネルイメージが見つからない | setup.shでカーネルをビルドまたは--kernelで指定 |
| - | QEMUなし | QEMUバイナリが見つからない | setup.shでQEMUをビルドまたは--qemuで指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

QEMU起動に失敗した場合は、各コンポーネント（カーネル、rootfs、QEMU）の存在と整合性を確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1インスタンス |
| 目標処理時間 | 起動時間は数十秒、実行時間は任意 |
| メモリ使用量上限 | QEMU用に1024MB + ホストオーバーヘッド |

## 排他制御

同一rootfsイメージを使用する複数のQEMUインスタンスの同時実行は推奨されません（ファイルシステムの整合性問題）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | ARM使用時のSVE/MTE/SME指定 | AArch64専用機能である旨の警告 |
| コンソール | 実行中 | Linuxカーネル/ユーザーランドの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- QEMU設定: 2コア、1024MBメモリ固定
- SVE最大ベクター長: VQ=4（512ビット）
- ネットワーク: tapデバイスを使用したDHCP接続
- コンソール: -nographicオプションにより、標準入出力をシリアルコンソールとして使用
- ARMアーキテクチャではhighmem=offが設定されます
