# バッチ設計書 44-build.sh (ABITest)

## 概要

本ドキュメントは、ABI（Application Binary Interface）テストビルドスクリプト（build.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、Clangコンパイラの ABI互換性テストをビルドするバッチです。指定された数のテストケースに対して、makeコマンドを使用してテストレポートを並列生成します。ABIテストは、異なるコンパイラ間での関数呼び出し規約やデータレイアウトの互換性を検証するために使用されます。

**業務上の目的・背景**：コンパイラ開発において、ABI互換性は非常に重要です。異なるコンパイラでコンパイルされたオブジェクトファイルが正しくリンクし、関数呼び出しが正常に動作することを保証する必要があります。このスクリプトは、ClangのABI実装が正しいかどうかを検証するためのテストスイートをビルドします。戻り値の受け渡しや単一引数の受け渡しなど、ABIの各側面をテストします。

**バッチの実行タイミング**：ABI互換性のテストを実行する際に手動で実行します。Clangの新機能開発時、ABIに影響する変更を行った後、またはリリース前の検証として使用されます。

**主要な処理内容**：
1. コマンドライン引数の検証（テスト数）
2. 指定されたテスト数分のテストレポートをmakeで並列ビルド
3. テスト0からtest.{N}.reportまでを生成

**前後の処理との関連**：単独で実行することも、build-and-summarize.sh（No.45）から呼び出されることもあります。生成されたレポートはsummarize.sh（No.47）で集計されます。

**影響範囲**：テストビルドディレクトリ内のファイル生成

## バッチ種別

テストビルド / ABI互換性検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 / 他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| make | GNU Makeがインストールされていること |
| Makefile | ABIテスト用のMakefileが存在すること |
| コンパイラ | テスト対象のClangコンパイラが利用可能 |

### 実行可否判定

コマンドライン引数として有効なテスト数が指定された場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| num-tests | 整数 | Yes | - | 実行するテストの数（0からN-1） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile | Makefile | ABIテスト用ビルド定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| test.{N}.report | テキスト | 各テストケースのレポートファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | test.{0..N}.report |
| 出力先 | カレントディレクトリ |
| 形式 | テキストレポート |

## 処理フロー

### 処理シーケンス

```
1. 引数の検証
   └─ 引数が1つでない場合はusageを表示して終了

2. 並列ビルドの実行
   └─ CPUs=2 で並列度を設定
   └─ seq 0 $1 でテスト番号を生成
   └─ make -j $CPUS で並列ビルド
   └─ -k オプションでエラーがあっても継続
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数確認}
    B -->|!=1| C[usage表示]
    C --> D[終了 code=1]
    B -->|==1| E[テスト番号リスト生成]
    E --> F[make -j 2 で並列ビルド]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が1つでない場合 | 正しい引数でスクリプトを再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（-kオプションでエラー継続） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

make -k オプションにより、個別のテストが失敗しても他のテストは継続してビルドされます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テスト数に依存 |
| 目標処理時間 | テスト数とシステム性能に依存 |
| メモリ使用量上限 | コンパイル時のメモリ消費に依存 |

## 排他制御

同一ディレクトリでの同時実行は想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| makeログ | ビルド中 | makeの標準出力 |
| エラーログ | ビルドエラー時 | コンパイルエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- 並列度は2（CPUS=2）に固定されています
- set -euにより、未定義変数の使用やコマンドエラーで即座に終了します（ただしmakeは-kで継続）
- テスト番号は0から始まり、指定された数値まで（0 to $1）生成されます
