# バッチ設計書 45-build-and-summarize.sh

## 概要

本ドキュメントは、ABIテストビルドとサマリー生成スクリプト（build-and-summarize.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、ABIテストのビルドと結果サマリーの生成を一括で行うバッチです。build.sh（No.44）を呼び出してテストをビルドし、続いてsummarize.sh（No.47）を呼び出して失敗したテストの一覧を生成します。テスト結果をfails-x.txtファイルに出力し、失敗数を表示します。

**業務上の目的・背景**：ABIテストの実行において、ビルドと結果集計を個別に行うのは手間がかかります。このスクリプトは、一連のABIテストワークフロー（ビルド→集計→結果表示）を自動化し、開発者がテスト結果を素早く確認できるようにします。特にreturn-types（戻り値の型）やsingle-args（単一引数）などのテストカテゴリ用のサブディレクトリで使用されます。

**バッチの実行タイミング**：ABIテストを実行する際に手動で実行します。特定のテストカテゴリ（32bit/64bit、return-types/single-args）のテストを実行する場合に使用されます。

**主要な処理内容**：
1. コマンドライン引数の検証（テスト数）
2. build.shを呼び出してテストをビルド（出力は抑制、エラーは無視）
3. summarize.shを呼び出して失敗テストを抽出
4. 結果をfails-x.txtに保存
5. 結果の表示と行数カウント

**前後の処理との関連**：build.sh（No.44）とsummarize.sh（No.47）を内部で呼び出します。build-and-summarize-all.sh（No.46）から呼び出されることもあります。

**影響範囲**：カレントディレクトリ内のfails-x.txtファイル

## バッチ種別

テストビルド・集計 / ワークフロー自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 / 他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| build.sh | 同一ディレクトリにbuild.shが存在 |
| summarize.sh | 親ディレクトリにsummarize.shが存在 |
| make | GNU Makeがインストールされていること |

### 実行可否判定

コマンドライン引数として有効なテスト数が指定された場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| num-tests | 整数 | Yes | - | 実行するテストの数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| build.sh | シェルスクリプト | ビルド実行スクリプト |
| summarize.sh | シェルスクリプト | サマリー生成スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| fails-x.txt | テキスト | 失敗したテストの一覧 |
| 標準出力 | テキスト | 失敗一覧と行数 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | fails-x.txt |
| 出力先 | カレントディレクトリ |
| 文字コード | システムデフォルト |
| 内容 | 失敗したテスト番号の一覧（"FAIL: N"形式） |

## 処理フロー

### 処理シーケンス

```
1. 引数の検証
   └─ 引数が1つでない場合はusageを表示して終了

2. スクリプトディレクトリの取得
   └─ dirname $0 でスクリプトのディレクトリを取得

3. テストビルドの実行
   └─ build.shを呼び出し
   └─ 出力は/dev/nullにリダイレクト
   └─ エラーがあってもtrueで継続

4. サマリー生成
   └─ ../summarize.shを呼び出し
   └─ 結果をfails-x.txtに保存

5. 結果表示
   └─ fails-x.txtの内容を表示
   └─ wc -lで行数（失敗数）を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数確認}
    B -->|!=1| C[usage表示]
    C --> D[終了 code=1]
    B -->|==1| E[build.sh実行]
    E --> F[summarize.sh実行]
    F --> G[fails-x.txtに出力]
    G --> H[結果表示]
    H --> I[行数表示]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が1つでない場合 | 正しい引数でスクリプトを再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

build.shの実行エラーは `|| true` で無視されるため、ビルドが部分的に失敗しても処理は継続します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テスト数に依存 |
| 目標処理時間 | テスト数とシステム性能に依存 |
| メモリ使用量上限 | コンパイル時のメモリ消費に依存 |

## 排他制御

同一ディレクトリでの同時実行は想定していません。fails-x.txtは上書きされます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | なし | /dev/nullにリダイレクト |
| 結果ログ | 処理完了時 | fails-x.txtの内容 |
| カウントログ | 処理完了時 | 失敗テスト数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- build.shの出力は `&> /dev/null` で完全に抑制されます
- build.shの実行エラーは `|| true` で無視され、サマリー生成に進みます
- summarize.shは親ディレクトリ（../）から参照されます
- set -euにより、未定義変数の使用で即座に終了します
