# バッチ設計書 46-build-and-summarize-all.sh

## 概要

本ドキュメントは、全ABIテストビルドとサマリー生成スクリプト（build-and-summarize-all.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、複数のテストカテゴリ（32ビット/64ビット、return-types/single-args）に対して一括でABIテストを実行し、サマリーを生成するバッチです。各テストカテゴリのサブディレクトリに移動し、build-and-summarize.sh（No.45）を呼び出して個別のテスト実行と集計を行います。

**業務上の目的・背景**：ClangコンパイラのABI互換性テストには、複数のテストカテゴリがあります。戻り値の型（return-types）と単一引数（single-args）の各テストを、32ビットと64ビットの両方のアーキテクチャで検証する必要があります。このスクリプトは、4つの組み合わせ（return-types-32、return-types-64、single-args-32、single-args-64）すべてのテストを一括で実行し、開発者が全体的なABI互換性の状況を把握できるようにします。

**バッチの実行タイミング**：ABIテストの全体実行が必要な場合に手動で実行します。リリース前の検証、ABI関連の変更後の回帰テストなどに使用されます。

**主要な処理内容**：
1. コマンドライン引数の検証（テスト数）
2. 32ビット/64ビットのループ
3. return-types/single-argsのループ
4. 各カテゴリでbuild-and-summarize.shを実行
5. カテゴリヘッダー（-- kind-bits --）の表示

**前後の処理との関連**：build-and-summarize.sh（No.45）を内部で呼び出します。各サブディレクトリにはbuild.sh（No.44）とsummarize.sh（No.47）が必要です。

**影響範囲**：各テストカテゴリディレクトリ内のファイル（fails-x.txt等）

## バッチ種別

テストビルド・集計 / 一括実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| サブディレクトリ構造 | return-types-32、return-types-64、single-args-32、single-args-64が存在 |
| build-and-summarize.sh | 各サブディレクトリにbuild-and-summarize.shが存在 |
| make | GNU Makeがインストールされていること |

### 実行可否判定

コマンドライン引数として有効なテスト数が指定された場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| num-tests | 整数 | Yes | - | 各カテゴリで実行するテストの数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| サブディレクトリ | ディレクトリ | 各テストカテゴリのディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各カテゴリのヘッダーとテスト結果 |
| 各ディレクトリ/fails-x.txt | テキスト | 各カテゴリの失敗テスト一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | fails-x.txt（各サブディレクトリ） |
| 出力先 | return-types-32/, return-types-64/, single-args-32/, single-args-64/ |
| 形式 | テキスト（失敗テスト一覧） |

## 処理フロー

### 処理シーケンス

```
1. 引数の検証
   └─ 引数が1つでない場合はusageを表示して終了

2. ビット数ループ（32, 64）
   └─ テスト種別ループ（return-types, single-args）
      └─ ヘッダー表示（-- kind-bits --）
      └─ サブディレクトリに移動してbuild-and-summarize.sh実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数確認}
    B -->|!=1| C[usage表示]
    C --> D[終了 code=1]
    B -->|==1| E[bits=32から開始]
    E --> F[kind=return-typesから開始]
    F --> G[ヘッダー表示]
    G --> H[サブディレクトリで実行]
    H --> I{kind完了?}
    I -->|No| J[kind=single-args]
    J --> G
    I -->|Yes| K{bits完了?}
    K -->|No| L[bits=64]
    L --> F
    K -->|Yes| M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が1つでない場合 | 正しい引数でスクリプトを再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

set -euにより、サブスクリプトでエラーが発生すると処理が中断します。エラーが発生した場合は、該当するサブディレクトリを確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テスト数 x 4カテゴリ |
| 目標処理時間 | テスト数とシステム性能に依存 |
| メモリ使用量上限 | コンパイル時のメモリ消費に依存 |

## 排他制御

同一ディレクトリでの同時実行は想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| カテゴリヘッダー | 各カテゴリ開始時 | "-- kind-bits --"形式 |
| テスト結果 | 各カテゴリ完了時 | build-and-summarize.shの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- テストカテゴリは4つ: return-types-32、return-types-64、single-args-32、single-args-64
- 各カテゴリの実行前に "-- kind-bits --" 形式のヘッダーが表示されます
- サブシェル `(cd ...)` を使用してディレクトリ変更の影響を局所化しています
- set -euにより、エラー発生時は即座に処理が中断されます
