# バッチ設計書 47-summarize.sh

## 概要

本ドキュメントは、ABIテスト結果サマリー生成スクリプト（summarize.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、ABIテストのビルド結果を検証し、失敗したテストケースの一覧を生成するバッチです。指定された数のテストに対して個別にmake test.{N}.reportを実行し、失敗したテスト番号を標準出力に出力します。

**業務上の目的・背景**：ABIテストは多数のテストケースから構成されており、全てのテストが成功したかどうかを確認する必要があります。このスクリプトは、各テストケースを個別に検証し、失敗したものだけを報告することで、開発者が問題のあるテストケースを素早く特定できるようにします。build-and-summarize.sh（No.45）から呼び出され、テスト結果の集計に使用されます。

**バッチの実行タイミング**：ABIテストのビルド後に実行します。通常はbuild-and-summarize.sh（No.45）から呼び出されますが、単独で実行することも可能です。

**主要な処理内容**：
1. コマンドライン引数の検証（テスト数）
2. 0からNまでのテスト番号をループ
3. 各テストに対してmake test.{N}.reportを実行
4. 失敗した場合は"FAIL: {N}"を出力
5. 成功した場合は何も出力しない

**前後の処理との関連**：build.sh（No.44）でテストがビルドされた後に実行されます。build-and-summarize.sh（No.45）やbuild-and-summarize-all.sh（No.46）から呼び出されます。

**影響範囲**：標準出力のみ（ファイル出力は行わない）

## バッチ種別

テスト検証 / 結果集計

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動・他スクリプトからの呼び出し） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 / 他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| make | GNU Makeがインストールされていること |
| Makefile | test.{N}.reportターゲットが定義されていること |
| テストビルド | build.shが実行済みであること |

### 実行可否判定

コマンドライン引数として有効なテスト数が指定された場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| num-tests | 整数 | Yes | - | 検証するテストの数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile | Makefile | test.{N}.reportターゲットの定義 |
| テストファイル | 各種 | build.shで生成されたテスト関連ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 失敗したテストの一覧（"FAIL: {N}"形式） |

### 出力ファイル仕様

本バッチはファイル出力を行いません。結果は標準出力に出力されます。

| 項目 | 内容 |
|-----|------|
| 出力形式 | "FAIL: {テスト番号}"（1行1テスト） |
| 出力条件 | テストが失敗した場合のみ |

## 処理フロー

### 処理シーケンス

```
1. 引数の検証
   └─ 引数が1つでない場合はusageを表示して終了

2. テストループ（0からNまで）
   └─ make test.{N}.reportを実行（出力は/dev/nullへ）
   └─ 失敗した場合は"FAIL: {N}"を出力
   └─ 成功した場合は何も出力しない
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数確認}
    B -->|!=1| C[usage表示]
    C --> D[終了 code=1]
    B -->|==1| E[i=0から開始]
    E --> F[make test.i.report実行]
    F --> G{成功?}
    G -->|No| H["FAIL: i"を出力]
    G -->|Yes| I[何も出力しない]
    H --> J{i<N?}
    I --> J
    J -->|Yes| K[i++]
    K --> F
    J -->|No| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が1つでない場合 | 正しい引数でスクリプトを再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

個別のmake実行エラーは失敗として報告されます（FAIL出力）。スクリプト全体は継続して実行されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テスト数に依存 |
| 目標処理時間 | テスト数に依存（各テストの検証時間の合計） |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一ディレクトリでの同時実行は想定していません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 失敗ログ | テスト失敗時 | "FAIL: {テスト番号}" |
| makeログ | なし | /dev/nullにリダイレクト |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- makeの出力は `&> /dev/null` で完全に抑制されます
- テストの成功・失敗はmakeの終了コードで判定されます
- 失敗したテストのみが報告され、成功したテストは出力されません
- set -euにより、未定義変数の使用で即座に終了しますが、makeの失敗はif文で捕捉されるため処理は継続します
