# バッチ設計書 48-cleanup_run_static_analyzer.sh

## 概要

本ドキュメントは、静的解析クリーンアップスクリプト（cleanup_run_static_analyzer.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、Clang Static Analyzer（静的解析ツール）を実行した後のビルドディレクトリをクリーンアップするバッチです。各プロジェクト固有のディレクトリに配置され、静的解析実行後に生成されたビルド成果物を削除します。

**業務上の目的・背景**：Clang Static Analyzerは、C/C++コードの潜在的なバグやセキュリティ問題を検出するための静的解析ツールです。解析を実行すると、buildディレクトリにビルド成果物や解析結果が生成されます。このスクリプトは、解析完了後にこれらの一時ファイルを削除し、ディスク容量を回復させるとともに、次回の解析のためにクリーンな状態を維持します。

**バッチの実行タイミング**：静的解析の実行後、または新しい解析を開始する前に手動で実行します。特にCIパイプラインでの解析ジョブ後のクリーンアップや、ディスク容量が逼迫した場合に使用されます。

**主要な処理内容**：
1. buildディレクトリの完全削除（rm -rf ./build）

**前後の処理との関連**：Clang Static Analyzerの実行（scan-build等）後に実行されます。複数のプロジェクト（capnproto、termbox、cppcheck、oatpp、symengine、tinyexpr等）それぞれに同様のスクリプトが存在し、プロジェクト固有のクリーンアップを担当します。

**影響範囲**：カレントディレクトリ内のbuildディレクトリ

## バッチ種別

クリーンアップ / 後処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 / CI後処理 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| カレントディレクトリ | プロジェクトのディレクトリ内で実行 |
| buildディレクトリ | 削除対象のbuildディレクトリが存在 |

### 実行可否判定

特別な条件チェックは行われません。buildディレクトリが存在しない場合も、rm -rfはエラーを発生させずに終了します。

## 入力仕様

### 入力パラメータ

本バッチはコマンドライン引数を受け取りません。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ./build | ディレクトリ | 削除対象のビルドディレクトリ |

## 出力仕様

### 出力データ

本バッチはファイル出力を行いません。ディレクトリの削除のみを行います。

| 出力先 | 形式 | 説明 |
|-------|------|------|
| - | - | 出力なし（削除処理のみ） |

### 出力ファイル仕様

該当なし。

## 処理フロー

### 処理シーケンス

```
1. buildディレクトリの削除
   └─ rm -rf ./build を実行
   └─ ディレクトリが存在しない場合もエラーにならない
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[rm -rf ./build実行]
    B --> C[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 削除権限がない場合 | 適切な権限でスクリプトを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

権限エラーが発生した場合は、適切な権限（sudo等）で再実行するか、手動でディレクトリを削除してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ディレクトリ |
| 目標処理時間 | 数秒（ディレクトリサイズに依存） |
| メモリ使用量上限 | 最小限 |

## 排他制御

静的解析の実行中にこのスクリプトを実行しないでください。ビルドディレクトリが削除され、解析が失敗します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- 非常にシンプルな1行スクリプトです
- rm -rf は確認なしで削除を実行するため、実行前にカレントディレクトリを確認することを推奨します
- 同様のスクリプトが複数のプロジェクトディレクトリに存在します（capnproto、termbox、cppcheck、oatpp、symengine、tinyexpr、libsoundio、fmt、harfbuzz、tinyspline、tinyvm、simbody、re2、zstd、tmux、faiss、duckdb、box2d、cxxopts、drogon等）
- 各プロジェクトのスクリプトは同一の内容ですが、実行場所（カレントディレクトリ）によって削除対象が異なります
