# バッチ設計書 49-symbolize.sh

## 概要

本ドキュメントは、GWP-ASANクラッシュシンボル化スクリプト（symbolize.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、GWP-ASAN（Guarded Work Pool ASAN）のクラッシュレポートに含まれるスタックトレースをシンボル化するバッチです。backtrace_symbols()関数が出力する形式のアドレス情報を、addr2lineを使用してソースコードのファイル名と行番号に変換します。

**業務上の目的・背景**：GWP-ASANは、メモリエラー（use-after-free、buffer overflow等）を検出するためのサンプリングベースのメモリ安全性ツールです。クラッシュ発生時に出力されるスタックトレースは、通常はアドレスと関数オフセットの形式であり、デバッグには不便です。このスクリプトは、スタックトレースを人間が読みやすい形式（ソースファイル名と行番号）に変換し、バグの原因特定を容易にします。

**バッチの実行タイミング**：GWP-ASANによってクラッシュが検出され、スタックトレースが出力された後に手動で実行します。クラッシュレポートの解析時に使用されます。

**主要な処理内容**：
1. 標準入力から1行ずつスタックトレースを読み込み
2. シンボル化が必要な行かどうかを正規表現で判定
3. バイナリ名、関数名、オフセット、フレーム番号を抽出
4. 関数アドレスをnmで取得（関数相対オフセットの場合）
5. addr2lineでアドレスをシンボル化
6. シンボル化された結果を標準出力に出力

**前後の処理との関連**：GWP-ASANを有効にしてビルドされたアプリケーションのクラッシュレポートを入力として受け取ります。シンボル化されたスタックトレースは、開発者によるバグ調査に使用されます。

**影響範囲**：標準入出力のみ（ファイル変更なし）

## バッチ種別

デバッグ支援 / シンボル化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行（パイプ入力） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| addr2line | binutilsのaddr2lineコマンドがインストールされていること |
| nm | binutilsのnmコマンドがインストールされていること |
| デバッグ情報 | 対象バイナリにデバッグ情報（DWARF）が含まれていること |

### 実行可否判定

標準入力からデータが供給される場合に処理が開始されます。

## 入力仕様

### 入力パラメータ

本バッチはコマンドライン引数を受け取りません。標準入力からスタックトレースを読み込みます。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし（標準入力を使用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 標準入力 | テキスト | GWP-ASANスタックトレース |

### 入力形式

backtrace_symbols()出力形式：
```
#0 ./a.out(_foo+0x3e6) [0x55a52e64c696]
```

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | シンボル化されたスタックトレース |

### 出力ファイル仕様

本バッチはファイル出力を行いません。結果は標準出力に出力されます。

| 項目 | 内容 |
|-----|------|
| 出力形式 | "#N ファイル名:行番号"（シンボル化成功時） |
| 出力形式 | 元の行（シンボル化不可の場合） |

## 処理フロー

### 処理シーケンス

```
1. 標準入力からの行読み込み
   └─ while read -r line でループ

2. シンボル化対象判定
   └─ 正規表現で backtrace_symbols() 形式をチェック
   └─ 非対象行はそのまま出力

3. 行の解析
   └─ バイナリ名、関数名、関数オフセット、フレーム番号を抽出

4. シンボル化処理
   └─ 関数名がない場合: オフセットを直接addr2lineに渡す
   └─ 関数名がある場合: nmで関数アドレスを取得し、オフセットを加算

5. 結果の出力
   └─ シンボル化成功: フレーム番号 + シンボル情報を出力
   └─ シンボル化失敗: 元の行をそのまま出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[行を読み込み]
    B --> C{EOF?}
    C -->|Yes| D[バッチ終了]
    C -->|No| E{シンボル化対象?}
    E -->|No| F[元の行を出力]
    F --> B
    E -->|Yes| G[行を解析]
    G --> H{関数名あり?}
    H -->|No| I[オフセットで直接addr2line]
    H -->|Yes| J[nmで関数アドレス取得]
    J --> K{アドレス取得成功?}
    K -->|No| F
    K -->|Yes| L[アドレス計算]
    L --> M[addr2line実行]
    I --> M
    M --> N{シンボル化成功?}
    N -->|No| F
    N -->|Yes| O[シンボル情報を出力]
    O --> B
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル化失敗 | デバッグ情報がない場合 | デバッグビルドを使用 |
| - | 関数アドレス不明 | nmで関数が見つからない場合 | 元の行をそのまま出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

シンボル化に失敗した行は元の形式で出力されるため、処理は継続されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | スタックトレースの行数に依存 |
| 目標処理時間 | 行ごとにnm/addr2lineを実行するため、行数に比例 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特別な排他制御は不要です。読み取り専用の処理です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラー出力 | addr2line警告時 | DWARFエラー（抑制される） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のため、監視・アラート設定は不要です。

## 備考

- Scudo実装のGWP-ASANで使用されるbacktrace_symbols()形式に対応
- シンボル化対象の正規表現パターン: `^[ ]*\#.*\(.*\+0x[0-9a-f]+\) \[0x[0-9a-f]+\]$`
- addr2lineの-iオプション（インライン展開）を使用
- addr2lineの-eオプションでバイナリを指定
- addr2lineのDWARFエラー出力はgrepでフィルタリングされます
- 関数相対オフセットとバイナリ相対オフセットの両方に対応
