# バッチ設計書 5-test-release.sh

## 概要

本ドキュメントは、LLVMリリース候補のテストスクリプト「test-release.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMのリリース候補（RC）版をダウンロード、3段階のブートストラップビルド、テスト実行し、リリースパッケージを生成する包括的なテストスクリプトです。Phase 1でシステムコンパイラでビルド、Phase 2でPhase 1のClangでビルド、Phase 3でPhase 2のClangでビルドし、再現性を検証します。

**業務上の目的・背景**：LLVMリリースプロセスにおいて、リリース候補の品質を保証することは極めて重要です。本バッチは、3段階のブートストラップビルドにより、コンパイラが自身をコンパイルできることを検証し、Phase 2とPhase 3のオブジェクトファイルを比較することで再現性ビルドを確認します。これにより、リリース前に深刻な問題を検出できます。

**バッチの実行タイミング**：リリースマネージャーまたはテスターが、リリース候補の検証時に手動で実行します。

**主要な処理内容**：
1. コマンドライン引数の解析（リリースバージョン、RC番号、ターゲットトリプル等）
2. ソースコードのダウンロード（GitHubからtarball取得）
3. test-suiteのセットアップ（オプション）
4. Phase 1ビルド：システムコンパイラでClangをビルド
5. Phase 2ビルド：Phase 1のClangでLLVM/Clang/ランタイムをビルド
6. Phase 3ビルド：Phase 2のClangで全プロジェクトをビルド
7. Phase 3のテスト実行（check-all、test-suite）
8. Phase 2/3のオブジェクトファイル比較
9. リリースパッケージ（tarball）の生成

**前後の処理との関連**：本バッチは独立して実行されます。生成されたtarballはリリースプロセスで配布用に使用されます。

**影響範囲**：ビルドディレクトリ内に3段階のビルド成果物、ログファイル、リリースパッケージを生成します。

## バッチ種別

リリーステスト・パッケージ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース候補ごと（数週間に1回程度） |
| 実行時刻 | 手動実行 |
| 実行曜日 | 該当なし |
| 実行日 | リリーススケジュールに依存 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド環境 | C/C++コンパイラ、CMake、make/ninjaが利用可能 |
| chrpath | Linux/Unix環境ではchrpathが必要（Darwin/SunOS/AIX除く） |
| file, objdump | Darwin以外の環境で必要 |
| curl | GitHubからソースをダウンロード |
| Python3 | test-suite実行時に必要 |

### 実行可否判定

-releaseと-rcオプション（または-final）が必須。-tripleオプションでターゲットトリプルの指定が必須。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -release | string | Yes | なし | リリースバージョン（X.Y.Z形式） |
| -rc | number | Yes* | なし | RC番号（-finalと排他） |
| -final | flag | Yes* | なし | 最終リリースフラグ（-rcと排他） |
| -triple | string | Yes | なし | ターゲットトリプル |
| -j | number | No | 自動検出 | 並列ビルドジョブ数 |
| -build-dir | string | No | pwd | ビルドディレクトリ |
| -no-checkout | flag | No | なし | ソースダウンロードをスキップ |
| -test-debug | flag | No | なし | Debugビルドをテスト |
| -test-asserts | flag | No | なし | Assertsビルドをテスト |
| -no-compare-files | flag | No | なし | Phase比較をスキップ |
| -use-gzip | flag | No | なし | xzの代わりにgzipを使用 |
| -use-ninja | flag | No | なし | makeの代わりにninjaを使用 |
| -git-ref | string | No | なし | 特定のgit refをテスト |
| -no-rt | flag | No | なし | compiler-rtを除外 |
| -no-clang-tools | flag | No | なし | clang-tools-extraを除外 |
| -no-libs | flag | No | なし | libc++/libcxxabi/libunwindを除外 |
| -no-test-suite | flag | No | なし | test-suiteを除外 |
| -no-openmp | flag | No | なし | openmpを除外 |
| -no-lld | flag | No | なし | lldを除外 |
| -lldb | flag | No | なし | lldbを含める |
| -no-polly | flag | No | なし | pollyを除外 |
| -no-mlir | flag | No | なし | mlirを除外 |
| -no-flang | flag | No | なし | flangを除外 |
| -bolt | flag | No | Linux x86_64/ARM64 | boltを含める |
| -silent-log | flag | No | なし | ビルドログを抑制 |
| -use-cmake-cache | flag | No | なし | CMakeキャッシュを使用 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHubリポジトリ | tarball | llvm-projectソースコード |
| test-suiteリポジトリ | tarball | LLVMテストスイート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${BuildDir}/${RC}/ | ディレクトリ | ビルド作業ディレクトリ |
| ${BuildDir}/logs/ | ディレクトリ | ビルド・テストログ |
| ${BuildDir}/$Package.tar.xz | tarball | リリースパッケージ |
| ${BuildDir}/$Package.tar.gz | tarball | リリースパッケージ（gzip使用時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | clang+llvm-{VERSION}-{RC}-{TRIPLE}.tar.xz |
| 出力先 | ${BuildDir}/ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ リリースバージョン、RC、オプション取得
2. 必須プログラム確認
   └─ chrpath, file, objdump, make/ninja
3. ソースエクスポート
   └─ GitHubからtarballダウンロード・展開
4. test-suiteセットアップ（オプション）
   └─ Python venv作成、litインストール
5. Phase 1ビルド
   └─ システムコンパイラでClangビルド
6. Phase 2ビルド
   └─ Phase 1 ClangでLLVM/Clang/ランタイムビルド
7. Phase 3ビルド
   └─ Phase 2 Clangで全プロジェクトビルド
8. Phase 3テスト
   └─ check-all、test-suite実行
9. Phase比較
   └─ Phase 2/3のオブジェクトファイル比較
10. パッケージ生成
    └─ tarball作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[必須プログラム確認]
    C --> D{checkout?}
    D -->|Yes| E[ソースダウンロード]
    D -->|No| F[Phase 1ビルド]
    E --> F
    F --> G[Phase 2ビルド]
    G --> H[Phase 3ビルド]
    H --> I[Phase 3テスト]
    I --> J{compare?}
    J -->|Yes| K[Phase 2/3比較]
    J -->|No| L[パッケージ生成]
    K --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 必須オプション未指定 | usage表示、オプション確認 |
| 1 | 依存関係エラー | MLIRなしでFlangビルド | -no-flangを指定 |
| 1 | 環境エラー | 必須プログラムが見つからない | 必要なツールをインストール |
| 非0 | ビルドエラー | CMake/make/ninjaが失敗 | ログを確認 |
| 非0 | テストエラー | check-allが失敗 | deferred_errors.logを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. logs/ディレクトリのビルドログを確認
2. deferred_errors.logでテスト失敗を確認
3. -no-*オプションで問題のあるコンポーネントを除外して再試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 3段階のフルビルド + テスト |
| 目標処理時間 | 数時間〜1日（環境・オプション依存） |
| メモリ使用量上限 | 環境依存（数十GB推奨） |

## 排他制御

同一BuildDirでの同時実行は不可。各Phaseディレクトリは実行前にクリアされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定ログ | ビルド開始時 | リリースバージョン、ビルド種別、システム情報 |
| ビルドログ | 各Phase実行時 | llvm.configure-*.log, llvm.make-*.log, llvm.install-*.log |
| テストログ | テスト実行時 | llvm.check-*.log |
| エラーログ | エラー発生時 | deferred_errors.log |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 異常な長時間 | 手動確認 |
| テスト失敗 | 1件以上 | deferred_errors.log |

## 備考

- ulimit -c 0でコアダンプを無効化（ディスク溢れ防止）
- set -eとset -o pipefailでエラー時に即座に停止
- chrpathでRPATHをクリーンアップ（$ORIGINのみ保持）
- Phase比較ではビルドパス文字列を正規化して比較
- AIXではPhase 1でcompiler-rt builtinsが必要
- 対応プラットフォーム：Linux、macOS（Darwin）、FreeBSD、SunOS、AIX
- Linux x86_64/ARM64ではBOLTがデフォルト有効
