# バッチ設計書 50-check_custom_wrappers.sh

## 概要

本ドキュメントは、DFSanカスタムラッパーチェックスクリプト（check_custom_wrappers.sh）のバッチ設計書です。

### 本バッチの処理概要

本スクリプトは、DataFlowSanitizer（DFSan）のカスタムラッパー関数の整合性をチェックするバッチです。ABIリスト（done_abilist.txt）で定義されたカスタム関数と、実装されたラッパー関数（dfsan_custom.cpp）、およびテストコード（custom.cpp）の間の整合性を検証します。

**業務上の目的・背景**：DFSanはデータフロー解析を行うサニタイザーで、特定の標準ライブラリ関数に対してカスタムラッパーを提供しています。これらのラッパーは、ABIリストで宣言され、dfsan_custom.cppで実装され、custom.cppでテストされる必要があります。このスクリプトは、これらの3つのソース間の不整合を検出し、ラッパーの追加・削除時のミスを防ぎます。

**バッチの実行タイミング**：DFSanのカスタムラッパーを追加・変更した後、コミット前の検証として実行します。CIパイプラインでの自動チェックにも使用できます。

**主要な処理内容**：
1. ABIリストからカスタム関数名を抽出
2. dfsan_custom.cppからラッパー関数名（__dfsw_*）を抽出
3. ABIリストとラッパー実装の差分を検出
4. ラッパー実装とテストコードの差分を検出
5. 差分がある場合はエラーメッセージを出力して終了コード1で終了

**前後の処理との関連**：DFSanの開発・保守において、カスタムラッパーの追加・変更後に実行されます。CIでの自動テストの一部として使用することも想定されています。

**影響範囲**：標準出力・標準エラー出力のみ（ファイル変更なし）

## バッチ種別

検証 / 整合性チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動・CI） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ファイル配置 | 相対パスでdfsan関連ファイルにアクセス可能 |
| シェル | /bin/shが利用可能 |

### 実行可否判定

スクリプトが配置されているディレクトリからの相対パスで、必要なファイルにアクセスできる場合に実行可能です。

## 入力仕様

### 入力パラメータ

本バッチはコマンドライン引数を受け取りません。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| done_abilist.txt | テキスト | DFSan ABIリスト（カスタム関数定義） |
| dfsan_custom.cpp | C++ソース | カスタムラッパー実装 |
| custom.cpp | C++ソース | カスタムラッパーテスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/標準エラー | テキスト | 差分情報（エラー時のみ） |

### 出力ファイル仕様

本バッチはファイル出力を行いません。一時ファイルは処理完了後に削除されます。

| 項目 | 内容 |
|-----|------|
| 終了コード | 0: 整合性OK、1: 差分あり |

## 処理フロー

### 処理シーケンス

```
1. パス設定
   └─ DFSAN_DIR, DFSAN_CUSTOM_TESTS, DFSAN_CUSTOM_WRAPPERS, DFSAN_ABI_LISTを設定

2. 一時ファイル作成
   └─ DIFFOUT, ERRORLOG, DIFF_A, DIFF_Bを作成

3. ABIリストとラッパー実装の比較
   └─ ABIリストから"fun:*=custom"の関数名を抽出
   └─ dfsan_custom.cppから__dfsw_*関数名を抽出
   └─ __sanitizer_cov_trace*は除外
   └─ diffで比較、差分があればエラーログに追記

4. ラッパー実装とテストの比較
   └─ dfsan_custom.cppから__dfsw_*関数名を抽出
   └─ custom.cppからtest_*()関数名を抽出
   └─ diffで比較、差分があればエラーログに追記

5. 結果判定
   └─ エラーログが空でなければエラーメッセージを表示
   └─ 終了コード1で終了

6. クリーンアップ
   └─ trapでEXIT時に一時ファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パス設定]
    B --> C[一時ファイル作成]
    C --> D[ABIリストから関数抽出]
    D --> E[ラッパー実装から関数抽出]
    E --> F[diff比較1]
    F --> G{差分あり?}
    G -->|Yes| H[エラーログに追記]
    G -->|No| I[継続]
    H --> I
    I --> J[ラッパーから関数抽出]
    J --> K[テストから関数抽出]
    K --> L[diff比較2]
    L --> M{差分あり?}
    M -->|Yes| N[エラーログに追記]
    M -->|No| O[結果確認]
    N --> O
    O --> P{エラーログ空?}
    P -->|Yes| Q[正常終了 code=0]
    P -->|No| R[エラー出力 code=1]
    Q --> S[クリーンアップ]
    R --> S
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 整合性エラー | ABIリストとラッパー実装の不一致 | 不足・余分な関数を追加/削除 |
| 1 | 整合性エラー | ラッパー実装とテストの不一致 | テスト関数を追加/削除 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

差分が検出された場合は、エラーメッセージに従って不足・余分な関数を修正してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイル3つ |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特別な排他制御は不要です。読み取り専用の処理です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 差分検出時 | ABIリスト/ラッパー/テスト間の差分 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | CI/CDシステム |

## 備考

- __sanitizer_cov_trace*関数は別の場所で実装されているため、チェック対象から除外されます
- dfsan_get_label、dfsan_get_originもチェック対象から除外されます
- trapコマンドでEXIT時に一時ファイルのクリーンアップを保証します
- diff -uでunified形式の差分を出力します
- 関数名の抽出にはgrep、sed、sort、uniqを使用します
- ABIリストの形式: "fun:関数名=custom"
- ラッパー関数の命名規則: __dfsw_関数名
- テスト関数の命名規則: test_関数名()
