# バッチ設計書 6-build-docs.sh

## 概要

本ドキュメントは、LLVMリリース用ドキュメントビルドスクリプト「build-docs.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMリリース用のドキュメント（SphinxおよびDoxygen形式）をビルドするスクリプトです。LLVM、Clang、clang-tools-extra、LLD、Polly、Flang、libc++の各プロジェクトのドキュメントを生成し、配布用にパッケージングします。

**業務上の目的・背景**：LLVMの公式リリースには、API リファレンス（Doxygen）とユーザーガイド（Sphinx）の両方のドキュメントが含まれる必要があります。本バッチは、これらのドキュメントを自動的にビルドし、リリースパッケージとして配布可能な形式に整理します。これにより、リリースプロセスにおけるドキュメント生成を標準化し、品質を確保します。

**バッチの実行タイミング**：リリースマネージャーが最終リリース（-final）の準備時に手動で実行します。

**主要な処理内容**：
1. コマンドライン引数の解析（リリースバージョン、ソースディレクトリ、オプション）
2. リリースバージョン指定時はGitHubからソースをダウンロード
3. CMakeでビルド構成（Sphinx/Doxygenオプション有効化）
4. Ninjaでドキュメントターゲットをビルド
5. ランタイム用ドキュメント（libc++）の別途ビルド
6. Doxygenドキュメントをtarballとしてパッケージング
7. Sphinxドキュメントをhtml-exportディレクトリに整理

**前後の処理との関連**：本バッチは独立して実行されます。生成されたドキュメントはリリースプロセスでWebサイト公開やパッケージ配布に使用されます。

**影響範囲**：docs-buildディレクトリ内にビルド成果物、html-export、Doxygen tarballを生成します。

## バッチ種別

ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリースごと（最終リリース時） |
| 実行時刻 | 手動実行 |
| 実行曜日 | 該当なし |
| 実行日 | リリーススケジュールに依存 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド環境 | CMake、Ninja、GCC/Clangが利用可能 |
| Doxygen | Doxygenがインストール済み |
| Sphinx | pip install -r llvm/docs/requirements.txtが実行済み |
| graphviz | グラフ生成用（Ubuntu） |
| texlive | epstopdf用（Fedora） |

### 実行可否判定

-releaseと-srcdirは排他的（両方指定不可）。-no-doxygenと-no-sphinxの同時指定は不可。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -release | string | No | なし | リリースバージョン（X.Y.Z形式） |
| -srcdir | string | No | スクリプトの相対パス | ソースディレクトリパス |
| -no-doxygen | flag | No | なし | Doxygenビルドを無効化 |
| -no-sphinx | flag | No | なし | Sphinxビルドを無効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| LLVMソースコード | ディレクトリ | llvm/、clang/、lld/等のソース |
| GitHubリポジトリ | tarball | -release指定時にダウンロード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs-build/ | ディレクトリ | ビルド作業ディレクトリ |
| llvm_doxygen-{release}.tar.xz | tarball | LLVM Doxygenドキュメント |
| clang_doxygen-{release}.tar.xz | tarball | Clang Doxygenドキュメント |
| clang-tools-extra_doxygen-{release}.tar.xz | tarball | clang-tools-extra Doxygenドキュメント |
| flang_doxygen-{release}.tar.xz | tarball | Flang Doxygenドキュメント |
| docs-build/html-export/ | ディレクトリ | Sphinxドキュメント（HTML） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {project}_doxygen-{release}.tar.xz |
| 出力先 | カレントディレクトリ |
| 文字コード | UTF-8（HTML） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ リリースバージョン、ソースディレクトリ、オプション取得
2. 排他チェック
   └─ -release/-srcdir、-no-doxygen/-no-sphinx
3. ソース取得（-release指定時）
   └─ GitHubからtarballダウンロード・展開
4. CMake構成（メインプロジェクト）
   └─ LLVM_ENABLE_SPHINX、LLVM_ENABLE_DOXYGEN設定
5. Ninjaビルド（メインプロジェクト）
   └─ docs-*-html、doxygen-*ターゲット
6. CMake構成（ランタイム）
   └─ libcxx/libcxxabi/libunwindドキュメント用
7. Ninjaビルド（ランタイム）
   └─ docs-libcxx-html
8. Doxygenパッケージング
   └─ tarball生成
9. Sphinx整理
   └─ html-exportディレクトリに配置
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{-release指定?}
    C -->|Yes| D[GitHubからソースDL]
    C -->|No| E[ローカルソース使用]
    D --> F[CMake構成]
    E --> F
    F --> G{Sphinx有効?}
    G -->|Yes| H[Sphinxターゲット設定]
    G -->|No| I{Doxygen有効?}
    H --> I
    I -->|Yes| J[Doxygenターゲット設定]
    I -->|No| K[Ninjaビルド]
    J --> K
    K --> L[ランタイムドキュメントビルド]
    L --> M{Doxygen有効?}
    M -->|Yes| N[Doxygenパッケージング]
    M -->|No| O{Sphinx有効?}
    N --> O
    O -->|Yes| P[Sphinxドキュメント整理]
    O -->|No| Q[バッチ終了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | -releaseと-srcdir両方指定 | どちらか一方のみ指定 |
| 1 | 引数エラー | -no-doxygenと-no-sphinx両方指定 | どちらか一方のみ指定 |
| 1 | 環境エラー | llvm-projectディレクトリが既存 | 既存ディレクトリを削除 |
| 非0 | ビルドエラー | CMake/Ninjaが失敗 | ログを確認、依存パッケージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. CMake/Ninjaのエラーメッセージを確認
2. SphinxまたはDoxygenの依存パッケージを確認
3. 必要なパッケージをインストールして再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のドキュメントビルド |
| 目標処理時間 | 数十分〜1時間（環境依存） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの同時実行は不可。llvm-projectディレクトリの重複チェックあり。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | オプション確認時 | "Sphinx: enabled/disabled"、"Doxygen: enabled/disabled" |
| ビルドログ | Ninja実行時 | 標準出力にビルド進捗 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 異常な長時間 | 手動確認 |
| 終了コード | 非0 | 手動確認 |

## 備考

- Sphinxターゲット：docs-clang-html、docs-clang-tools-html、docs-flang-html、docs-lld-html、docs-llvm-html、docs-polly-html
- Doxygenターゲット：doxygen-clang、doxygen-clang-tools、doxygen-flang、doxygen-llvm、doxygen-mlir、doxygen-polly
- ランタイムドキュメント（libc++）は別のCMake構成で生成
- libc++ドキュメントは後方互換性のためprojects/配下に配置
- SPHINX_WARNINGS_AS_ERRORS=OFFで警告を無視
- 必要パッケージ
  - Fedora: doxygen texlive-epstopdf ghostscript ninja-build gcc-c++
  - Ubuntu: doxygen ninja-build graphviz texlive-font-utils
